/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.configs;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import it.hurts.sskirillss.relics.configs.RelicConfig;
import it.hurts.sskirillss.relics.configs.SpecificRelicConfig;
import it.hurts.sskirillss.relics.configs.variables.RuneConfig;
import it.hurts.sskirillss.relics.configs.variables.crafting.RuneIngredients;
import it.hurts.sskirillss.relics.configs.variables.durability.RelicDurability;
import it.hurts.sskirillss.relics.configs.variables.level.RelicLevel;
import it.hurts.sskirillss.relics.configs.variables.stats.RelicStats;
import it.hurts.sskirillss.relics.configs.variables.worldgen.RelicLoot;
import it.hurts.sskirillss.relics.configs.variables.worldgen.RuneLoot;
import it.hurts.sskirillss.relics.init.ItemRegistry;
import it.hurts.sskirillss.relics.items.RelicItem;
import it.hurts.sskirillss.relics.items.RuneItem;
import it.hurts.sskirillss.relics.utils.RelicUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.registries.ForgeRegistries;

public class JSONManager {
    private static final Gson SERIALIZER = new GsonBuilder().setPrettyPrinting().serializeNulls().disableHtmlEscaping().create();

    public static void setupJSONConfig() {
        JSONManager.setupRelicsConfig();
        JSONManager.setupRunesConfig();
    }

    protected static void setupRelicsConfig() {
        Path dir = FMLPaths.CONFIGDIR.get().resolve("relics").resolve("items").resolve("relics");
        try {
            Files.createDirectories(dir, new FileAttribute[0]);
            for (RegistryObject registryObject : ItemRegistry.ITEMS.getEntries()) {
                Item item;
                if (!registryObject.isPresent() || !((item = (Item)registryObject.get()) instanceof RelicItem)) continue;
                RelicItem relic = (RelicItem)item;
                JSONManager.setupRelic(dir, relic);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected static void setupRunesConfig() {
        Path dir = FMLPaths.CONFIGDIR.get().resolve("relics").resolve("items").resolve("runes");
        try {
            Files.createDirectories(dir, new FileAttribute[0]);
            for (RegistryObject registryObject : ItemRegistry.ITEMS.getEntries()) {
                Item item;
                if (!registryObject.isPresent() || !((item = (Item)registryObject.get()) instanceof RuneItem)) continue;
                RuneItem rune = (RuneItem)item;
                RuneIngredients defaultIngredients = new RuneIngredients(rune.getIngredients().stream().map(runeItem -> runeItem.getRegistryName().func_110624_b() + ":" + runeItem.getRegistryName().func_110623_a()).collect(Collectors.toList()));
                RuneLoot defaultLoot = new RuneLoot(rune.getLootChests().stream().map(ResourceLocation::toString).collect(Collectors.toList()), rune.getWorldgenChance());
                RuneConfig defaultConfig = new RuneConfig(defaultIngredients, defaultLoot);
                Path path = dir.resolve(rune.getRegistryName().func_110623_a() + ".json");
                if (!Files.exists(path, new LinkOption[0])) {
                    BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);
                    SERIALIZER.toJson((Object)defaultConfig, (Appendable)writer);
                    ((Writer)writer).flush();
                    ((Writer)writer).close();
                }
                BufferedReader reader = Files.newBufferedReader(path);
                RuneConfig config = (RuneConfig)SERIALIZER.fromJson((Reader)reader, RuneConfig.class);
                List ingredients = config.getIngredients().getIngredients().stream().map(location -> {
                    String[] pair = location.split(":");
                    return (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(pair[0], pair[1]));
                }).collect(Collectors.toList());
                RuneLoot loot = config.getLoot();
                RelicUtils.Crafting.INGREDIENTS.put(rune, ingredients);
                RelicUtils.RunesWorldgen.LOOT.put(rune, loot);
                ((Reader)reader).close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected static <T extends RelicStats> void setupRelic(Path dir, RelicItem<T> relic) throws IOException {
        Path path = dir.resolve(relic.getRegistryName().func_110623_a() + ".json");
        RelicStats defaultStats = null;
        try {
            defaultStats = (RelicStats)relic.getConfigClass().newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        RelicLoot defaultLoot = new RelicLoot(relic.getLootChests().stream().map(ResourceLocation::toString).collect(Collectors.toList()), relic.getWorldgenChance());
        RelicLevel defaultLevel = new RelicLevel(relic.getMaxLevel(), relic.getInitialExp(), relic.getExpRatio());
        RelicDurability defaultDurability = new RelicDurability(relic.getDurability());
        SpecificRelicConfig<RelicStats> defaultConfig = new SpecificRelicConfig<RelicStats>(defaultStats, defaultLoot, defaultLevel, defaultDurability);
        if (!Files.exists(path, new LinkOption[0])) {
            JSONManager.setupDefaultConfig(path, defaultConfig);
        }
        SpecificRelicConfig<T> relicConfig = JSONManager.getConfig(path, relic);
        JSONManager.register(relic, relicConfig);
    }

    protected static <T extends RelicStats> SpecificRelicConfig<T> getConfig(Path path, RelicItem<T> relicItem) {
        SpecificRelicConfig<RelicStats> result = null;
        try {
            BufferedReader reader = Files.newBufferedReader(path);
            RelicConfig config = (RelicConfig)SERIALIZER.fromJson((Reader)reader, RelicConfig.class);
            ((Reader)reader).close();
            RelicStats stats = (RelicStats)SERIALIZER.fromJson((JsonElement)config.getStats(), relicItem.getConfigClass());
            RelicLoot loot = config.getLoot();
            RelicLevel level = config.getLevel();
            RelicDurability durability = config.getDurability();
            result = new SpecificRelicConfig<RelicStats>(stats, loot, level, durability);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }

    protected static <T extends RelicStats> void setupDefaultConfig(Path path, SpecificRelicConfig<T> config) throws IOException {
        T defaultStats = config.getStats();
        RelicConfig abstractConfig = new RelicConfig((JsonObject)SERIALIZER.toJsonTree(defaultStats, defaultStats.getClass()), config.getLoot(), config.getLevel(), config.getDurability());
        BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);
        SERIALIZER.toJson((Object)abstractConfig, (Appendable)writer);
        ((Writer)writer).flush();
        ((Writer)writer).close();
    }

    protected static <T extends RelicStats> void register(RelicItem<T> relicItem, SpecificRelicConfig<T> config) {
        relicItem.setConfig(config.getStats());
        RelicUtils.Worldgen.LOOT.put(relicItem, config.getLoot());
        RelicUtils.Level.LEVEL.put(relicItem, config.getLevel());
        RelicUtils.Durability.DURABILITY.put(relicItem, config.getDurability());
    }
}

