/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.crafting;

import it.hurts.sskirillss.relics.init.ItemRegistry;
import it.hurts.sskirillss.relics.init.RecipeRegistry;
import it.hurts.sskirillss.relics.items.RelicItem;
import it.hurts.sskirillss.relics.utils.NBTUtils;
import it.hurts.sskirillss.relics.utils.RelicUtils;
import javax.annotation.Nonnull;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.SpecialRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class RelicOwnerRecipe
extends SpecialRecipe {
    public RelicOwnerRecipe(ResourceLocation location) {
        super(location);
    }

    public boolean matches(@Nonnull CraftingInventory inv, @Nonnull World world) {
        boolean foundContract = false;
        boolean foundRelic = false;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack.func_190926_b()) continue;
            if (stack.func_77973_b() instanceof RelicItem && !foundRelic) {
                foundRelic = true;
                continue;
            }
            if (stack.func_77973_b() == ItemRegistry.RELIC_CONTRACT.get() && NBTUtils.getInt(stack, "blood", 0) >= 4 && !RelicUtils.Owner.getOwnerUUID(stack).toString().equals("") && !foundContract) {
                foundContract = true;
                continue;
            }
            return false;
        }
        return foundRelic && foundContract;
    }

    @Nonnull
    public ItemStack assemble(@Nonnull CraftingInventory inv) {
        ItemStack relic = ItemStack.field_190927_a;
        ItemStack contract = ItemStack.field_190927_a;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack.func_190926_b()) continue;
            if (stack.func_77973_b() instanceof RelicItem && relic.func_190926_b()) {
                relic = stack;
                continue;
            }
            if (!contract.func_190926_b()) continue;
            contract = stack;
        }
        if (relic.func_190926_b() || contract.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        ItemStack result = relic.func_77946_l();
        RelicUtils.Owner.setOwnerUUID(result, RelicUtils.Owner.getOwnerUUID(contract));
        NBTUtils.setLong(result, "date", 0L);
        return result;
    }

    public boolean func_194133_a(int width, int height) {
        return width > 1 || height > 1;
    }

    @Nonnull
    public IRecipeSerializer<?> func_199559_b() {
        return (IRecipeSerializer)RecipeRegistry.RELIC_OWNER.get();
    }
}

