/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.crafting;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import it.hurts.sskirillss.relics.crafting.RunicAltarContext;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistryEntry;
import net.minecraftforge.registries.ObjectHolder;
import org.jetbrains.annotations.Nullable;

public class RunicAltarRecipe
implements IRecipe<RunicAltarContext> {
    private final ResourceLocation id;
    private final NonNullList<Ingredient> inputs;
    private final ItemStack output;
    @ObjectHolder(value="relics:runic_altar")
    public static IRecipeSerializer<?> SERIALIZER = null;
    public static IRecipeType<RunicAltarRecipe> RECIPE = IRecipeType.func_222147_a((String)new ResourceLocation("relics", "runic_altar").toString());

    public RunicAltarRecipe(ResourceLocation id, NonNullList<Ingredient> inputs, ItemStack output) {
        this.id = id;
        this.inputs = inputs;
        this.output = output;
    }

    public boolean func_194133_a(int width, int height) {
        return true;
    }

    public NonNullList<Ingredient> func_192400_c() {
        return this.inputs;
    }

    public boolean matches(RunicAltarContext context, World worldIn) {
        ItemStack input;
        if (this.inputs.isEmpty()) {
            return false;
        }
        ArrayList<Ingredient> ingredients = new ArrayList<Ingredient>((Collection<Ingredient>)this.inputs);
        for (int i = 0; i < context.getInputs().size() && !(input = context.getInputs().get(i)).func_190926_b(); ++i) {
            int index = -1;
            for (int j = 0; j < ingredients.size(); ++j) {
                if (!((Ingredient)ingredients.get(j)).test(input)) continue;
                index = j;
                break;
            }
            if (index == -1) {
                return false;
            }
            ingredients.remove(index);
        }
        return ingredients.isEmpty();
    }

    public ItemStack assemble(RunicAltarContext context) {
        return this.output.func_77946_l();
    }

    public ItemStack func_77571_b() {
        return this.output;
    }

    public ResourceLocation func_199560_c() {
        return this.id;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return SERIALIZER;
    }

    public IRecipeType<?> func_222127_g() {
        return RECIPE;
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<RunicAltarRecipe> {
        public RunicAltarRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            NonNullList inputs = NonNullList.func_191196_a();
            inputs.add((Object)Ingredient.func_199802_a((JsonElement)JSONUtils.func_152754_s((JsonObject)json, (String)"input")));
            JsonArray ingredients = JSONUtils.func_151214_t((JsonObject)json, (String)"ingredients");
            for (int i = 0; i < ingredients.size(); ++i) {
                inputs.add((Object)Ingredient.func_199802_a((JsonElement)ingredients.get(i)));
            }
            return new RunicAltarRecipe(recipeId, (NonNullList<Ingredient>)inputs, ShapedRecipe.func_199798_a((JsonObject)json.getAsJsonObject("result")));
        }

        @Nullable
        public RunicAltarRecipe fromNetwork(ResourceLocation recipeId, PacketBuffer buffer) {
            int size = buffer.func_150792_a();
            NonNullList inputs = NonNullList.func_191197_a((int)size, (Object)Ingredient.field_193370_a);
            for (int i = 0; i < size; ++i) {
                inputs.set(i, (Object)Ingredient.func_199566_b((PacketBuffer)buffer));
            }
            return new RunicAltarRecipe(recipeId, (NonNullList<Ingredient>)inputs, buffer.func_150791_c());
        }

        public void toNetwork(PacketBuffer buffer, RunicAltarRecipe recipe) {
            buffer.func_150787_b(recipe.inputs.size());
            for (Ingredient ingredient : recipe.inputs) {
                ingredient.func_199564_a(buffer);
            }
            buffer.func_150788_a(recipe.output);
        }
    }
}

