/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.entities;

import it.hurts.sskirillss.relics.init.EntityRegistry;
import it.hurts.sskirillss.relics.items.relics.ShadowGlaiveItem;
import it.hurts.sskirillss.relics.particles.circle.CircleTintData;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import java.awt.Color;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.ThrowableEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;

public class ShadowGlaiveEntity
extends ThrowableEntity {
    private static final DataParameter<Integer> BOUNCES = EntityDataManager.func_187226_a(ShadowGlaiveEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Float> DAMAGE = EntityDataManager.func_187226_a(ShadowGlaiveEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<String> OWNER = EntityDataManager.func_187226_a(ShadowGlaiveEntity.class, (IDataSerializer)DataSerializers.field_187194_d);
    private static final DataParameter<String> TARGET = EntityDataManager.func_187226_a(ShadowGlaiveEntity.class, (IDataSerializer)DataSerializers.field_187194_d);
    private static final DataParameter<String> BOUNCED_ENTITIES = EntityDataManager.func_187226_a(ShadowGlaiveEntity.class, (IDataSerializer)DataSerializers.field_187194_d);
    private static final String TAG_BOUNCES_AMOUNT = "bounces";
    private static final String TAG_DAMAGE_AMOUNT = "damage";
    private static final String TAG_OWNER_UUID = "owner";
    private static final String TAG_TARGET_UUID = "target";
    private static final String TAG_BOUNCED_ENTITIES = "entities";
    private float damage;
    private PlayerEntity owner;
    private LivingEntity target;

    public ShadowGlaiveEntity(EntityType<? extends ShadowGlaiveEntity> type, World worldIn) {
        super(type, worldIn);
    }

    public ShadowGlaiveEntity(World world, LivingEntity throwerIn) {
        super((EntityType)EntityRegistry.SHADOW_GLAIVE.get(), throwerIn, world);
    }

    public void setOwner(PlayerEntity playerIn) {
        this.owner = playerIn;
        if (playerIn != null) {
            this.field_70180_af.func_187227_b(OWNER, (Object)playerIn.func_110124_au().toString());
        }
    }

    public void setTarget(LivingEntity target) {
        this.target = target;
        if (target != null) {
            this.field_70180_af.func_187227_b(TARGET, (Object)target.func_110124_au().toString());
        }
    }

    public void setDamage(float damage) {
        this.damage = damage;
        this.field_70180_af.func_187227_b(DAMAGE, (Object)Float.valueOf(damage));
    }

    private void locateNearestTarget() {
        ShadowGlaiveItem.Stats config = (ShadowGlaiveItem.Stats)ShadowGlaiveItem.INSTANCE.getConfig();
        int bounces = (Integer)this.field_70180_af.func_187225_a(BOUNCES);
        if (this.field_70170_p.func_201674_k().nextFloat() < Math.min(1.0f, (float)bounces * config.bounceChanceMultiplier)) {
            this.func_70106_y();
            return;
        }
        String bouncedEntitiesString = (String)this.field_70180_af.func_187225_a(BOUNCED_ENTITIES);
        List<String> bouncedEntities = Arrays.asList(bouncedEntitiesString.split(","));
        List entitiesAround = this.field_70170_p.func_217357_a(LivingEntity.class, this.func_174813_aQ().func_186662_g((double)config.bounceRadius));
        entitiesAround.removeIf(target -> bouncedEntities.contains(target.func_110124_au().toString()) || target == this.owner);
        entitiesAround.sort((o1, o2) -> (int)Math.round(o1.func_213303_ch().func_72438_d(o2.func_213303_ch())));
        if (entitiesAround.isEmpty()) {
            this.func_70106_y();
            return;
        }
        LivingEntity target2 = null;
        for (LivingEntity entity : entitiesAround) {
            if (entity == null || !entity.func_70089_S()) continue;
            target2 = entity;
            break;
        }
        if (target2 == null || !target2.func_70089_S()) {
            this.func_70106_y();
            return;
        }
        this.setTarget(target2);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        ShadowGlaiveItem.Stats config = (ShadowGlaiveItem.Stats)ShadowGlaiveItem.INSTANCE.getConfig();
        this.field_70170_p.func_195594_a((IParticleData)new CircleTintData(new Color(0.5f, 0.05f, 0.7f), 0.1f, 40, 0.95f, false), this.field_70169_q, this.field_70167_r, this.field_70166_s, 0.0, 0.0, 0.0);
        if (this.field_70170_p.func_201670_d()) {
            return;
        }
        if (this.field_70173_aa > 300) {
            this.func_70106_y();
        }
        if (this.target == null) {
            this.locateNearestTarget();
        }
        if (this.target.func_70089_S()) {
            EntityUtils.moveTowardsPosition((Entity)this, new Vector3d(this.target.func_226277_ct_(), this.target.func_226278_cu_() + (double)(this.target.func_213302_cg() * 0.5f), this.target.func_226281_cx_()), config.projectileSpeed);
        } else {
            this.locateNearestTarget();
        }
    }

    protected void func_70227_a(@Nonnull RayTraceResult rayTraceResult) {
        if (this.field_70170_p.func_201670_d()) {
            return;
        }
        ShadowGlaiveItem.Stats config = (ShadowGlaiveItem.Stats)ShadowGlaiveItem.INSTANCE.getConfig();
        switch (rayTraceResult.func_216346_c()) {
            case BLOCK: {
                if (!this.field_70170_p.func_180495_p(((BlockRayTraceResult)rayTraceResult).func_216350_a()).func_200132_m()) break;
                this.func_70106_y();
                break;
            }
            case ENTITY: {
                String bouncedEntitiesString;
                List<String> bouncedEntities;
                EntityRayTraceResult entityRayTraceResult = (EntityRayTraceResult)rayTraceResult;
                if (!(entityRayTraceResult.func_216348_a() instanceof LivingEntity)) {
                    return;
                }
                LivingEntity entity = (LivingEntity)entityRayTraceResult.func_216348_a();
                if (entity == this.owner) {
                    return;
                }
                int bounces = (Integer)this.field_70180_af.func_187225_a(BOUNCES);
                if (bounces > config.maxBounces) {
                    this.func_70106_y();
                }
                if (!(bouncedEntities = Arrays.asList((bouncedEntitiesString = (String)this.field_70180_af.func_187225_a(BOUNCED_ENTITIES)).split(","))).contains(entity.func_110124_au().toString())) {
                    entity.func_70097_a(this.owner != null ? DamageSource.func_76365_a((PlayerEntity)this.owner) : DamageSource.field_76377_j, Math.max(config.minDamagePerBounce, this.damage - (float)bounces * (this.damage * config.damageMultiplierPerBounce)));
                    this.field_70180_af.func_187227_b(BOUNCED_ENTITIES, (Object)(bouncedEntitiesString + "," + entity.func_110124_au()));
                }
                this.field_70180_af.func_187227_b(BOUNCES, (Object)(bounces + 1));
                this.locateNearestTarget();
                break;
            }
        }
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(BOUNCES, (Object)0);
        this.field_70180_af.func_187214_a(DAMAGE, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(OWNER, (Object)"");
        this.field_70180_af.func_187214_a(TARGET, (Object)"");
        this.field_70180_af.func_187214_a(BOUNCED_ENTITIES, (Object)"");
    }

    public void func_213281_b(CompoundNBT tag) {
        tag.func_74768_a(TAG_BOUNCES_AMOUNT, ((Integer)this.field_70180_af.func_187225_a(BOUNCES)).intValue());
        tag.func_74776_a(TAG_DAMAGE_AMOUNT, ((Float)this.field_70180_af.func_187225_a(DAMAGE)).floatValue());
        tag.func_74778_a(TAG_OWNER_UUID, (String)this.field_70180_af.func_187225_a(OWNER));
        tag.func_74778_a(TAG_TARGET_UUID, (String)this.field_70180_af.func_187225_a(TARGET));
        tag.func_74778_a(TAG_BOUNCED_ENTITIES, (String)this.field_70180_af.func_187225_a(BOUNCED_ENTITIES));
        super.func_213281_b(tag);
    }

    public void func_70037_a(CompoundNBT tag) {
        this.field_70180_af.func_187227_b(BOUNCES, (Object)tag.func_74762_e(TAG_BOUNCES_AMOUNT));
        this.field_70180_af.func_187227_b(DAMAGE, (Object)Float.valueOf(tag.func_74760_g(TAG_DAMAGE_AMOUNT)));
        this.field_70180_af.func_187227_b(OWNER, (Object)tag.func_74779_i(TAG_OWNER_UUID));
        this.field_70180_af.func_187227_b(TARGET, (Object)tag.func_74779_i(TAG_TARGET_UUID));
        this.field_70180_af.func_187227_b(BOUNCED_ENTITIES, (Object)tag.func_74779_i(TAG_BOUNCED_ENTITIES));
        super.func_70037_a(tag);
    }

    public boolean func_96092_aw() {
        return false;
    }

    protected float func_70185_h() {
        return 0.0f;
    }

    @Nonnull
    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

