/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.items;

import com.google.common.collect.Lists;
import it.hurts.sskirillss.relics.configs.variables.stats.RelicStats;
import it.hurts.sskirillss.relics.network.NetworkHandler;
import it.hurts.sskirillss.relics.network.PacketPlayerMotion;
import it.hurts.sskirillss.relics.utils.NBTUtils;
import it.hurts.sskirillss.relics.utils.RelicUtils;
import it.hurts.sskirillss.relics.utils.RelicsTab;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.Nullable;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurioItem;

public abstract class RelicItem<T extends RelicStats>
extends Item
implements ICurioItem {
    protected T config;

    public RelicItem(Rarity rarity) {
        super(new Item.Properties().func_200916_a(RelicsTab.RELICS_TAB).func_200917_a(1).func_208103_a(rarity));
    }

    public RelicItem(Item.Properties properties) {
        super(properties);
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (!(entityIn instanceof PlayerEntity)) {
            return;
        }
        PlayerEntity player = (PlayerEntity)entityIn;
        RelicItem.handleOwner(player, worldIn, stack);
        if (RelicUtils.Durability.getDurability(stack) == -1) {
            RelicUtils.Durability.setDurability(stack, RelicUtils.Durability.getMaxDurability(stack.func_77973_b()));
        }
        super.func_77663_a(stack, worldIn, entityIn, itemSlot, isSelected);
    }

    private static void handleOwner(PlayerEntity player, World world, ItemStack stack) {
        PlayerEntity owner = RelicUtils.Owner.getOwner(stack, world);
        if (owner == null || world.func_201670_d()) {
            return;
        }
        int contract = NBTUtils.getInt(stack, "date", 0);
        if (contract == 0) {
            NBTUtils.setInt(stack, "date", (int)world.func_82737_E());
        } else if (world.func_82737_E() - (long)contract >= 72000L) {
            NBTUtils.setInt(stack, "date", -1);
            RelicUtils.Owner.setOwnerUUID(stack, "");
            return;
        }
        if (!(owner.func_189512_bd().equals(player.func_189512_bd()) || player.func_184812_l_() || player.func_175149_v())) {
            player.func_146097_a(stack.func_77946_l(), false, true);
            stack.func_190918_g(1);
            player.func_213317_d(player.func_70676_i(0.0f).func_216372_d(-1.0, -1.0, -1.0).func_72432_b());
            world.func_195594_a((IParticleData)ParticleTypes.field_197627_t, player.func_226277_ct_(), player.func_226278_cu_() + 1.0, player.func_226281_cx_(), 0.0, 0.0, 0.0);
            world.func_184133_a(player, player.func_233580_cy_(), SoundEvents.field_187539_bB, SoundCategory.PLAYERS, 1.0f, 1.0f);
        }
    }

    public List<ITextComponent> getShiftTooltip(ItemStack stack) {
        return new ArrayList<ITextComponent>();
    }

    public List<ITextComponent> getAltTooltip(ItemStack stack) {
        return new ArrayList<ITextComponent>();
    }

    public List<ITextComponent> getControlTooltip(ItemStack stack) {
        return new ArrayList<ITextComponent>();
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        if (worldIn == null) {
            return;
        }
        PlayerEntity owner = RelicUtils.Owner.getOwner(stack, worldIn);
        long time = (NBTUtils.getLong(stack, "date", 0L) + 72000L - worldIn.func_82737_E()) / 20L;
        if (time > 0L && owner != null) {
            long hours = time / 3600L;
            long minutes = time % 3600L / 60L;
            long seconds = time % 3600L % 60L;
            tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.relics.contract", new Object[]{owner.func_145748_c_(), hours, minutes, seconds}));
        }
        int durability = RelicUtils.Durability.getDurability(stack);
        tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.relics.durability", new Object[]{durability == -1 ? 0 : durability, RelicUtils.Durability.getMaxDurability(stack.func_77973_b())}));
        if (!this.getShiftTooltip(stack).isEmpty() && Screen.func_231173_s_()) {
            tooltip.add((ITextComponent)new StringTextComponent(" "));
            tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.relics.shift.divider_up"));
            tooltip.addAll(this.getShiftTooltip(stack));
            tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.relics.shift.divider_down"));
        }
        if (!this.getAltTooltip(stack).isEmpty() && Screen.func_231174_t_()) {
            tooltip.add((ITextComponent)new StringTextComponent(" "));
            tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.relics.alt.divider_up"));
            tooltip.addAll(this.getAltTooltip(stack));
            tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.relics.alt.divider_sown"));
        }
        if (!this.getControlTooltip(stack).isEmpty() && Screen.func_231172_r_()) {
            tooltip.add((ITextComponent)new StringTextComponent(" "));
            tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.relics.control.divider_up"));
            tooltip.addAll(this.getControlTooltip(stack));
            tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.relics.control.divider_down"));
        }
        if (!this.getShiftTooltip(stack).isEmpty() && !Screen.func_231173_s_() || !this.getAltTooltip(stack).isEmpty() && !Screen.func_231174_t_() || !this.getControlTooltip(stack).isEmpty() && !Screen.func_231172_r_()) {
            tooltip.add((ITextComponent)new StringTextComponent(" "));
        }
        if (!Screen.func_231173_s_() && !this.getShiftTooltip(stack).isEmpty()) {
            tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.relics.shift.tooltip"));
        }
        if (!Screen.func_231174_t_() && !this.getAltTooltip(stack).isEmpty()) {
            tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.relics.alt.tooltip"));
        }
        if (!Screen.func_231172_r_() && !this.getControlTooltip(stack).isEmpty()) {
            tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.relics.ctrl.tooltip"));
        }
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
    }

    public boolean canEquipFromUse(SlotContext slotContext, ItemStack stack) {
        return true;
    }

    public int getMaxLevel() {
        return 10;
    }

    public int getInitialExp() {
        return 100;
    }

    public int getExpRatio() {
        return 250;
    }

    public float getWorldgenChance() {
        float chance = 0.0f;
        switch (new ItemStack((IItemProvider)this).func_77953_t()) {
            case COMMON: {
                chance = 0.15f;
                break;
            }
            case UNCOMMON: {
                chance = 0.125f;
                break;
            }
            case RARE: {
                chance = 0.1f;
                break;
            }
            case EPIC: {
                chance = 0.075f;
            }
        }
        return chance;
    }

    public List<ResourceLocation> getLootChests() {
        return Lists.newArrayList();
    }

    public int getDurability() {
        return 100;
    }

    public Class<T> getConfigClass() {
        return RelicStats.class;
    }

    public T getConfig() {
        return this.config;
    }

    public void setConfig(T config) {
        this.config = config;
    }

    public boolean hasAbility() {
        return false;
    }

    public void castAbility(PlayerEntity player, ItemStack stack) {
    }

    @Mod.EventBusSubscriber(modid="relics")
    public static class RelicEvents {
        @SubscribeEvent
        public static void onItemPickup(EntityItemPickupEvent event) {
            ItemEntity drop = event.getItem();
            ItemStack stack = drop.func_92059_d();
            PlayerEntity player = event.getPlayer();
            ServerWorld world = (ServerWorld)player.func_130014_f_();
            if (!(stack.func_77973_b() instanceof RelicItem) || world.func_82737_E() - NBTUtils.getLong(stack, "date", 0L) >= 72000L) {
                return;
            }
            String uuid = RelicUtils.Owner.getOwnerUUID(stack);
            if (player.func_184812_l_() || uuid.equals("") || uuid.equals(player.func_189512_bd())) {
                return;
            }
            drop.func_174867_a(40);
            Vector3d motion = player.func_213303_ch().func_178788_d(drop.func_213303_ch()).func_72432_b();
            NetworkHandler.sendToClient(new PacketPlayerMotion(motion.func_82615_a(), motion.func_82617_b(), motion.func_82616_c()), (ServerPlayerEntity)player);
            drop.func_213317_d(motion.func_216372_d(-1.25, -1.25, -1.25));
            world.func_195598_a((IParticleData)ParticleTypes.field_197627_t, drop.func_226277_ct_(), drop.func_226278_cu_() + 0.5, drop.func_226281_cx_(), 1, 0.0, 0.0, 0.0, 0.0);
            world.func_184133_a(null, drop.func_233580_cy_(), SoundEvents.field_187539_bB, SoundCategory.PLAYERS, 1.0f, 1.0f);
            event.setCanceled(true);
        }
    }
}

