/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.items.relics;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import it.hurts.sskirillss.relics.configs.variables.stats.RelicStats;
import it.hurts.sskirillss.relics.init.ItemRegistry;
import it.hurts.sskirillss.relics.items.RelicItem;
import it.hurts.sskirillss.relics.items.relics.renderer.ArrowQuiverModel;
import it.hurts.sskirillss.relics.network.NetworkHandler;
import it.hurts.sskirillss.relics.network.PacketPlayerMotion;
import it.hurts.sskirillss.relics.utils.NBTUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.entity.projectile.ProjectileEntity;
import net.minecraft.item.ArrowItem;
import net.minecraft.item.BowItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.Rarity;
import net.minecraft.loot.LootTables;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.player.ArrowLooseEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.capability.ICurio;
import top.theillusivec4.curios.api.type.capability.ICurioItem;

public class ArrowQuiverItem
extends RelicItem<Stats>
implements ICurioItem {
    public static ArrowQuiverItem INSTANCE;
    private static final String TAG_CHARGED = "charged";
    private static final String TAG_ARROW = "arrow";
    private final ResourceLocation TEXTURE = new ResourceLocation("relics", "textures/items/models/arrow_quiver.png");

    public ArrowQuiverItem() {
        super(Rarity.COMMON);
        INSTANCE = this;
    }

    @Override
    public List<ITextComponent> getShiftTooltip(ItemStack stack) {
        ArrayList tooltip = Lists.newArrayList();
        tooltip.add(new TranslationTextComponent("tooltip.relics.arrow_quiver.shift_1"));
        tooltip.add(new TranslationTextComponent("tooltip.relics.arrow_quiver.shift_2"));
        return tooltip;
    }

    public void curioTick(String identifier, int index, LivingEntity livingEntity, ItemStack stack) {
        World world = livingEntity.func_130014_f_();
        this.handleArrow(stack, world);
        this.handleUse(stack, livingEntity);
    }

    @Override
    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        super.func_77663_a(stack, worldIn, entityIn, itemSlot, isSelected);
    }

    private void handleArrow(ItemStack stack, World world) {
        if (world.func_201670_d()) {
            return;
        }
        String UUIDString = NBTUtils.getString(stack, TAG_ARROW, "");
        ServerWorld serverWorld = (ServerWorld)world;
        if (UUIDString.equals("")) {
            return;
        }
        Entity arrow = serverWorld.func_217461_a(UUID.fromString(UUIDString));
        if (arrow == null || !arrow.func_70089_S()) {
            NBTUtils.setString(stack, TAG_ARROW, "");
            NBTUtils.setBoolean(stack, TAG_CHARGED, false);
            return;
        }
        serverWorld.func_195598_a((IParticleData)ParticleTypes.field_197613_f, arrow.func_226277_ct_(), arrow.func_226278_cu_(), arrow.func_226281_cx_(), 1, 0.0, 0.0, 0.0, 0.0);
    }

    private void handleUse(ItemStack stack, LivingEntity entity) {
        if (!entity.func_184587_cr() || NBTUtils.getBoolean(stack, TAG_CHARGED, false)) {
            return;
        }
        Item item = entity.func_184614_ca().func_77973_b();
        String id = item.getRegistryName().toString();
        if (item instanceof BowItem && !((Stats)this.config).blacklistedItems.contains(id) || ((Stats)this.config).whitelistedItems.contains(id)) {
            for (int i = 0; i < ((Stats)this.config).skippedTicks; ++i) {
                entity.func_184608_ct();
            }
        }
    }

    @Override
    public void castAbility(PlayerEntity player, ItemStack stack) {
        if (player.func_184811_cZ().func_185141_a(stack.func_77973_b())) {
            return;
        }
        NBTUtils.setBoolean(stack, TAG_CHARGED, !NBTUtils.getBoolean(stack, TAG_CHARGED, false));
        NBTUtils.setString(stack, TAG_ARROW, "");
    }

    @Override
    public boolean hasAbility() {
        return true;
    }

    @Override
    public List<ResourceLocation> getLootChests() {
        return Collections.singletonList(LootTables.field_215821_l);
    }

    @Override
    public Class<Stats> getConfigClass() {
        return Stats.class;
    }

    public void render(String identifier, int index, MatrixStack matrixStack, IRenderTypeBuffer renderTypeBuffer, int light, LivingEntity livingEntity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, ItemStack stack) {
        ArrowQuiverModel model = new ArrowQuiverModel();
        matrixStack.func_227860_a_();
        model.func_225597_a_(livingEntity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        model.func_212843_a_(livingEntity, limbSwing, limbSwingAmount, partialTicks);
        ICurio.RenderHelper.followBodyRotations((LivingEntity)livingEntity, (BipedModel[])new BipedModel[]{model});
        model.func_225598_a_(matrixStack, renderTypeBuffer.getBuffer(RenderType.func_228644_e_((ResourceLocation)this.TEXTURE)), light, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
        matrixStack.func_227865_b_();
    }

    public boolean canRender(String identifier, int index, LivingEntity livingEntity, ItemStack stack) {
        return true;
    }

    public static class Stats
    extends RelicStats {
        public int skippedTicks = 1;
        public int activeCooldown = 10;
        public int explosionRadius = 5;
        public float explosionDamageMultiplier = 1.5f;
        public int maxExplosionDamage = 75;
        public List<String> whitelistedItems = new ArrayList<String>();
        public List<String> blacklistedItems = new ArrayList<String>();
    }

    @Mod.EventBusSubscriber(modid="relics")
    public static class Events {
        @SubscribeEvent
        public static void onArrowLoose(ArrowLooseEvent event) {
            Stats config = (Stats)INSTANCE.config;
            if (!(event.getEntityLiving() instanceof PlayerEntity)) {
                return;
            }
            PlayerEntity player = (PlayerEntity)event.getEntityLiving();
            Item item = (Item)ItemRegistry.ARROW_QUIVER.get();
            CuriosApi.getCuriosHelper().findEquippedCurio(item, (LivingEntity)player).ifPresent(triple -> {
                ItemStack stack = (ItemStack)triple.getRight();
                World world = player.func_130014_f_();
                if (!NBTUtils.getBoolean(stack, ArrowQuiverItem.TAG_CHARGED, false)) {
                    return;
                }
                event.setCanceled(true);
                ItemStack bow = event.getBow();
                ItemStack ammo = player.func_213356_f(bow);
                if (ammo.func_190926_b()) {
                    return;
                }
                AbstractArrowEntity projectile = ((ArrowItem)(ammo.func_77973_b() instanceof ArrowItem ? ammo.func_77973_b() : Items.field_151032_g)).func_200887_a(world, ammo, (LivingEntity)player);
                if (EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185312_x, (ItemStack)bow) <= 0 && !player.func_184812_l_()) {
                    projectile.field_70251_a = AbstractArrowEntity.PickupStatus.CREATIVE_ONLY;
                    ammo.func_190918_g(1);
                }
                projectile.func_234612_a_((Entity)player, player.field_70125_A, player.field_70177_z, 0.0f, BowItem.func_185059_b((int)event.getCharge()) * 3.0f, 0.0f);
                world.func_217376_c((Entity)projectile);
                NBTUtils.setString(stack, ArrowQuiverItem.TAG_ARROW, projectile.func_189512_bd());
                player.func_184811_cZ().func_185145_a(item, config.activeCooldown * 20);
                world.func_195594_a((IParticleData)ParticleTypes.field_197627_t, player.func_226277_ct_(), player.func_226278_cu_() + 1.0, player.func_226281_cx_(), 0.0, 0.0, 0.0);
                world.func_184133_a(player, player.func_233580_cy_(), SoundEvents.field_187539_bB, SoundCategory.PLAYERS, 1.0f, 1.0f);
                world.func_184133_a(player, player.func_233580_cy_(), SoundEvents.field_187631_bo, SoundCategory.PLAYERS, 1.0f, 1.75f);
            });
        }

        @SubscribeEvent
        public static void onProjectileImpact(ProjectileImpactEvent event) {
            Stats config = (Stats)INSTANCE.config;
            if (!(event.getEntity() instanceof ProjectileEntity)) {
                return;
            }
            ProjectileEntity projectile = (ProjectileEntity)event.getEntity();
            if (!(projectile.func_234616_v_() instanceof PlayerEntity)) {
                return;
            }
            PlayerEntity owner = (PlayerEntity)projectile.func_234616_v_();
            if (owner == null) {
                return;
            }
            CuriosApi.getCuriosHelper().findEquippedCurio((Item)ItemRegistry.ARROW_QUIVER.get(), (LivingEntity)owner).ifPresent(triple -> {
                ItemStack stack = (ItemStack)triple.getRight();
                World world = owner.func_130014_f_();
                if (!event.getEntity().func_110124_au().toString().equals(NBTUtils.getString(stack, ArrowQuiverItem.TAG_ARROW, ""))) {
                    return;
                }
                for (LivingEntity entity : world.func_217357_a(LivingEntity.class, projectile.func_174813_aQ().func_186662_g((double)config.explosionRadius))) {
                    if (world.func_201670_d()) {
                        return;
                    }
                    Vector3d motion = entity.func_213303_ch().func_72441_c(0.0, 2.25, 0.0).func_178788_d(projectile.func_213303_ch()).func_72432_b().func_216372_d(1.5, 1.5, 1.5);
                    if (!world.func_201670_d() && entity instanceof ServerPlayerEntity) {
                        NetworkHandler.sendToClient(new PacketPlayerMotion(motion.func_82615_a(), motion.func_82617_b(), motion.func_82616_c()), (ServerPlayerEntity)entity);
                    } else {
                        entity.func_213317_d(motion);
                    }
                    if (entity.func_189512_bd().equals(owner.func_189512_bd())) continue;
                    entity.func_70097_a(DamageSource.func_76365_a((PlayerEntity)owner), (float)Math.min((double)config.maxExplosionDamage, entity.func_213303_ch().func_72438_d(owner.func_213303_ch()) * (double)config.explosionDamageMultiplier));
                }
                NBTUtils.setString(stack, ArrowQuiverItem.TAG_ARROW, "");
                NBTUtils.setBoolean(stack, ArrowQuiverItem.TAG_CHARGED, false);
                world.func_184133_a(null, projectile.func_233580_cy_(), SoundEvents.field_187539_bB, SoundCategory.PLAYERS, 1.0f, 1.0f);
            });
        }
    }
}

