/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.items.relics;

import com.google.common.collect.Lists;
import it.hurts.sskirillss.relics.configs.variables.stats.RelicStats;
import it.hurts.sskirillss.relics.init.ItemRegistry;
import it.hurts.sskirillss.relics.items.RelicItem;
import it.hurts.sskirillss.relics.particles.circle.CircleTintData;
import it.hurts.sskirillss.relics.utils.RelicUtils;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.monster.piglin.PiglinEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.particles.IParticleData;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.capability.ICurioItem;

public class BastionRingItem
extends RelicItem<Stats>
implements ICurioItem {
    public static BastionRingItem INSTANCE;

    public BastionRingItem() {
        super(Rarity.RARE);
        INSTANCE = this;
    }

    @Override
    public List<ITextComponent> getShiftTooltip(ItemStack stack) {
        ArrayList tooltip = Lists.newArrayList();
        tooltip.add(new TranslationTextComponent("tooltip.relics.bastion_ring.shift_1"));
        return tooltip;
    }

    @Override
    public List<ResourceLocation> getLootChests() {
        return RelicUtils.Worldgen.NETHER;
    }

    @Override
    public Class<Stats> getConfigClass() {
        return Stats.class;
    }

    public static class Stats
    extends RelicStats {
        public float locateChance = 0.3f;
    }

    @Mod.EventBusSubscriber(modid="relics")
    public static class BastionRingEvents {
        @SubscribeEvent
        public static void onEntityKill(LivingDeathEvent event) {
            Stats config = (Stats)INSTANCE.config;
            if (!(event.getEntityLiving() instanceof PiglinEntity)) {
                return;
            }
            PiglinEntity entity = (PiglinEntity)event.getEntityLiving();
            if (!(event.getSource().func_76346_g() instanceof PlayerEntity)) {
                return;
            }
            PlayerEntity player = (PlayerEntity)event.getSource().func_76346_g();
            if (entity.func_130014_f_().func_234923_W_() == World.field_234919_h_ && CuriosApi.getCuriosHelper().findEquippedCurio((Item)ItemRegistry.BASTION_RING.get(), (LivingEntity)player).isPresent() && field_77697_d.nextFloat() <= config.locateChance) {
                ServerWorld world = (ServerWorld)entity.func_130014_f_();
                BlockPos bastionPos = world.func_72863_F().func_201711_g().func_235956_a_(world, Structure.field_236383_s_, player.func_233580_cy_(), 100, false);
                if (bastionPos == null) {
                    return;
                }
                Vector3d currentVec = entity.func_213303_ch();
                Vector3d finalVec = currentVec.func_178787_e(new Vector3d((double)bastionPos.func_177958_n(), entity.func_226278_cu_(), (double)bastionPos.func_177952_p()).func_178788_d(currentVec).func_72432_b().func_216372_d(5.0, 5.0, 5.0));
                int distance = (int)Math.round(currentVec.func_72438_d(finalVec)) * 3;
                for (int i = 0; i < distance; ++i) {
                    float x = (float)((finalVec.field_72450_a - currentVec.field_72450_a) * (double)i / (double)distance + currentVec.field_72450_a);
                    float z = (float)((finalVec.field_72449_c - currentVec.field_72449_c) * (double)i / (double)distance + currentVec.field_72449_c);
                    world.func_195598_a((IParticleData)new CircleTintData(new Color(255, 240, 150), 0.4f - (float)i * 0.0125f, 180, 0.99f, false), (double)x, entity.func_226278_cu_() + 1.5, (double)z, 1, 0.0, 0.0, 0.0, 0.0);
                }
            }
        }
    }
}

