/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.items.relics;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import it.hurts.sskirillss.relics.configs.variables.stats.RelicStats;
import it.hurts.sskirillss.relics.init.ItemRegistry;
import it.hurts.sskirillss.relics.items.RelicItem;
import it.hurts.sskirillss.relics.items.relics.renderer.BlazingFlaskModel;
import it.hurts.sskirillss.relics.utils.MathUtils;
import it.hurts.sskirillss.relics.utils.NBTUtils;
import it.hurts.sskirillss.relics.utils.RelicUtils;
import it.hurts.sskirillss.relics.utils.WorldUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.AbstractFireBlock;
import net.minecraft.block.Blocks;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.Nullable;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurio;
import top.theillusivec4.curios.api.type.capability.ICurioItem;

public class BlazingFlaskItem
extends RelicItem<Stats>
implements ICurioItem {
    public static final String TAG_FIRE_AMOUNT = "fire";
    private final ResourceLocation TEXTURE = new ResourceLocation("relics", "textures/items/models/blazing_flask.png");

    public BlazingFlaskItem() {
        super(Rarity.EPIC);
    }

    @Override
    public List<ITextComponent> getShiftTooltip(ItemStack stack) {
        ArrayList tooltip = Lists.newArrayList();
        tooltip.add(new TranslationTextComponent("tooltip.relics.blazing_flask.shift_1"));
        tooltip.add(new TranslationTextComponent("tooltip.relics.blazing_flask.shift_2"));
        return tooltip;
    }

    @Override
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        int fire = NBTUtils.getInt(stack, TAG_FIRE_AMOUNT, 0);
        if (fire <= 0) {
            return;
        }
        tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.relics.blazing_flask.tooltip_1", new Object[]{fire}));
    }

    public void curioTick(String identifier, int index, LivingEntity livingEntity, ItemStack stack) {
        if (!(livingEntity instanceof PlayerEntity)) {
            return;
        }
        PlayerEntity player = (PlayerEntity)livingEntity;
        World world = player.func_130014_f_();
        int fire = NBTUtils.getInt(stack, TAG_FIRE_AMOUNT, 0);
        if (!player.func_175149_v() && !player.func_184812_l_()) {
            boolean bl = player.field_71075_bZ.field_75101_c = fire > 0;
            if (player.field_71075_bZ.field_75100_b) {
                this.handleIgnite(player);
                this.handleLevitation(player, stack);
            }
        }
        this.collectFire(player, stack);
        if (fire <= 0 || player.field_70173_aa % 20 != 0 || !world.func_175727_C(player.func_233580_cy_()) && !player.func_70090_H()) {
            return;
        }
        world.func_184133_a(player, player.func_233580_cy_(), SoundEvents.field_187646_bt, SoundCategory.PLAYERS, 0.5f, 1.0f);
        NBTUtils.setInt(stack, TAG_FIRE_AMOUNT, fire - 1);
    }

    protected double getGroundHeight(PlayerEntity player) {
        BlockRayTraceResult result = player.field_70170_p.func_217299_a(new RayTraceContext(player.func_213303_ch(), new Vector3d(player.func_226277_ct_(), player.func_226278_cu_() - 64.0, player.func_226281_cx_()), RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.ANY, (Entity)player));
        if (result.func_216346_c() == RayTraceResult.Type.BLOCK) {
            return result.func_216347_e().func_82617_b();
        }
        return -player.func_130014_f_().func_217301_I();
    }

    protected void handleIgnite(PlayerEntity player) {
        World world = player.func_130014_f_();
        for (int i = 0; i < 3; ++i) {
            world.func_195594_a((IParticleData)(player.func_70090_H() ? ParticleTypes.field_197613_f : ParticleTypes.field_197594_E), player.func_226277_ct_() + (double)(MathUtils.randomFloat(world.func_201674_k()) * 0.5f), player.func_226278_cu_() + (double)(MathUtils.randomFloat(world.func_201674_k()) * 0.5f), player.func_226281_cx_() + (double)(MathUtils.randomFloat(world.func_201674_k()) * 0.5f), 0.0, player.func_70090_H() ? 0.0 : -0.1, 0.0);
        }
        if (player.func_70090_H()) {
            return;
        }
        world.func_195594_a((IParticleData)ParticleTypes.field_197631_x, player.func_226277_ct_() + (double)(MathUtils.randomFloat(world.func_201674_k()) * 0.5f), player.func_226278_cu_() + (double)(MathUtils.randomFloat(world.func_201674_k()) * 0.5f), player.func_226281_cx_() + (double)(MathUtils.randomFloat(world.func_201674_k()) * 0.5f), 0.0, -0.25, 0.0);
        for (LivingEntity entity : world.func_217357_a(LivingEntity.class, player.func_174813_aQ().func_186662_g(0.5).func_72321_a(0.0, -this.getGroundHeight(player) - 1.0, 0.0))) {
            if (entity == player) continue;
            entity.func_70015_d(((Stats)this.config).igniteDuration);
        }
    }

    protected void handleLevitation(PlayerEntity player, ItemStack stack) {
        int fire = NBTUtils.getInt(stack, TAG_FIRE_AMOUNT, 0);
        double riseVelocity = 0.0;
        player.field_70143_R = 0.0f;
        player.field_71075_bZ.field_75100_b = fire > 0;
        player.func_213317_d(player.func_213322_ci().func_216372_d((double)((Stats)this.config).levitationSpeed, (double)((Stats)this.config).levitationSpeed, (double)((Stats)this.config).levitationSpeed));
        Vector3d motion = player.func_213322_ci();
        if (player.field_191988_bg > 0.0f) {
            player.func_213293_j(motion.func_82615_a() + new Vector3d(player.func_70040_Z().field_72450_a, 0.0, player.func_70040_Z().field_72449_c).func_72432_b().func_82615_a() * (double)0.025f, motion.func_82617_b(), motion.func_82616_c() + new Vector3d(player.func_70040_Z().field_72450_a, 0.0, player.func_70040_Z().field_72449_c).func_72432_b().func_82616_c() * (double)0.025f);
        }
        if (player.func_130014_f_().func_201670_d() && player instanceof ClientPlayerEntity && ((ClientPlayerEntity)player).field_71158_b.field_78901_c) {
            riseVelocity = 0.04;
        }
        if (!player.func_225608_bj_()) {
            player.func_213293_j(motion.func_82615_a(), riseVelocity * (this.getGroundHeight(player) - (player.func_226278_cu_() - (double)((Stats)this.config).levitationHeight)), motion.func_82616_c());
        }
        if (player.func_226278_cu_() - (double)((Stats)this.config).levitationHeight > this.getGroundHeight(player)) {
            if (motion.func_82617_b() > 0.0) {
                player.func_213293_j(motion.func_82615_a(), 0.0, motion.func_82616_c());
            }
            player.func_213293_j(motion.func_82615_a(), -Math.min(player.func_226278_cu_() - (double)((Stats)this.config).levitationHeight - this.getGroundHeight(player), 2.0) / 8.0, motion.func_82616_c());
        }
        if (player.field_70173_aa % 20 == 0) {
            NBTUtils.setInt(stack, TAG_FIRE_AMOUNT, fire - 1);
        }
    }

    protected void collectFire(PlayerEntity player, ItemStack stack) {
        World world = player.func_130014_f_();
        int fire = NBTUtils.getInt(stack, TAG_FIRE_AMOUNT, 0);
        if (world.func_201670_d() || player.func_175149_v() || player.field_70173_aa % ((Stats)this.config).consumptionCooldown != 0 || fire >= ((Stats)this.config).capacity) {
            return;
        }
        for (BlockPos pos : WorldUtils.getBlockSphere(player.func_233580_cy_(), ((Stats)this.config).consumptionRadius)) {
            if (!(world.func_180495_p(pos).func_177230_c() instanceof AbstractFireBlock)) continue;
            world.func_184133_a(null, pos, SoundEvents.field_187646_bt, SoundCategory.PLAYERS, 1.0f, 1.0f);
            ((ServerWorld)world).func_195598_a((IParticleData)ParticleTypes.field_197613_f, (double)((float)pos.func_177958_n() + 0.5f), (double)((float)pos.func_177956_o() + 0.5f), (double)((float)pos.func_177952_p() + 0.5f), 5, 0.35, 0.2, 0.35, 0.01);
            world.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
            NBTUtils.setInt(stack, TAG_FIRE_AMOUNT, fire + 1);
            break;
        }
    }

    public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        if (!(slotContext.getWearer() instanceof PlayerEntity) || NBTUtils.getInt(newStack, TAG_FIRE_AMOUNT, 0) > 0) {
            return;
        }
        PlayerEntity player = (PlayerEntity)slotContext.getWearer();
        if (player.func_184812_l_() || player.func_175149_v()) {
            return;
        }
        player.field_71075_bZ.field_75101_c = false;
        player.field_71075_bZ.field_75100_b = false;
        player.func_71016_p();
    }

    @Override
    public List<ResourceLocation> getLootChests() {
        return RelicUtils.Worldgen.NETHER;
    }

    @Override
    public Class<Stats> getConfigClass() {
        return Stats.class;
    }

    public void render(String identifier, int index, MatrixStack matrixStack, IRenderTypeBuffer renderTypeBuffer, int light, LivingEntity livingEntity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, ItemStack stack) {
        BlazingFlaskModel model = new BlazingFlaskModel();
        matrixStack.func_227860_a_();
        model.func_225597_a_(livingEntity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        model.func_212843_a_(livingEntity, limbSwing, limbSwingAmount, partialTicks);
        ICurio.RenderHelper.followBodyRotations((LivingEntity)livingEntity, (BipedModel[])new BipedModel[]{model});
        model.func_225598_a_(matrixStack, renderTypeBuffer.getBuffer(RenderType.func_228644_e_((ResourceLocation)this.TEXTURE)), light, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
        matrixStack.func_227865_b_();
    }

    public boolean canRender(String identifier, int index, LivingEntity livingEntity, ItemStack stack) {
        return true;
    }

    public static class Stats
    extends RelicStats {
        public float levitationHeight = 5.0f;
        public float levitationSpeed = 0.75f;
        public int igniteDuration = 5;
        public int consumptionCooldown = 10;
        public int consumptionRadius = 10;
        public int capacity = 100;
    }

    @Mod.EventBusSubscriber(modid="relics")
    public static class BlazingFlaskServerEvents {
        @SubscribeEvent
        public static void onEntityHurt(LivingHurtEvent event) {
            if (!(event.getEntityLiving() instanceof PlayerEntity)) {
                return;
            }
            PlayerEntity player = (PlayerEntity)event.getEntityLiving();
            DamageSource source = event.getSource();
            if (source == DamageSource.field_76372_a || source == DamageSource.field_76370_b) {
                if (!CuriosApi.getCuriosHelper().findEquippedCurio((Item)ItemRegistry.BLAZING_FLASK.get(), (LivingEntity)player).isPresent()) {
                    return;
                }
                event.setCanceled(true);
            }
        }

        @SubscribeEvent
        public static void onEntityAttack(LivingAttackEvent event) {
            if (!(event.getEntityLiving() instanceof PlayerEntity)) {
                return;
            }
            PlayerEntity player = (PlayerEntity)event.getEntityLiving();
            DamageSource source = event.getSource();
            if (source == DamageSource.field_76372_a || source == DamageSource.field_76370_b) {
                if (!CuriosApi.getCuriosHelper().findEquippedCurio((Item)ItemRegistry.BLAZING_FLASK.get(), (LivingEntity)player).isPresent()) {
                    return;
                }
                event.setCanceled(true);
            }
        }
    }
}

