/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.items.relics;

import com.google.common.collect.Lists;
import it.hurts.sskirillss.relics.configs.variables.stats.RelicStats;
import it.hurts.sskirillss.relics.init.ItemRegistry;
import it.hurts.sskirillss.relics.items.RelicItem;
import it.hurts.sskirillss.relics.utils.NBTUtils;
import it.hurts.sskirillss.relics.utils.RelicUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.block.DoublePlantBlock;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.capability.ICurioItem;

public class CamouflageRingItem
extends RelicItem<Stats>
implements ICurioItem {
    public static final String TAG_TIME = "time";
    public static CamouflageRingItem INSTANCE;

    public CamouflageRingItem() {
        super(Rarity.UNCOMMON);
        INSTANCE = this;
    }

    @Override
    public List<ITextComponent> getShiftTooltip(ItemStack stack) {
        ArrayList tooltip = Lists.newArrayList();
        tooltip.add(new TranslationTextComponent("tooltip.relics.camouflage_ring.shift_1"));
        return tooltip;
    }

    public void curioTick(String identifier, int index, LivingEntity livingEntity, ItemStack stack) {
        if (livingEntity.field_70173_aa % 20 != 0 || !(livingEntity instanceof PlayerEntity)) {
            return;
        }
        PlayerEntity player = (PlayerEntity)livingEntity;
        int time = NBTUtils.getInt(stack, TAG_TIME, 0);
        if (CamouflageRingItem.canHide((LivingEntity)player)) {
            player.func_195064_c(new EffectInstance(Effects.field_76441_p, 30, 0, false, false));
            NBTUtils.setInt(stack, TAG_TIME, time + 1);
        } else {
            if (time <= 0) {
                return;
            }
            if (!player.func_184811_cZ().func_185141_a(stack.func_77973_b())) {
                player.func_184811_cZ().func_185145_a(stack.func_77973_b(), ((Stats)this.config).invisibilityTime * 20);
            }
            NBTUtils.setInt(stack, TAG_TIME, time - 1);
        }
    }

    @Override
    public List<ResourceLocation> getLootChests() {
        return RelicUtils.Worldgen.CAVE;
    }

    @Override
    public Class<Stats> getConfigClass() {
        return Stats.class;
    }

    private static boolean canHide(LivingEntity entity) {
        Stats config = (Stats)CamouflageRingItem.INSTANCE.config;
        if (!(entity instanceof PlayerEntity)) {
            return false;
        }
        PlayerEntity player = (PlayerEntity)entity;
        Optional optional = CuriosApi.getCuriosHelper().findEquippedCurio((Item)ItemRegistry.CAMOUFLAGE_RING.get(), (LivingEntity)player);
        if (optional.isPresent()) {
            ItemStack stack = (ItemStack)((ImmutableTriple)optional.get()).getRight();
            return player.func_130014_f_().func_180495_p(player.func_233580_cy_()).func_177230_c() instanceof DoublePlantBlock && player.func_213453_ef() && NBTUtils.getInt(stack, TAG_TIME, 0) < config.invisibilityTime && !player.func_184811_cZ().func_185141_a(stack.func_77973_b());
        }
        return false;
    }

    public static class Stats
    extends RelicStats {
        public int invisibilityTime = 60;
        public float damageMultiplier = 2.0f;
    }

    @Mod.EventBusSubscriber(modid="relics", value={Dist.CLIENT})
    public static class CamouflageRingClientEvents {
        @SubscribeEvent
        public static void onEntityRender(RenderPlayerEvent.Pre event) {
            PlayerEntity player = event.getPlayer();
            if (CamouflageRingItem.canHide((LivingEntity)player)) {
                event.setCanceled(true);
            }
        }
    }

    @Mod.EventBusSubscriber(modid="relics")
    public static class CamouflageRingServerEvents {
        @SubscribeEvent
        public static void onEntityHurt(LivingHurtEvent event) {
            Stats config = (Stats)INSTANCE.config;
            if (!(event.getSource().func_76346_g() instanceof PlayerEntity)) {
                return;
            }
            PlayerEntity player = (PlayerEntity)event.getSource().func_76346_g();
            if (CamouflageRingItem.canHide((LivingEntity)player)) {
                event.setAmount(event.getAmount() * config.damageMultiplier);
            }
        }
    }
}

