/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.items.relics;

import com.google.common.collect.Lists;
import it.hurts.sskirillss.relics.configs.variables.stats.RelicStats;
import it.hurts.sskirillss.relics.init.ItemRegistry;
import it.hurts.sskirillss.relics.items.RelicItem;
import it.hurts.sskirillss.relics.utils.NBTUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.Rarity;
import net.minecraft.loot.LootTables;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.entity.living.EnderTeleportEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.Nullable;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.capability.ICurioItem;

public class ChorusInhibitorItem
extends RelicItem<Stats>
implements ICurioItem {
    public static final String TAG_POSITION = "pos";
    public static final String TAG_TIME = "time";
    public static final String TAG_WORLD = "world";
    public static ChorusInhibitorItem INSTANCE;

    public ChorusInhibitorItem() {
        super(Rarity.RARE);
        INSTANCE = this;
    }

    @Override
    public List<ITextComponent> getShiftTooltip(ItemStack stack) {
        ArrayList tooltip = Lists.newArrayList();
        tooltip.add(new TranslationTextComponent("tooltip.relics.chorus_inhibitor.shift_1"));
        tooltip.add(new TranslationTextComponent("tooltip.relics.chorus_inhibitor.shift_2"));
        tooltip.add(new TranslationTextComponent("tooltip.relics.chorus_inhibitor.shift_3"));
        return tooltip;
    }

    @Override
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        if (!NBTUtils.getString(stack, TAG_POSITION, "").equals("")) {
            Vector3d pos = NBTUtils.parsePosition(NBTUtils.getString(stack, TAG_POSITION, ""));
            tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.relics.chorus_inhibitor.tooltip_1", new Object[]{pos.func_82615_a(), pos.func_82617_b(), pos.func_82616_c()}));
            tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.relics.chorus_inhibitor.tooltip_2", new Object[]{NBTUtils.getInt(stack, TAG_TIME, 0)}));
        }
    }

    public void curioTick(String identifier, int index, LivingEntity livingEntity, ItemStack stack) {
        if (!(livingEntity instanceof PlayerEntity) || livingEntity.func_130014_f_().func_201670_d() || livingEntity.field_70173_aa % 20 != 0) {
            return;
        }
        PlayerEntity player = (PlayerEntity)livingEntity;
        int time = NBTUtils.getInt(stack, TAG_TIME, 0);
        if (time > 0) {
            NBTUtils.setInt(stack, TAG_TIME, time - 1);
        } else if (!NBTUtils.getString(stack, TAG_POSITION, "").equals("")) {
            Vector3d pos = NBTUtils.parsePosition(NBTUtils.getString(stack, TAG_POSITION, ""));
            ServerWorld world = NBTUtils.parseWorld(player.func_130014_f_(), NBTUtils.getString(stack, TAG_WORLD, ""));
            if (pos == null || world == null) {
                return;
            }
            ((ServerPlayerEntity)player).func_200619_a(world, pos.func_82615_a(), pos.func_82617_b(), pos.func_82616_c(), player.field_70177_z, player.field_70125_A);
            player.func_130014_f_().func_184148_a(player, pos.func_82615_a(), pos.func_82617_b(), pos.func_82616_c(), SoundEvents.field_187534_aX, SoundCategory.PLAYERS, 1.0f, 1.0f);
            NBTUtils.setString(stack, TAG_POSITION, "");
            NBTUtils.setString(stack, TAG_WORLD, "");
            NBTUtils.setInt(stack, TAG_TIME, 0);
        }
    }

    @Override
    public List<ResourceLocation> getLootChests() {
        return Collections.singletonList(LootTables.field_186421_c);
    }

    @Override
    public Class<Stats> getConfigClass() {
        return Stats.class;
    }

    @SubscribeEvent
    public static void onPlayerTeleported(EnderTeleportEvent event) {
        if (event.getEntityLiving() instanceof PlayerEntity && CuriosApi.getCuriosHelper().findEquippedCurio((Item)ItemRegistry.CHORUS_INHIBITOR.get(), event.getEntityLiving()).isPresent()) {
            event.setAttackDamage(0.0f);
        }
    }

    public static class Stats
    extends RelicStats {
        public int timePerChorus = 30;
    }

    @Mod.EventBusSubscriber(modid="relics")
    public static class ChorusInhibitorEvents {
        @SubscribeEvent
        public static void onItemUse(PlayerInteractEvent.RightClickItem event) {
            Stats config = (Stats)INSTANCE.config;
            if (!(event.getEntityLiving() instanceof PlayerEntity)) {
                return;
            }
            PlayerEntity player = (PlayerEntity)event.getEntityLiving();
            if (player.func_184614_ca().func_77973_b() == Items.field_185161_cS && !player.func_225608_bj_()) {
                CuriosApi.getCuriosHelper().findEquippedCurio((Item)ItemRegistry.CHORUS_INHIBITOR.get(), (LivingEntity)player).ifPresent(triple -> {
                    ItemStack stack = (ItemStack)triple.getRight();
                    int time = NBTUtils.getInt(stack, ChorusInhibitorItem.TAG_TIME, 0);
                    NBTUtils.setInt(stack, ChorusInhibitorItem.TAG_TIME, time + config.timePerChorus);
                    if (time <= 0) {
                        NBTUtils.setString(stack, ChorusInhibitorItem.TAG_POSITION, NBTUtils.writePosition(player.func_213303_ch()));
                        NBTUtils.setString(stack, ChorusInhibitorItem.TAG_WORLD, player.func_130014_f_().func_234923_W_().func_240901_a_().toString());
                    }
                    player.func_184614_ca().func_190918_g(1);
                    event.setCanceled(true);
                });
            }
        }
    }
}

