/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.items.relics;

import com.google.common.collect.Lists;
import it.hurts.sskirillss.relics.configs.variables.stats.RelicStats;
import it.hurts.sskirillss.relics.init.ItemRegistry;
import it.hurts.sskirillss.relics.items.RelicItem;
import it.hurts.sskirillss.relics.particles.circle.CircleTintData;
import it.hurts.sskirillss.relics.utils.NBTUtils;
import it.hurts.sskirillss.relics.utils.ParticleUtils;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.loot.LootTables;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingHealEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import org.jetbrains.annotations.Nullable;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.capability.ICurioItem;

public class DelayRingItem
extends RelicItem<Stats>
implements ICurioItem {
    public static final String TAG_UPDATE_TIME = "time";
    public static final String TAG_STORED_AMOUNT = "amount";
    public static final String TAG_IS_ACTIVE = "active";
    public static final String TAG_KILLER_UUID = "killer";
    public static DelayRingItem INSTANCE;

    public DelayRingItem() {
        super(Rarity.EPIC);
        INSTANCE = this;
    }

    @Override
    public List<ITextComponent> getShiftTooltip(ItemStack stack) {
        ArrayList tooltip = Lists.newArrayList();
        tooltip.add(new TranslationTextComponent("tooltip.relics.delay_ring.shift_1"));
        tooltip.add(new TranslationTextComponent("tooltip.relics.delay_ring.shift_2"));
        return tooltip;
    }

    @Override
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        if (NBTUtils.getInt(stack, TAG_UPDATE_TIME, 0) > 0) {
            tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.relics.delay_ring.tooltip_1", new Object[]{NBTUtils.getInt(stack, TAG_UPDATE_TIME, 0)}));
            tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.relics.delay_ring.tooltip_2", new Object[]{NBTUtils.getInt(stack, TAG_STORED_AMOUNT, 0)}));
        }
    }

    public void curioTick(String identifier, int index, LivingEntity livingEntity, ItemStack stack) {
        if (livingEntity instanceof PlayerEntity) {
            int time = NBTUtils.getInt(stack, TAG_UPDATE_TIME, 0);
            PlayerEntity player = (PlayerEntity)livingEntity;
            if (!player.func_184811_cZ().func_185141_a((Item)ItemRegistry.DELAY_RING.get()) && NBTUtils.getBoolean(stack, TAG_IS_ACTIVE, false)) {
                if (time < ((Stats)this.config).delayDuration) {
                    if (livingEntity.field_70173_aa % 20 == 0) {
                        NBTUtils.setInt(stack, TAG_UPDATE_TIME, time + 1);
                    }
                } else {
                    if (NBTUtils.getInt(stack, TAG_STORED_AMOUNT, 0) > 0) {
                        player.func_70606_j(Math.min((float)NBTUtils.getInt(stack, TAG_STORED_AMOUNT, 0), player.func_110138_aP()));
                    } else {
                        if (!NBTUtils.getString(stack, TAG_KILLER_UUID, "").equals("") && player.func_130014_f_().func_217371_b(UUID.fromString(NBTUtils.getString(stack, TAG_KILLER_UUID, ""))) != null) {
                            player.func_70097_a(DamageSource.func_76365_a((PlayerEntity)player.func_130014_f_().func_217371_b(UUID.fromString(NBTUtils.getString(stack, TAG_KILLER_UUID, "")))), 2.1474836E9f);
                        } else {
                            player.func_70097_a(DamageSource.field_76377_j, 2.1474836E9f);
                        }
                        ParticleUtils.createBall(new CircleTintData(new Color(0.4f, 0.05f, 0.7f), 0.5f, 40, 0.94f, true), player.func_213303_ch(), player.func_130014_f_(), 3, 0.2f);
                    }
                    player.func_184811_cZ().func_185145_a((Item)ItemRegistry.DELAY_RING.get(), ((Stats)this.config).useCooldown * 20);
                    NBTUtils.setInt(stack, TAG_STORED_AMOUNT, 0);
                    NBTUtils.setInt(stack, TAG_UPDATE_TIME, 0);
                    NBTUtils.setString(stack, TAG_KILLER_UUID, "");
                    NBTUtils.setBoolean(stack, TAG_IS_ACTIVE, false);
                }
            }
        }
    }

    public void onUnequip(String identifier, int index, LivingEntity livingEntity, ItemStack stack) {
        ItemStack ring = CuriosApi.getCuriosHelper().getCuriosHandler(livingEntity).map(handler -> handler.getStacksHandler(identifier).map(stacks -> stacks.getStacks().getStackInSlot(index)).orElse(ItemStack.field_190927_a)).orElse(ItemStack.field_190927_a);
        if (NBTUtils.getBoolean(stack, TAG_IS_ACTIVE, false) && ring == ItemStack.field_190927_a) {
            if (!NBTUtils.getString(stack, TAG_KILLER_UUID, "").equals("") && livingEntity.func_130014_f_().func_217371_b(UUID.fromString(NBTUtils.getString(stack, TAG_KILLER_UUID, ""))) != null) {
                livingEntity.func_70097_a(DamageSource.func_76365_a((PlayerEntity)livingEntity.func_130014_f_().func_217371_b(UUID.fromString(NBTUtils.getString(stack, TAG_KILLER_UUID, "")))), 2.1474836E9f);
                NBTUtils.setString(stack, TAG_KILLER_UUID, "");
            } else {
                livingEntity.func_70097_a(DamageSource.field_76377_j, 2.1474836E9f);
            }
            ParticleUtils.createBall(new CircleTintData(new Color(0.4f, 0.05f, 0.7f), 0.5f, 40, 0.94f, true), livingEntity.func_213303_ch(), livingEntity.func_130014_f_(), 3, 0.2f);
        }
    }

    @Override
    public List<ResourceLocation> getLootChests() {
        return Collections.singletonList(LootTables.field_186421_c);
    }

    @Override
    public Class<Stats> getConfigClass() {
        return Stats.class;
    }

    public static class Stats
    extends RelicStats {
        public int useCooldown = 60;
        public int delayDuration = 10;
        public float damageMultiplier = 1.0f;
        public float healMultiplier = 2.0f;
    }

    @Mod.EventBusSubscriber(modid="relics")
    public static class DelayRingEvents {
        @SubscribeEvent
        public static void onEntityDeath(LivingDeathEvent event) {
            if (event.getEntityLiving() instanceof PlayerEntity) {
                ItemStack stack;
                PlayerEntity player = (PlayerEntity)event.getEntityLiving();
                if (CuriosApi.getCuriosHelper().findEquippedCurio((Item)ItemRegistry.DELAY_RING.get(), (LivingEntity)player).isPresent() && !NBTUtils.getBoolean(stack = (ItemStack)((ImmutableTriple)CuriosApi.getCuriosHelper().findEquippedCurio((Item)ItemRegistry.DELAY_RING.get(), (LivingEntity)player).get()).getRight(), DelayRingItem.TAG_IS_ACTIVE, false) && !player.func_184811_cZ().func_185141_a((Item)ItemRegistry.DELAY_RING.get())) {
                    if (event.getSource().func_76346_g() instanceof PlayerEntity) {
                        NBTUtils.setString(stack, DelayRingItem.TAG_KILLER_UUID, event.getSource().func_76346_g().func_110124_au().toString());
                    }
                    NBTUtils.setBoolean(stack, DelayRingItem.TAG_IS_ACTIVE, true);
                    player.func_70606_j(1.0f);
                    event.setCanceled(true);
                }
            }
        }

        @SubscribeEvent
        public static void onEntityHurt(LivingHurtEvent event) {
            Stats config = (Stats)INSTANCE.config;
            if (event.getEntityLiving() instanceof PlayerEntity) {
                ItemStack stack;
                PlayerEntity player = (PlayerEntity)event.getEntityLiving();
                if (CuriosApi.getCuriosHelper().findEquippedCurio((Item)ItemRegistry.DELAY_RING.get(), (LivingEntity)player).isPresent() && NBTUtils.getBoolean(stack = (ItemStack)((ImmutableTriple)CuriosApi.getCuriosHelper().findEquippedCurio((Item)ItemRegistry.DELAY_RING.get(), (LivingEntity)player).get()).getRight(), DelayRingItem.TAG_IS_ACTIVE, false) && NBTUtils.getInt(stack, DelayRingItem.TAG_UPDATE_TIME, 0) < config.delayDuration) {
                    NBTUtils.setInt(stack, DelayRingItem.TAG_STORED_AMOUNT, NBTUtils.getInt(stack, DelayRingItem.TAG_STORED_AMOUNT, 0) - Math.round(event.getAmount() * config.damageMultiplier));
                    event.setCanceled(true);
                }
            }
        }

        @SubscribeEvent
        public static void onEntityHeal(LivingHealEvent event) {
            Stats config = (Stats)INSTANCE.config;
            if (event.getEntityLiving() instanceof PlayerEntity) {
                ItemStack stack;
                PlayerEntity player = (PlayerEntity)event.getEntityLiving();
                if (CuriosApi.getCuriosHelper().findEquippedCurio((Item)ItemRegistry.DELAY_RING.get(), (LivingEntity)player).isPresent() && NBTUtils.getBoolean(stack = (ItemStack)((ImmutableTriple)CuriosApi.getCuriosHelper().findEquippedCurio((Item)ItemRegistry.DELAY_RING.get(), (LivingEntity)player).get()).getRight(), DelayRingItem.TAG_IS_ACTIVE, false)) {
                    NBTUtils.setInt(stack, DelayRingItem.TAG_STORED_AMOUNT, NBTUtils.getInt(stack, DelayRingItem.TAG_STORED_AMOUNT, 0) + Math.round(event.getAmount() * config.healMultiplier));
                    event.setCanceled(true);
                }
            }
        }
    }
}

