/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.items.relics;

import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.mojang.blaze3d.matrix.MatrixStack;
import it.hurts.sskirillss.relics.configs.variables.stats.RelicStats;
import it.hurts.sskirillss.relics.init.ItemRegistry;
import it.hurts.sskirillss.relics.items.RelicItem;
import it.hurts.sskirillss.relics.items.relics.renderer.DrownedBeltModel;
import it.hurts.sskirillss.relics.utils.RelicUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.capability.ICurio;
import top.theillusivec4.curios.api.type.capability.ICurioItem;

public class DrownedBeltItem
extends RelicItem<Stats>
implements ICurioItem {
    public static DrownedBeltItem INSTANCE;
    private final ResourceLocation TEXTURE = new ResourceLocation("relics", "textures/items/models/drowned_belt.png");

    public DrownedBeltItem() {
        super(Rarity.UNCOMMON);
        INSTANCE = this;
    }

    @Override
    public List<ITextComponent> getShiftTooltip(ItemStack stack) {
        ArrayList tooltip = Lists.newArrayList();
        tooltip.add(new TranslationTextComponent("tooltip.relics.drowned_belt.shift_1"));
        return tooltip;
    }

    public void curioTick(String identifier, int index, LivingEntity livingEntity, ItemStack stack) {
        if (livingEntity.func_70090_H()) {
            livingEntity.func_70050_g(livingEntity.func_205010_bg());
        }
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(String identifier, ItemStack stack) {
        Multimap result = super.getAttributeModifiers(identifier, stack);
        result.put((Object)ForgeMod.SWIM_SPEED.get(), (Object)new AttributeModifier(UUID.fromString("1a0aa526-7a44-42a7-9d6d-a3d2fae599ef"), "relics:drowned_belt_swim_speed", (double)((Stats)this.config).swimSpeedModifier, AttributeModifier.Operation.MULTIPLY_TOTAL));
        return result;
    }

    @Override
    public List<ResourceLocation> getLootChests() {
        return RelicUtils.Worldgen.AQUATIC;
    }

    @Override
    public Class<Stats> getConfigClass() {
        return Stats.class;
    }

    public void render(String identifier, int index, MatrixStack matrixStack, IRenderTypeBuffer renderTypeBuffer, int light, LivingEntity livingEntity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, ItemStack stack) {
        DrownedBeltModel model = new DrownedBeltModel();
        matrixStack.func_227860_a_();
        model.func_225597_a_(livingEntity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        model.func_212843_a_(livingEntity, limbSwing, limbSwingAmount, partialTicks);
        ICurio.RenderHelper.followBodyRotations((LivingEntity)livingEntity, (BipedModel[])new BipedModel[]{model});
        model.func_225598_a_(matrixStack, renderTypeBuffer.getBuffer(RenderType.func_228638_b_((ResourceLocation)this.TEXTURE)), light, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
        matrixStack.func_227865_b_();
    }

    public boolean canRender(String identifier, int index, LivingEntity livingEntity, ItemStack stack) {
        return true;
    }

    public static class Stats
    extends RelicStats {
        public float swimSpeedModifier = -0.25f;
        public float incomingDamageMultiplier = 1.5f;
        public float dealtDamageMultiplier = 3.0f;
    }

    @Mod.EventBusSubscriber(modid="relics")
    public static class DrownedBeltServerEvents {
        @SubscribeEvent
        public static void onEntityHurt(LivingHurtEvent event) {
            PlayerEntity player;
            Stats config = (Stats)INSTANCE.config;
            if (event.getEntityLiving() instanceof PlayerEntity) {
                player = (PlayerEntity)event.getEntityLiving();
                if (CuriosApi.getCuriosHelper().findEquippedCurio((Item)ItemRegistry.DROWNED_BELT.get(), (LivingEntity)player).isPresent() && player.func_70090_H()) {
                    event.setAmount(event.getAmount() * config.incomingDamageMultiplier);
                }
            }
            if (event.getSource().func_76346_g() instanceof PlayerEntity) {
                player = (PlayerEntity)event.getSource().func_76346_g();
                if (CuriosApi.getCuriosHelper().findEquippedCurio((Item)ItemRegistry.DROWNED_BELT.get(), (LivingEntity)player).isPresent() && player.func_70090_H()) {
                    event.setAmount(event.getAmount() * config.dealtDamageMultiplier);
                }
            }
        }
    }
}

