/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.items.relics;

import com.google.common.collect.Lists;
import it.hurts.sskirillss.relics.configs.variables.stats.RelicStats;
import it.hurts.sskirillss.relics.items.RelicItem;
import it.hurts.sskirillss.relics.particles.circle.CircleTintData;
import it.hurts.sskirillss.relics.utils.MathUtils;
import it.hurts.sskirillss.relics.utils.NBTUtils;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.AreaEffectCloudEntity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.loot.LootTables;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import org.jetbrains.annotations.Nullable;
import top.theillusivec4.curios.api.type.capability.ICurioItem;

public class ElytraBoosterItem
extends RelicItem<Stats>
implements ICurioItem {
    public static final String TAG_BREATH_AMOUNT = "breath";

    public ElytraBoosterItem() {
        super(Rarity.RARE);
    }

    @Override
    public List<ITextComponent> getShiftTooltip(ItemStack stack) {
        ArrayList tooltip = Lists.newArrayList();
        tooltip.add(new TranslationTextComponent("tooltip.relics.elytra_booster.shift_1"));
        tooltip.add(new TranslationTextComponent("tooltip.relics.elytra_booster.shift_2"));
        return tooltip;
    }

    @Override
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        if (NBTUtils.getInt(stack, TAG_BREATH_AMOUNT, 0) > 0) {
            tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.relics.elytra_booster.tooltip_1", new Object[]{NBTUtils.getInt(stack, TAG_BREATH_AMOUNT, 0)}));
        }
    }

    public void curioTick(String identifier, int index, LivingEntity livingEntity, ItemStack stack) {
        block8: {
            int breath;
            PlayerEntity player;
            block9: {
                if (!(livingEntity instanceof PlayerEntity)) break block8;
                player = (PlayerEntity)livingEntity;
                breath = NBTUtils.getInt(stack, TAG_BREATH_AMOUNT, 0);
                if (!player.func_184613_cA()) break block9;
                if (!player.func_225608_bj_() || breath <= 0) break block8;
                Vector3d look = player.func_70040_Z();
                Vector3d motion = player.func_213322_ci();
                player.func_213317_d(motion.func_72441_c(look.field_72450_a * 0.1 + (look.field_72450_a * (double)((Stats)this.config).flySpeed - motion.field_72450_a) * 0.5, look.field_72448_b * 0.1 + (look.field_72448_b * (double)((Stats)this.config).flySpeed - motion.field_72448_b) * 0.5, look.field_72449_c * 0.1 + (look.field_72449_c * (double)((Stats)this.config).flySpeed - motion.field_72449_c) * 0.5));
                player.func_130014_f_().func_195594_a((IParticleData)ParticleTypes.field_197616_i, player.func_226277_ct_() + (double)(MathUtils.randomFloat(player.func_130014_f_().func_201674_k()) * 0.5f), player.func_226278_cu_() + (double)(MathUtils.randomFloat(player.func_130014_f_().func_201674_k()) * 0.5f), player.func_226281_cx_() + (double)(MathUtils.randomFloat(player.func_130014_f_().func_201674_k()) * 0.5f), 0.0, 0.0, 0.0);
                if (player.field_70173_aa % 20 == 0) {
                    NBTUtils.setInt(stack, TAG_BREATH_AMOUNT, breath - 1);
                }
                for (LivingEntity entity : player.func_130014_f_().func_217357_a(LivingEntity.class, player.func_174813_aQ().func_186662_g(2.0))) {
                    if (entity.func_110124_au().equals(player.func_110124_au())) continue;
                    entity.func_213317_d(entity.func_213303_ch().func_178788_d(player.func_213303_ch()).func_72432_b().func_216372_d((double)((Stats)this.config).ramKnockback, (double)((Stats)this.config).ramKnockback, (double)((Stats)this.config).ramKnockback));
                    entity.func_70097_a(DamageSource.func_76365_a((PlayerEntity)player), ((Stats)this.config).ramDamage);
                }
                break block8;
            }
            if (breath < ((Stats)this.config).breathCapacity) {
                if (player.func_130014_f_().func_234923_W_() == World.field_234920_i_ && player.field_70173_aa % (((Stats)this.config).breathRegenerationCooldown * 20) == 0) {
                    NBTUtils.setInt(stack, TAG_BREATH_AMOUNT, breath + 1);
                }
                if (player.func_225608_bj_()) {
                    for (AreaEffectCloudEntity cloud : player.func_130014_f_().func_217357_a(AreaEffectCloudEntity.class, player.func_174813_aQ().func_186662_g((double)((Stats)this.config).breathConsumptionRadius))) {
                        if (cloud.func_195058_l() != ParticleTypes.field_197616_i) continue;
                        if (player.field_70173_aa % 5 == 0) {
                            NBTUtils.setInt(stack, TAG_BREATH_AMOUNT, breath + 1);
                        }
                        if (cloud.func_184490_j() <= 0.0f) {
                            cloud.func_70106_y();
                        }
                        cloud.func_184483_a(cloud.func_184490_j() - ((Stats)this.config).breathConsumptionSpeed);
                        Vector3d direction = player.func_213303_ch().func_72441_c(0.0, 1.0, 0.0).func_178788_d(cloud.func_213303_ch()).func_72432_b();
                        player.func_130014_f_().func_195594_a((IParticleData)new CircleTintData(new Color(0.35f, 0.0f, 1.0f), (float)player.func_213303_ch().func_72441_c(0.0, 1.0, 0.0).func_72438_d(cloud.func_213303_ch()) * 0.075f, (int)player.func_213303_ch().func_72441_c(0.0, 1.0, 0.0).func_72438_d(cloud.func_213303_ch()) * 5, 0.95f, false), cloud.func_226277_ct_(), cloud.func_226278_cu_(), cloud.func_226281_cx_(), direction.field_72450_a * (double)0.2f, direction.field_72448_b * (double)0.2f, direction.field_72449_c * (double)0.2f);
                    }
                }
            }
        }
    }

    @Override
    public List<ResourceLocation> getLootChests() {
        return Collections.singletonList(LootTables.field_186421_c);
    }

    @Override
    public Class<Stats> getConfigClass() {
        return Stats.class;
    }

    public static class Stats
    extends RelicStats {
        public float flySpeed = 1.5f;
        public float ramDamage = 5.0f;
        public float ramKnockback = 3.0f;
        public int breathConsumptionRadius = 10;
        public int breathCapacity = 1000;
        public float breathConsumptionSpeed = 0.02f;
        public int breathRegenerationCooldown = 2;
    }
}

