/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.items.relics;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import it.hurts.sskirillss.relics.configs.variables.stats.RelicStats;
import it.hurts.sskirillss.relics.init.ItemRegistry;
import it.hurts.sskirillss.relics.items.RelicItem;
import it.hurts.sskirillss.relics.items.relics.renderer.EndersHandModel;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import it.hurts.sskirillss.relics.utils.NBTUtils;
import it.hurts.sskirillss.relics.utils.RelicUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.monster.EndermanEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.FOVUpdateEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.capability.ICurio;
import top.theillusivec4.curios.api.type.capability.ICurioItem;

public class EndersHandItem
extends RelicItem<Stats>
implements ICurioItem {
    public static final String TAG_UPDATE_TIME = "time";
    private final ResourceLocation TEXTURE = new ResourceLocation("relics", "textures/items/models/enders_hand.png");

    public EndersHandItem() {
        super(Rarity.RARE);
    }

    @Override
    public List<ITextComponent> getShiftTooltip(ItemStack stack) {
        ArrayList tooltip = Lists.newArrayList();
        tooltip.add(new TranslationTextComponent("tooltip.relics.enders_hand.shift_1"));
        return tooltip;
    }

    public void curioTick(String identifier, int index, LivingEntity livingEntity, ItemStack stack) {
        if (livingEntity instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)livingEntity;
            int time = NBTUtils.getInt(stack, TAG_UPDATE_TIME, 0);
            if (!player.func_184811_cZ().func_185141_a(stack.func_77973_b())) {
                if (player.func_225608_bj_()) {
                    Predicate<Entity> predicate = entity -> !entity.func_175149_v() && entity.func_70067_L();
                    EntityRayTraceResult result = EntityUtils.rayTraceEntity((Entity)player, predicate, ((Stats)this.config).maxDistance);
                    if (result != null && result.func_216348_a() instanceof EndermanEntity) {
                        if (time >= ((Stats)this.config).preparationTime * 20) {
                            Vector3d swapVec = player.func_213303_ch();
                            EndermanEntity enderman = (EndermanEntity)result.func_216348_a();
                            player.func_70634_a(enderman.func_226277_ct_(), enderman.func_226278_cu_(), enderman.func_226281_cx_());
                            player.func_130014_f_().func_184148_a(null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), SoundEvents.field_187534_aX, SoundCategory.PLAYERS, 1.0f, 1.0f);
                            enderman.func_70634_a(swapVec.func_82615_a(), swapVec.func_82617_b(), swapVec.func_82616_c());
                            player.func_130014_f_().func_184148_a(null, swapVec.func_82615_a(), swapVec.func_82617_b(), swapVec.func_82616_c(), SoundEvents.field_187534_aX, SoundCategory.PLAYERS, 1.0f, 1.0f);
                            NBTUtils.setInt(stack, TAG_UPDATE_TIME, 0);
                            player.func_184811_cZ().func_185145_a(stack.func_77973_b(), ((Stats)this.config).cooldown * 20);
                        } else {
                            NBTUtils.setInt(stack, TAG_UPDATE_TIME, time + 1);
                        }
                    } else if (time > 0) {
                        NBTUtils.setInt(stack, TAG_UPDATE_TIME, time - 1);
                    }
                } else if (time > 0) {
                    NBTUtils.setInt(stack, TAG_UPDATE_TIME, time - 1);
                }
            }
        }
    }

    @Override
    public List<ResourceLocation> getLootChests() {
        return RelicUtils.Worldgen.CAVE;
    }

    @Override
    public Class<Stats> getConfigClass() {
        return Stats.class;
    }

    public void render(String identifier, int index, MatrixStack matrixStack, IRenderTypeBuffer renderTypeBuffer, int light, LivingEntity livingEntity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, ItemStack stack) {
        EndersHandModel model = new EndersHandModel();
        matrixStack.func_227860_a_();
        model.func_225597_a_(livingEntity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        model.func_212843_a_(livingEntity, limbSwing, limbSwingAmount, partialTicks);
        ICurio.RenderHelper.followBodyRotations((LivingEntity)livingEntity, (BipedModel[])new BipedModel[]{model});
        model.func_225598_a_(matrixStack, renderTypeBuffer.getBuffer(RenderType.func_228644_e_((ResourceLocation)this.TEXTURE)), light, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
        matrixStack.func_227865_b_();
    }

    public boolean canRender(String identifier, int index, LivingEntity livingEntity, ItemStack stack) {
        return true;
    }

    public static class Stats
    extends RelicStats {
        public int preparationTime = 1;
        public int maxDistance = 64;
        public int cooldown = 10;
    }

    @Mod.EventBusSubscriber(modid="relics", value={Dist.CLIENT})
    public static class EndersHandClientEvents {
        @SubscribeEvent
        public static void onFOVUpdate(FOVUpdateEvent event) {
            int time;
            if (CuriosApi.getCuriosHelper().findEquippedCurio((Item)ItemRegistry.ENDERS_HAND.get(), (LivingEntity)event.getEntity()).isPresent() && (time = NBTUtils.getInt((ItemStack)((ImmutableTriple)CuriosApi.getCuriosHelper().findEquippedCurio((Item)ItemRegistry.ENDERS_HAND.get(), (LivingEntity)event.getEntity()).get()).getRight(), EndersHandItem.TAG_UPDATE_TIME, 0)) > 0) {
                event.setNewfov(event.getNewfov() - (float)time / 32.0f);
            }
        }
    }
}

