/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.items.relics;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import it.hurts.sskirillss.relics.configs.variables.stats.RelicStats;
import it.hurts.sskirillss.relics.init.ItemRegistry;
import it.hurts.sskirillss.relics.items.RelicItem;
import it.hurts.sskirillss.relics.items.relics.renderer.FragrantFlowerModel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.passive.BeeEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.loot.LootTables;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.TickRangeConverter;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingHealEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.Nullable;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.capability.ICurio;
import top.theillusivec4.curios.api.type.capability.ICurioItem;

public class FragrantFlowerItem
extends RelicItem<Stats>
implements ICurioItem {
    public static FragrantFlowerItem INSTANCE;
    private final ResourceLocation TEXTURE = new ResourceLocation("relics", "textures/items/models/fragrant_flower.png");

    public FragrantFlowerItem() {
        super(Rarity.UNCOMMON);
        INSTANCE = this;
    }

    @Override
    public List<ITextComponent> getShiftTooltip(ItemStack stack) {
        ArrayList tooltip = Lists.newArrayList();
        tooltip.add(new TranslationTextComponent("tooltip.relics.fragrant_flower.shift_1"));
        tooltip.add(new TranslationTextComponent("tooltip.relics.fragrant_flower.shift_2"));
        return tooltip;
    }

    @Override
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
    }

    public void curioTick(String identifier, int index, LivingEntity livingEntity, ItemStack stack) {
        if (!(livingEntity instanceof PlayerEntity)) {
            return;
        }
        PlayerEntity player = (PlayerEntity)livingEntity;
        if (player.field_70173_aa % 5 != 0) {
            return;
        }
        for (BeeEntity bee : player.func_130014_f_().func_217357_a(BeeEntity.class, player.func_174813_aQ().func_72314_b((double)((Stats)this.config).luringRadius, (double)((Stats)this.config).luringRadius, (double)((Stats)this.config).luringRadius))) {
            if (bee.func_230257_G__() == null || !bee.func_230257_G__().equals(player.func_110124_au())) continue;
            bee.func_70604_c(null);
            bee.func_230259_a_(null);
            bee.func_70624_b(null);
            bee.func_230260_a__(0);
        }
    }

    @Override
    public List<ResourceLocation> getLootChests() {
        return Collections.singletonList(LootTables.field_186430_l);
    }

    @Override
    public Class<Stats> getConfigClass() {
        return Stats.class;
    }

    public void render(String identifier, int index, MatrixStack matrixStack, IRenderTypeBuffer renderTypeBuffer, int light, LivingEntity livingEntity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, ItemStack stack) {
        FragrantFlowerModel model = new FragrantFlowerModel();
        matrixStack.func_227860_a_();
        model.func_225597_a_(livingEntity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        model.func_212843_a_(livingEntity, limbSwing, limbSwingAmount, partialTicks);
        ICurio.RenderHelper.followBodyRotations((LivingEntity)livingEntity, (BipedModel[])new BipedModel[]{model});
        model.func_225598_a_(matrixStack, renderTypeBuffer.getBuffer(RenderType.func_228638_b_((ResourceLocation)this.TEXTURE)), light, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
        matrixStack.func_227865_b_();
    }

    public boolean canRender(String identifier, int index, LivingEntity livingEntity, ItemStack stack) {
        return true;
    }

    public static class Stats
    extends RelicStats {
        public int luringRadius = 16;
        public float damageMultiplier = 3.0f;
        public float healingMultiplier = 0.5f;
    }

    @Mod.EventBusSubscriber(modid="relics")
    public static class FragrantFlowerServerEvents {
        @SubscribeEvent
        public static void onEntityDamage(LivingHurtEvent event) {
            block6: {
                Item item;
                Stats config;
                block7: {
                    block5: {
                        config = (Stats)INSTANCE.config;
                        item = (Item)ItemRegistry.FRAGRANT_FLOWER.get();
                        if (!(event.getSource().func_76346_g() instanceof PlayerEntity)) break block5;
                        PlayerEntity player = (PlayerEntity)event.getSource().func_76346_g();
                        LivingEntity target = event.getEntityLiving();
                        if (!CuriosApi.getCuriosHelper().findEquippedCurio(item, (LivingEntity)player).isPresent() || target instanceof BeeEntity) {
                            return;
                        }
                        for (BeeEntity bee : player.func_130014_f_().func_217357_a(BeeEntity.class, player.func_174813_aQ().func_72314_b((double)config.luringRadius, (double)config.luringRadius, (double)config.luringRadius))) {
                            bee.func_70604_c(target);
                            bee.func_230259_a_(target.func_110124_au());
                            bee.func_70624_b(target);
                            bee.func_230260_a__(TickRangeConverter.func_233037_a_((int)20, (int)39).func_233018_a_(bee.func_130014_f_().func_201674_k()));
                        }
                        break block6;
                    }
                    if (!(event.getSource().func_76346_g() instanceof BeeEntity)) break block7;
                    BeeEntity bee = (BeeEntity)event.getSource().func_76346_g();
                    for (PlayerEntity player : bee.func_130014_f_().func_217357_a(PlayerEntity.class, bee.func_174813_aQ().func_72314_b((double)config.luringRadius, (double)config.luringRadius, (double)config.luringRadius))) {
                        if (!CuriosApi.getCuriosHelper().findEquippedCurio(item, (LivingEntity)player).isPresent()) continue;
                        event.setAmount(event.getAmount() * config.damageMultiplier);
                    }
                    break block6;
                }
                if (!(event.getEntityLiving() instanceof PlayerEntity) || !(event.getSource().func_76346_g() instanceof LivingEntity)) break block6;
                PlayerEntity player = (PlayerEntity)event.getEntityLiving();
                LivingEntity source = (LivingEntity)event.getSource().func_76346_g();
                if (!CuriosApi.getCuriosHelper().findEquippedCurio(item, (LivingEntity)player).isPresent() || source instanceof BeeEntity) {
                    return;
                }
                for (BeeEntity bee : player.func_130014_f_().func_217357_a(BeeEntity.class, player.func_174813_aQ().func_72314_b((double)config.luringRadius, (double)config.luringRadius, (double)config.luringRadius))) {
                    if (bee.func_230257_G__() != null) continue;
                    bee.func_70604_c(source);
                    bee.func_230259_a_(source.func_110124_au());
                    bee.func_70624_b(source);
                    bee.func_230260_a__(TickRangeConverter.func_233037_a_((int)20, (int)39).func_233018_a_(bee.func_130014_f_().func_201674_k()));
                }
            }
        }

        @SubscribeEvent
        public static void onEntityHeal(LivingHealEvent event) {
            Stats config = (Stats)INSTANCE.config;
            if (!(event.getEntityLiving() instanceof PlayerEntity)) {
                return;
            }
            PlayerEntity player = (PlayerEntity)event.getEntity();
            List bees = player.func_130014_f_().func_217357_a(BeeEntity.class, player.func_174813_aQ().func_72314_b((double)config.luringRadius, (double)config.luringRadius, (double)config.luringRadius));
            if (bees.isEmpty()) {
                return;
            }
            event.setAmount(event.getAmount() + event.getAmount() * ((float)bees.size() * config.healingMultiplier));
        }
    }
}

