/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.items.relics;

import com.google.common.collect.Lists;
import it.hurts.sskirillss.relics.configs.variables.stats.RelicStats;
import it.hurts.sskirillss.relics.init.ItemRegistry;
import it.hurts.sskirillss.relics.items.RelicItem;
import it.hurts.sskirillss.relics.utils.RelicUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import top.theillusivec4.curios.api.CuriosApi;

public class HolyLocketItem
extends RelicItem<Stats> {
    public static HolyLocketItem INSTANCE;

    public HolyLocketItem() {
        super(Rarity.RARE);
        INSTANCE = this;
    }

    @Override
    public List<ITextComponent> getShiftTooltip(ItemStack stack) {
        ArrayList tooltip = Lists.newArrayList();
        tooltip.add(new TranslationTextComponent("tooltip.relics.holy_locket.shift_1"));
        tooltip.add(new TranslationTextComponent("tooltip.relics.holy_locket.shift_2"));
        return tooltip;
    }

    @Override
    public List<ResourceLocation> getLootChests() {
        return RelicUtils.Worldgen.DESERT;
    }

    @Override
    public Class<Stats> getConfigClass() {
        return Stats.class;
    }

    public static class Stats
    extends RelicStats {
        public float damageMultiplier = 1.5f;
        public float igniteChance = 0.25f;
        public int burnDuration = 4;
        public float healChance = 0.1f;
        public int invulnerabilityTime = 10;
    }

    @Mod.EventBusSubscriber
    static class HolyLocketEvents {
        HolyLocketEvents() {
        }

        @SubscribeEvent
        public static void onLivingHurt(LivingHurtEvent event) {
            Stats config = (Stats)INSTANCE.config;
            Item item = (Item)ItemRegistry.HOLY_LOCKET.get();
            if (event.getSource().func_76346_g() instanceof PlayerEntity) {
                PlayerEntity player = (PlayerEntity)event.getSource().func_76346_g();
                LivingEntity entity = event.getEntityLiving();
                if (!entity.func_70662_br()) {
                    return;
                }
                CuriosApi.getCuriosHelper().findEquippedCurio(item, (LivingEntity)player).ifPresent(triple -> {
                    if (player.func_130014_f_().field_73012_v.nextFloat() <= config.igniteChance) {
                        entity.func_70015_d(config.burnDuration);
                    }
                    event.setAmount(event.getAmount() * config.damageMultiplier);
                });
            } else if (event.getEntityLiving() instanceof PlayerEntity) {
                PlayerEntity player = (PlayerEntity)event.getEntityLiving();
                CuriosApi.getCuriosHelper().findEquippedCurio(item, (LivingEntity)player).ifPresent(triple -> {
                    if (field_77697_d.nextFloat() <= config.healChance) {
                        player.func_70691_i(event.getAmount());
                        event.setCanceled(true);
                        return;
                    }
                    if (player.func_184811_cZ().func_185141_a(item)) {
                        event.setCanceled(true);
                    } else {
                        player.func_184811_cZ().func_185145_a(item, config.invulnerabilityTime);
                    }
                });
            }
        }

        @SubscribeEvent
        public static void onLivingDamage(LivingAttackEvent event) {
            Item item = (Item)ItemRegistry.HOLY_LOCKET.get();
            if (!(event.getEntityLiving() instanceof PlayerEntity)) {
                return;
            }
            PlayerEntity player = (PlayerEntity)event.getEntityLiving();
            if (CuriosApi.getCuriosHelper().findEquippedCurio(item, (LivingEntity)player).isPresent() && player.func_184811_cZ().func_185141_a(item)) {
                event.setCanceled(true);
            }
        }
    }
}

