/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.items.relics;

import com.google.common.collect.Lists;
import it.hurts.sskirillss.relics.configs.variables.stats.RelicStats;
import it.hurts.sskirillss.relics.init.ItemRegistry;
import it.hurts.sskirillss.relics.items.RelicItem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.loot.LootTables;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.capability.ICurioItem;

public class HunterBeltItem
extends RelicItem<Stats>
implements ICurioItem {
    public static HunterBeltItem INSTANCE;

    public HunterBeltItem() {
        super(Rarity.UNCOMMON);
        INSTANCE = this;
    }

    @Override
    public List<ITextComponent> getShiftTooltip(ItemStack stack) {
        ArrayList tooltip = Lists.newArrayList();
        tooltip.add(new TranslationTextComponent("tooltip.relics.hunter_belt.shift_1"));
        return tooltip;
    }

    public int getLootingBonus(String identifier, LivingEntity livingEntity, ItemStack curio, int index) {
        return ((Stats)this.config).additionalLooting;
    }

    @Override
    public List<ResourceLocation> getLootChests() {
        return Collections.singletonList(LootTables.field_215820_k);
    }

    @Override
    public Class<Stats> getConfigClass() {
        return Stats.class;
    }

    public static class Stats
    extends RelicStats {
        public int additionalLooting = 1;
        public float playerDamageMultiplier = 2.0f;
        public float petDamageMultiplier = 3.0f;
    }

    @Mod.EventBusSubscriber(modid="relics")
    public static class HunterBeltEvents {
        @SubscribeEvent
        public static void onLivingDamage(LivingHurtEvent event) {
            TameableEntity pet;
            Stats config = (Stats)INSTANCE.config;
            if (event.getSource().func_76346_g() instanceof PlayerEntity && event.getEntityLiving() instanceof AnimalEntity) {
                PlayerEntity player = (PlayerEntity)event.getSource().func_76346_g();
                if (CuriosApi.getCuriosHelper().findEquippedCurio((Item)ItemRegistry.HUNTER_BELT.get(), (LivingEntity)player).isPresent()) {
                    event.setAmount(event.getAmount() * config.playerDamageMultiplier);
                }
            }
            if (event.getSource().func_76346_g() instanceof TameableEntity && (pet = (TameableEntity)event.getSource().func_76346_g()).func_70902_q() != null && pet.func_70902_q() instanceof PlayerEntity && CuriosApi.getCuriosHelper().findEquippedCurio((Item)ItemRegistry.HUNTER_BELT.get(), pet.func_70902_q()).isPresent()) {
                event.setAmount(event.getAmount() * config.petDamageMultiplier);
            }
        }
    }
}

