/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.items.relics;

import com.google.common.collect.Lists;
import it.hurts.sskirillss.relics.configs.variables.stats.RelicStats;
import it.hurts.sskirillss.relics.items.RelicItem;
import it.hurts.sskirillss.relics.utils.NBTUtils;
import it.hurts.sskirillss.relics.utils.RelicUtils;
import it.hurts.sskirillss.relics.utils.RelicsTab;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Food;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import top.theillusivec4.curios.api.type.capability.ICurioItem;

public class InfinityHamItem
extends RelicItem<Stats>
implements ICurioItem {
    public static final String TAG_PIECES = "pieces";
    private static final String TAG_CHARGE = "charge";

    public InfinityHamItem() {
        super(new Item.Properties().func_200916_a(RelicsTab.RELICS_TAB).func_200917_a(1).func_208103_a(Rarity.RARE).func_221540_a(new Food.Builder().func_221453_d()));
    }

    @Override
    public List<ITextComponent> getShiftTooltip(ItemStack stack) {
        ArrayList tooltip = Lists.newArrayList();
        tooltip.add(new TranslationTextComponent("tooltip.relics.infinity_ham.shift_1"));
        return tooltip;
    }

    @Override
    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (entityIn.field_70173_aa % 20 != 0) {
            return;
        }
        int pieces = NBTUtils.getInt(stack, TAG_PIECES, 0);
        if (pieces >= ((Stats)this.config).maxPieces) {
            return;
        }
        int charge = NBTUtils.getInt(stack, TAG_CHARGE, 0);
        if (charge >= ((Stats)this.config).rechargeTime) {
            NBTUtils.setInt(stack, TAG_PIECES, pieces + 1);
            NBTUtils.setInt(stack, TAG_CHARGE, 0);
        } else {
            NBTUtils.setInt(stack, TAG_CHARGE, charge + 1);
        }
        super.func_77663_a(stack, worldIn, entityIn, itemSlot, isSelected);
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (NBTUtils.getInt(stack, TAG_PIECES, 0) > 0 && player.func_71024_bL().func_75121_c()) {
            return super.func_77659_a(world, player, hand);
        }
        return ActionResult.func_226251_d_((Object)stack);
    }

    public ItemStack func_77654_b(ItemStack stack, World world, LivingEntity entity) {
        if (!(entity instanceof PlayerEntity)) {
            return stack;
        }
        PlayerEntity player = (PlayerEntity)entity;
        int pieces = NBTUtils.getInt(stack, TAG_PIECES, 0);
        if (pieces > 0) {
            NBTUtils.setInt(stack, TAG_PIECES, pieces - 1);
            player.func_71024_bL().func_75114_a(((Stats)this.config).feedAmount);
        }
        return stack;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged;
    }

    public int func_77626_a(ItemStack stack) {
        return ((Stats)this.config).useDuration;
    }

    @Override
    public List<ResourceLocation> getLootChests() {
        return RelicUtils.Worldgen.CAVE;
    }

    @Override
    public Class<Stats> getConfigClass() {
        return Stats.class;
    }

    public static class Stats
    extends RelicStats {
        public int rechargeTime = 60;
        public int useDuration = 80;
        public int maxPieces = 3;
        public int feedAmount = 10;
    }
}

