/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.items.relics;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import it.hurts.sskirillss.relics.configs.variables.stats.RelicStats;
import it.hurts.sskirillss.relics.init.ItemRegistry;
import it.hurts.sskirillss.relics.items.RelicItem;
import it.hurts.sskirillss.relics.items.relics.renderer.JellyfishNecklaceModel;
import it.hurts.sskirillss.relics.utils.NBTUtils;
import it.hurts.sskirillss.relics.utils.RelicUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.event.entity.living.LivingHealEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.capability.ICurio;
import top.theillusivec4.curios.api.type.capability.ICurioItem;

public class JellyfishNecklaceItem
extends RelicItem<Stats>
implements ICurioItem {
    public static final String TAG_TIME = "time";
    public static final String TAG_CHARGES = "charges";
    public static JellyfishNecklaceItem INSTANCE;
    private final ResourceLocation TEXTURE = new ResourceLocation("relics", "textures/items/models/jellyfish_necklace.png");

    public JellyfishNecklaceItem() {
        super(Rarity.UNCOMMON);
        INSTANCE = this;
    }

    @Override
    public List<ITextComponent> getShiftTooltip(ItemStack stack) {
        ArrayList tooltip = Lists.newArrayList();
        tooltip.add(new TranslationTextComponent("tooltip.relics.jellyfish_necklace.shift_1"));
        tooltip.add(new TranslationTextComponent("tooltip.relics.jellyfish_necklace.shift_2"));
        return tooltip;
    }

    public void curioTick(String identifier, int index, LivingEntity livingEntity, ItemStack stack) {
        if (livingEntity instanceof PlayerEntity && livingEntity.field_70173_aa % 20 == 0) {
            int time = NBTUtils.getInt(stack, TAG_TIME, 0);
            int charges = NBTUtils.getInt(stack, TAG_CHARGES, 0);
            if (livingEntity.func_70090_H()) {
                List entities;
                if (time < ((Stats)this.config).chargePreparationTime && charges < ((Stats)this.config).maxCharges) {
                    NBTUtils.setInt(stack, TAG_TIME, time + 1);
                } else {
                    NBTUtils.setInt(stack, TAG_TIME, 0);
                    NBTUtils.setInt(stack, TAG_CHARGES, charges + 1);
                }
                if (charges > 0 && !(entities = livingEntity.func_130014_f_().func_217357_a(LivingEntity.class, livingEntity.func_174813_aQ().func_186662_g((double)((Stats)this.config).shockRadius))).isEmpty()) {
                    for (LivingEntity entity : entities) {
                        if (!entity.func_70090_H() || entity == livingEntity || entity instanceof TameableEntity && ((TameableEntity)entity).func_152114_e(livingEntity)) continue;
                        entity.func_70097_a(DamageSource.func_76365_a((PlayerEntity)((PlayerEntity)livingEntity)), (float)((Stats)this.config).damagePerCharge);
                        NBTUtils.setInt(stack, TAG_CHARGES, charges - 1);
                    }
                }
            } else if (time > 0) {
                NBTUtils.setInt(stack, TAG_TIME, time - 1);
            }
        }
    }

    @Override
    public List<ResourceLocation> getLootChests() {
        return RelicUtils.Worldgen.AQUATIC;
    }

    @Override
    public Class<Stats> getConfigClass() {
        return Stats.class;
    }

    public void render(String identifier, int index, MatrixStack matrixStack, IRenderTypeBuffer renderTypeBuffer, int light, LivingEntity livingEntity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, ItemStack stack) {
        JellyfishNecklaceModel model = new JellyfishNecklaceModel();
        matrixStack.func_227860_a_();
        model.func_225597_a_(livingEntity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        model.func_212843_a_(livingEntity, limbSwing, limbSwingAmount, partialTicks);
        ICurio.RenderHelper.followBodyRotations((LivingEntity)livingEntity, (BipedModel[])new BipedModel[]{model});
        model.func_225598_a_(matrixStack, renderTypeBuffer.getBuffer(RenderType.func_228644_e_((ResourceLocation)this.TEXTURE)), light, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
        matrixStack.func_227865_b_();
    }

    public boolean canRender(String identifier, int index, LivingEntity livingEntity, ItemStack stack) {
        return true;
    }

    public static class Stats
    extends RelicStats {
        public int chargePreparationTime = 60;
        public int maxCharges = 10;
        public int damagePerCharge = 10;
        public float healMultiplier = 2.0f;
        public float shockRadius = 1.2f;
    }

    @Mod.EventBusSubscriber(modid="relics")
    public static class JellyfishNecklaceEvents {
        @SubscribeEvent
        public static void onEntityHeal(LivingHealEvent event) {
            Stats config = (Stats)INSTANCE.config;
            if (event.getEntityLiving() instanceof PlayerEntity && event.getEntityLiving().func_70090_H() && CuriosApi.getCuriosHelper().findEquippedCurio((Item)ItemRegistry.JELLYFISH_NECKLACE.get(), event.getEntityLiving()).isPresent()) {
                event.setAmount(event.getAmount() * config.healMultiplier);
            }
        }
    }
}

