/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.items.relics;

import com.google.common.collect.Lists;
import it.hurts.sskirillss.relics.configs.variables.stats.RelicStats;
import it.hurts.sskirillss.relics.init.ItemRegistry;
import it.hurts.sskirillss.relics.items.RelicItem;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import it.hurts.sskirillss.relics.utils.RelicUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.commons.lang3.tuple.MutablePair;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurioItem;

public class MidnightRobeItem
extends RelicItem<Stats>
implements ICurioItem {
    private final MutablePair<String, UUID> SPEED_INFO = new MutablePair((Object)"relics:midnight_robe_movement_speed", (Object)UUID.fromString("21a949be-67d9-43bb-96b8-496782d60933"));
    public static MidnightRobeItem INSTANCE;

    public MidnightRobeItem() {
        super(Rarity.RARE);
        INSTANCE = this;
    }

    @Override
    public List<ITextComponent> getShiftTooltip(ItemStack stack) {
        ArrayList tooltip = Lists.newArrayList();
        tooltip.add(new TranslationTextComponent("tooltip.relics.midnight_robe.shift_1"));
        tooltip.add(new TranslationTextComponent("tooltip.relics.midnight_robe.shift_2"));
        return tooltip;
    }

    public void curioTick(String identifier, int index, LivingEntity livingEntity, ItemStack stack) {
        if (livingEntity.field_70173_aa % 20 != 0 || !(livingEntity instanceof PlayerEntity) || livingEntity.func_130014_f_().func_201670_d()) {
            return;
        }
        PlayerEntity player = (PlayerEntity)livingEntity;
        ModifiableAttributeInstance movementSpeed = livingEntity.func_110148_a(Attributes.field_233821_d_);
        AttributeModifier attribute = new AttributeModifier((UUID)this.SPEED_INFO.getRight(), (String)this.SPEED_INFO.getLeft(), (double)((Stats)this.config).speedModifier, AttributeModifier.Operation.MULTIPLY_TOTAL);
        if (MidnightRobeItem.canHide(livingEntity)) {
            player.func_195064_c(new EffectInstance(Effects.field_76441_p, 30, 0, false, false));
            EntityUtils.applyAttributeModifier(movementSpeed, attribute);
        } else {
            EntityUtils.removeAttributeModifier(movementSpeed, attribute);
        }
    }

    public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        EntityUtils.removeAttributeModifier(slotContext.getWearer().func_110148_a(Attributes.field_233821_d_), new AttributeModifier((UUID)this.SPEED_INFO.getRight(), (String)this.SPEED_INFO.getLeft(), (double)((Stats)this.config).speedModifier, AttributeModifier.Operation.MULTIPLY_TOTAL));
    }

    @Override
    public List<ResourceLocation> getLootChests() {
        return RelicUtils.Worldgen.CAVE;
    }

    @Override
    public Class<Stats> getConfigClass() {
        return Stats.class;
    }

    private static boolean canHide(LivingEntity entity) {
        Stats config = (Stats)MidnightRobeItem.INSTANCE.config;
        if (!(entity instanceof PlayerEntity)) {
            return false;
        }
        PlayerEntity player = (PlayerEntity)entity;
        return CuriosApi.getCuriosHelper().findEquippedCurio((Item)ItemRegistry.MIDNIGHT_ROBE.get(), (LivingEntity)player).filter(triple -> player.func_110143_aJ() <= player.func_110138_aP() * config.healthPercentage && player.func_130014_f_().func_226690_K_() && !player.func_184811_cZ().func_185141_a(((ItemStack)triple.getRight()).func_77973_b())).isPresent();
    }

    public static class Stats
    extends RelicStats {
        public float speedModifier = 1.25f;
        public float healthPercentage = 0.2f;
        public float damageMultiplier = 2.0f;
        public int stealthDamageCooldown = 5;
    }

    @Mod.EventBusSubscriber(modid="relics", value={Dist.CLIENT})
    public static class MidnightRobeClientEvents {
        @SubscribeEvent
        public static void onEntityRender(RenderPlayerEvent.Pre event) {
            Stats config = (Stats)INSTANCE.config;
            PlayerEntity player = event.getPlayer();
            if (CuriosApi.getCuriosHelper().findEquippedCurio((Item)ItemRegistry.MIDNIGHT_ROBE.get(), (LivingEntity)player).isPresent() && player.func_110143_aJ() <= player.func_110138_aP() * config.healthPercentage && player.func_130014_f_().func_242415_f(1.0f) > 0.26f && player.func_130014_f_().func_242415_f(1.0f) < 0.827f && !player.func_184811_cZ().func_185141_a((Item)ItemRegistry.MIDNIGHT_ROBE.get())) {
                event.setCanceled(true);
            }
        }
    }

    @Mod.EventBusSubscriber(modid="relics")
    public static class MidnightRobeServerEvents {
        @SubscribeEvent
        public static void onEntityDamage(LivingHurtEvent event) {
            Stats config = (Stats)INSTANCE.config;
            if (!(event.getSource().func_76346_g() instanceof PlayerEntity)) {
                return;
            }
            PlayerEntity player = (PlayerEntity)event.getSource().func_76346_g();
            if (!MidnightRobeItem.canHide((LivingEntity)player)) {
                return;
            }
            event.setAmount(event.getAmount() * config.damageMultiplier);
            player.func_184811_cZ().func_185145_a((Item)ItemRegistry.MIDNIGHT_ROBE.get(), config.stealthDamageCooldown * 20);
        }
    }
}

