/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.items.relics;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import it.hurts.sskirillss.relics.configs.variables.stats.RelicStats;
import it.hurts.sskirillss.relics.init.ItemRegistry;
import it.hurts.sskirillss.relics.items.RelicItem;
import it.hurts.sskirillss.relics.items.relics.renderer.RageGloveModel;
import it.hurts.sskirillss.relics.utils.NBTUtils;
import it.hurts.sskirillss.relics.utils.RelicUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.capability.ICurio;
import top.theillusivec4.curios.api.type.capability.ICurioItem;

public class RageGloveItem
extends RelicItem<Stats>
implements ICurioItem {
    public static final String TAG_UPDATE_TIME = "time";
    public static final String TAG_STACKS_AMOUNT = "stacks";
    public static final String TAG_TARGETED_ENTITY = "target";
    public static RageGloveItem INSTANCE;
    private final ResourceLocation TEXTURE = new ResourceLocation("relics", "textures/items/models/rage_glove.png");

    public RageGloveItem() {
        super(Rarity.RARE);
        INSTANCE = this;
    }

    @Override
    public List<ITextComponent> getShiftTooltip(ItemStack stack) {
        ArrayList tooltip = Lists.newArrayList();
        tooltip.add(new TranslationTextComponent("tooltip.relics.rage_glove.shift_1"));
        return tooltip;
    }

    public void curioTick(String identifier, int index, LivingEntity livingEntity, ItemStack stack) {
        if (livingEntity.field_70173_aa % 20 == 0) {
            int time = NBTUtils.getInt(stack, TAG_UPDATE_TIME, 0);
            int stacks = NBTUtils.getInt(stack, TAG_STACKS_AMOUNT, 0);
            if (stacks > 0) {
                NBTUtils.setInt(stack, TAG_UPDATE_TIME, time + 1);
                if (time >= ((Stats)this.config).stackDuration) {
                    NBTUtils.setInt(stack, TAG_STACKS_AMOUNT, stacks - 1);
                    NBTUtils.setInt(stack, TAG_UPDATE_TIME, 0);
                }
            }
        }
    }

    @Override
    public List<ResourceLocation> getLootChests() {
        return RelicUtils.Worldgen.NETHER;
    }

    @Override
    public Class<Stats> getConfigClass() {
        return Stats.class;
    }

    public void render(String identifier, int index, MatrixStack matrixStack, IRenderTypeBuffer renderTypeBuffer, int light, LivingEntity livingEntity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, ItemStack stack) {
        RageGloveModel model = new RageGloveModel();
        matrixStack.func_227860_a_();
        model.func_225597_a_(livingEntity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        model.func_212843_a_(livingEntity, limbSwing, limbSwingAmount, partialTicks);
        ICurio.RenderHelper.followBodyRotations((LivingEntity)livingEntity, (BipedModel[])new BipedModel[]{model});
        model.func_225598_a_(matrixStack, renderTypeBuffer.getBuffer(RenderType.func_228644_e_((ResourceLocation)this.TEXTURE)), light, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
        matrixStack.func_227865_b_();
    }

    public boolean canRender(String identifier, int index, LivingEntity livingEntity, ItemStack stack) {
        return true;
    }

    public static class Stats
    extends RelicStats {
        public int stackDuration = 5;
        public float minDamage = 3.0f;
        public float dealtDamageMultiplier = 0.1f;
        public float incomingDamageMultiplier = 0.05f;
    }

    @Mod.EventBusSubscriber(modid="relics")
    public static class RageGloveEvents {
        @SubscribeEvent
        public static void onLivingHurt(LivingHurtEvent event) {
            PlayerEntity player;
            Stats config = (Stats)INSTANCE.config;
            if (event.getSource().func_76346_g() instanceof PlayerEntity) {
                player = (PlayerEntity)event.getSource().func_76346_g();
                if (event.getAmount() > config.minDamage && CuriosApi.getCuriosHelper().findEquippedCurio((Item)ItemRegistry.RAGE_GLOVE.get(), (LivingEntity)player).isPresent()) {
                    LivingEntity entity = event.getEntityLiving();
                    ItemStack stack = (ItemStack)((ImmutableTriple)CuriosApi.getCuriosHelper().findEquippedCurio((Item)ItemRegistry.RAGE_GLOVE.get(), (LivingEntity)player).get()).getRight();
                    if (!NBTUtils.getString(stack, RageGloveItem.TAG_TARGETED_ENTITY, "").equals("") && UUID.fromString(NBTUtils.getString(stack, RageGloveItem.TAG_TARGETED_ENTITY, "")).equals(entity.func_110124_au())) {
                        NBTUtils.setInt(stack, RageGloveItem.TAG_STACKS_AMOUNT, NBTUtils.getInt(stack, RageGloveItem.TAG_STACKS_AMOUNT, 0) + 1);
                        NBTUtils.setInt(stack, RageGloveItem.TAG_UPDATE_TIME, 0);
                        event.setAmount(event.getAmount() + event.getAmount() * config.dealtDamageMultiplier * (float)NBTUtils.getInt(stack, RageGloveItem.TAG_STACKS_AMOUNT, 0));
                    } else {
                        NBTUtils.setInt(stack, RageGloveItem.TAG_UPDATE_TIME, 0);
                        NBTUtils.setInt(stack, RageGloveItem.TAG_STACKS_AMOUNT, 1);
                        NBTUtils.setString(stack, RageGloveItem.TAG_TARGETED_ENTITY, entity.func_110124_au().toString());
                    }
                }
            }
            if (event.getSource().func_76346_g() instanceof LivingEntity && event.getEntityLiving() instanceof PlayerEntity) {
                ItemStack stack;
                player = (PlayerEntity)event.getEntityLiving();
                if (CuriosApi.getCuriosHelper().findEquippedCurio((Item)ItemRegistry.RAGE_GLOVE.get(), (LivingEntity)player).isPresent() && !NBTUtils.getString(stack = (ItemStack)((ImmutableTriple)CuriosApi.getCuriosHelper().findEquippedCurio((Item)ItemRegistry.RAGE_GLOVE.get(), (LivingEntity)player).get()).getRight(), RageGloveItem.TAG_TARGETED_ENTITY, "").equals("") && event.getSource().func_76346_g() == ((ServerWorld)player.func_130014_f_()).func_217461_a(UUID.fromString(NBTUtils.getString(stack, RageGloveItem.TAG_TARGETED_ENTITY, "")))) {
                    event.setAmount(event.getAmount() + event.getAmount() * config.incomingDamageMultiplier * (float)NBTUtils.getInt(stack, RageGloveItem.TAG_STACKS_AMOUNT, 0));
                }
            }
        }
    }
}

