/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.items.relics;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import it.hurts.sskirillss.relics.configs.variables.stats.RelicStats;
import it.hurts.sskirillss.relics.init.ItemRegistry;
import it.hurts.sskirillss.relics.items.RelicItem;
import it.hurts.sskirillss.relics.items.relics.renderer.ReflectionNecklaceModel;
import it.hurts.sskirillss.relics.items.relics.renderer.ReflectionNecklaceShieldModel;
import it.hurts.sskirillss.relics.network.NetworkHandler;
import it.hurts.sskirillss.relics.network.PacketPlayerMotion;
import it.hurts.sskirillss.relics.utils.NBTUtils;
import it.hurts.sskirillss.relics.utils.RelicUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.DamagingProjectileEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.capability.ICurio;
import top.theillusivec4.curios.api.type.capability.ICurioItem;

public class ReflectionNecklaceItem
extends RelicItem<Stats>
implements ICurioItem {
    public static final String TAG_CHARGE_AMOUNT = "charges";
    public static final String TAG_UPDATE_TIME = "time";
    public static ReflectionNecklaceItem INSTANCE;
    private final ResourceLocation SHIELD_TEXTURE = new ResourceLocation("relics", "textures/items/models/reflection_necklace_shield.png");
    private final ResourceLocation TEXTURE = new ResourceLocation("relics", "textures/items/models/reflection_necklace.png");

    public ReflectionNecklaceItem() {
        super(Rarity.EPIC);
        INSTANCE = this;
    }

    @Override
    public List<ITextComponent> getShiftTooltip(ItemStack stack) {
        ArrayList tooltip = Lists.newArrayList();
        tooltip.add(new TranslationTextComponent("tooltip.relics.reflection_necklace.shift_1"));
        return tooltip;
    }

    public void curioTick(String identifier, int index, LivingEntity livingEntity, ItemStack stack) {
        if (livingEntity.field_70173_aa % 20 == 0) {
            int time = NBTUtils.getInt(stack, TAG_UPDATE_TIME, 0);
            int charges = NBTUtils.getInt(stack, TAG_CHARGE_AMOUNT, 0);
            if (charges < ((Stats)this.config).maxCharges) {
                if (time < (charges > 0 ? ((Stats)this.config).timePerCharge * charges : ((Stats)this.config).timePerCharge)) {
                    NBTUtils.setInt(stack, TAG_UPDATE_TIME, time + 1);
                } else {
                    NBTUtils.setInt(stack, TAG_UPDATE_TIME, 0);
                    NBTUtils.setInt(stack, TAG_CHARGE_AMOUNT, charges + 1);
                }
            }
        }
    }

    @Override
    public List<ResourceLocation> getLootChests() {
        return RelicUtils.Worldgen.NETHER;
    }

    @Override
    public Class<Stats> getConfigClass() {
        return Stats.class;
    }

    public void render(String identifier, int index, MatrixStack matrixStack, IRenderTypeBuffer renderTypeBuffer, int light, LivingEntity livingEntity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, ItemStack stack) {
        int charges = NBTUtils.getInt(stack, TAG_CHARGE_AMOUNT, 0);
        ReflectionNecklaceShieldModel shieldModel = new ReflectionNecklaceShieldModel();
        if (charges > 0) {
            for (int i = 0; i < charges; ++i) {
                matrixStack.func_227860_a_();
                matrixStack.func_227862_a_(0.5f, 0.5f, 0.5f);
                matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(MathHelper.func_76134_b((float)((float)livingEntity.field_70173_aa / 10.0f)) / 7.0f * 57.295776f));
                matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_((float)livingEntity.field_70173_aa / 10.0f * 57.295776f + (float)i * (360.0f / (float)charges)));
                matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(MathHelper.func_76126_a((float)((float)livingEntity.field_70173_aa / 10.0f)) / 7.0f * 57.295776f));
                matrixStack.func_227861_a_(0.0, 1.5, (double)(1.0f + (float)charges * 0.3f));
                shieldModel.func_225598_a_(matrixStack, renderTypeBuffer.getBuffer(RenderType.func_228644_e_((ResourceLocation)this.SHIELD_TEXTURE)), light, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
                matrixStack.func_227865_b_();
            }
        }
        ReflectionNecklaceModel model = new ReflectionNecklaceModel();
        matrixStack.func_227860_a_();
        model.func_225597_a_(livingEntity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        model.func_212843_a_(livingEntity, limbSwing, limbSwingAmount, partialTicks);
        ICurio.RenderHelper.followBodyRotations((LivingEntity)livingEntity, (BipedModel[])new BipedModel[]{model});
        model.func_225598_a_(matrixStack, renderTypeBuffer.getBuffer(RenderType.func_228644_e_((ResourceLocation)this.TEXTURE)), light, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
        matrixStack.func_227865_b_();
    }

    public boolean canRender(String identifier, int index, LivingEntity livingEntity, ItemStack stack) {
        return true;
    }

    public static class Stats
    extends RelicStats {
        public int maxCharges = 3;
        public int timePerCharge = 60;
        public int minDistanceForKnockback = 10;
        public float reflectedDamageMultiplier = 2.0f;
    }

    @Mod.EventBusSubscriber(modid="relics")
    public static class ReflectionNecklaceServerEvents {
        @SubscribeEvent
        public static void onEntityHurt(LivingHurtEvent event) {
            Stats config = (Stats)INSTANCE.config;
            if (event.getEntityLiving() instanceof PlayerEntity && CuriosApi.getCuriosHelper().findEquippedCurio((Item)ItemRegistry.REFLECTION_NECKLACE.get(), event.getEntityLiving()).isPresent()) {
                PlayerEntity player = (PlayerEntity)event.getEntityLiving();
                ItemStack stack = (ItemStack)((ImmutableTriple)CuriosApi.getCuriosHelper().findEquippedCurio((Item)ItemRegistry.REFLECTION_NECKLACE.get(), event.getEntityLiving()).get()).getRight();
                int charges = NBTUtils.getInt(stack, ReflectionNecklaceItem.TAG_CHARGE_AMOUNT, 0);
                if (charges > 0 && event.getSource().func_76346_g() instanceof LivingEntity) {
                    LivingEntity attacker = (LivingEntity)event.getSource().func_76346_g();
                    if (attacker == null) {
                        return;
                    }
                    if (player.func_213303_ch().func_72438_d(attacker.func_213303_ch()) < (double)config.minDistanceForKnockback) {
                        Vector3d motion = attacker.func_213303_ch().func_178788_d(player.func_213303_ch()).func_72432_b().func_216372_d(2.0, 1.5, 2.0);
                        if (attacker instanceof PlayerEntity) {
                            NetworkHandler.sendToClient(new PacketPlayerMotion(motion.field_72450_a, motion.field_72448_b, motion.field_72449_c), (ServerPlayerEntity)attacker);
                        } else {
                            attacker.func_213317_d(motion);
                        }
                        player.func_130014_f_().func_184148_a(null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), SoundEvents.field_187926_gz, SoundCategory.PLAYERS, 1.0f, 1.0f);
                        event.setCanceled(true);
                    }
                    if (attacker != player) {
                        NBTUtils.setInt(stack, ReflectionNecklaceItem.TAG_CHARGE_AMOUNT, charges - 1);
                        attacker.func_70097_a(DamageSource.func_76365_a((PlayerEntity)player), event.getAmount() * config.reflectedDamageMultiplier);
                    }
                }
            }
        }

        @SubscribeEvent
        public static void onProjectileImpact(ProjectileImpactEvent event) {
            ItemStack stack;
            if (!(event.getRayTraceResult() instanceof EntityRayTraceResult)) {
                return;
            }
            Entity undefinedProjectile = event.getEntity();
            Entity target = ((EntityRayTraceResult)event.getRayTraceResult()).func_216348_a();
            if (!(target instanceof PlayerEntity)) {
                return;
            }
            PlayerEntity player = (PlayerEntity)target;
            if (CuriosApi.getCuriosHelper().findEquippedCurio((Item)ItemRegistry.REFLECTION_NECKLACE.get(), (LivingEntity)player).isPresent() && NBTUtils.getInt(stack = (ItemStack)((ImmutableTriple)CuriosApi.getCuriosHelper().findEquippedCurio((Item)ItemRegistry.REFLECTION_NECKLACE.get(), (LivingEntity)player).get()).getRight(), ReflectionNecklaceItem.TAG_CHARGE_AMOUNT, 0) > 0) {
                undefinedProjectile.func_213317_d(undefinedProjectile.func_213322_ci().func_216371_e());
                if (undefinedProjectile instanceof DamagingProjectileEntity) {
                    DamagingProjectileEntity projectile = (DamagingProjectileEntity)undefinedProjectile;
                    projectile.func_212361_a((Entity)player);
                    projectile.field_70232_b *= -1.0;
                    projectile.field_70233_c *= -1.0;
                    projectile.field_70230_d *= -1.0;
                }
                event.setCanceled(true);
                undefinedProjectile.field_70133_I = true;
                NBTUtils.setInt(stack, ReflectionNecklaceItem.TAG_CHARGE_AMOUNT, NBTUtils.getInt(stack, ReflectionNecklaceItem.TAG_CHARGE_AMOUNT, 0) - 1);
                player.func_130014_f_().func_184148_a(null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), SoundEvents.field_187926_gz, SoundCategory.PLAYERS, 1.0f, 1.0f);
            }
        }
    }
}

