/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.items.relics;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import it.hurts.sskirillss.relics.configs.variables.stats.RelicStats;
import it.hurts.sskirillss.relics.init.ItemRegistry;
import it.hurts.sskirillss.relics.items.RelicItem;
import it.hurts.sskirillss.relics.items.relics.renderer.ScarabTalismanModel;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import it.hurts.sskirillss.relics.utils.RelicUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.block.Blocks;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.commons.lang3.tuple.MutablePair;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.capability.ICurio;
import top.theillusivec4.curios.api.type.capability.ICurioItem;

public class ScarabTalismanItem
extends RelicItem<Stats>
implements ICurioItem {
    private final MutablePair<String, UUID> SPEED_INFO = new MutablePair((Object)"relics:scarab_talisman_movement_speed", (Object)UUID.fromString("09bc5b60-3277-45ee-8bf0-aae7acba4385"));
    private final ResourceLocation TEXTURE = new ResourceLocation("relics", "textures/items/models/scarab_talisman.png");

    public ScarabTalismanItem() {
        super(Rarity.RARE);
    }

    @Override
    public List<ITextComponent> getShiftTooltip(ItemStack stack) {
        ArrayList tooltip = Lists.newArrayList();
        tooltip.add(new TranslationTextComponent("tooltip.relics.scarab_talisman.shift_1"));
        tooltip.add(new TranslationTextComponent("tooltip.relics.scarab_talisman.shift_2"));
        return tooltip;
    }

    public void curioTick(String identifier, int index, LivingEntity livingEntity, ItemStack stack) {
        ModifiableAttributeInstance movementSpeed = livingEntity.func_110148_a(Attributes.field_233821_d_);
        if (livingEntity.func_130014_f_().func_226691_t_(livingEntity.func_233580_cy_()).func_201856_r() == Biome.Category.DESERT || livingEntity.func_130014_f_().func_226691_t_(livingEntity.func_233580_cy_()).func_201856_r() == Biome.Category.MESA) {
            EntityUtils.applyAttributeModifier(movementSpeed, new AttributeModifier((UUID)this.SPEED_INFO.getRight(), (String)this.SPEED_INFO.getLeft(), (double)((Stats)this.config).speedModifier, AttributeModifier.Operation.MULTIPLY_TOTAL));
            livingEntity.field_70138_W = 1.1f;
        } else {
            EntityUtils.removeAttributeModifier(movementSpeed, new AttributeModifier((UUID)this.SPEED_INFO.getRight(), (String)this.SPEED_INFO.getLeft(), (double)((Stats)this.config).speedModifier, AttributeModifier.Operation.MULTIPLY_TOTAL));
            livingEntity.field_70138_W = 0.6f;
        }
    }

    public void onUnequip(String identifier, int index, LivingEntity livingEntity, ItemStack stack) {
        ModifiableAttributeInstance movementSpeed = livingEntity.func_110148_a(Attributes.field_233821_d_);
        EntityUtils.removeAttributeModifier(movementSpeed, new AttributeModifier((UUID)this.SPEED_INFO.getRight(), (String)this.SPEED_INFO.getLeft(), (double)((Stats)this.config).speedModifier, AttributeModifier.Operation.MULTIPLY_TOTAL));
        livingEntity.field_70138_W = 0.6f;
    }

    @Override
    public List<ResourceLocation> getLootChests() {
        return RelicUtils.Worldgen.DESERT;
    }

    @Override
    public Class<Stats> getConfigClass() {
        return Stats.class;
    }

    public void render(String identifier, int index, MatrixStack matrixStack, IRenderTypeBuffer renderTypeBuffer, int light, LivingEntity livingEntity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, ItemStack stack) {
        ScarabTalismanModel model = new ScarabTalismanModel();
        matrixStack.func_227860_a_();
        model.func_225597_a_(livingEntity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        model.func_212843_a_(livingEntity, limbSwing, limbSwingAmount, partialTicks);
        ICurio.RenderHelper.followBodyRotations((LivingEntity)livingEntity, (BipedModel[])new BipedModel[]{model});
        model.func_225598_a_(matrixStack, renderTypeBuffer.getBuffer(RenderType.func_228644_e_((ResourceLocation)this.TEXTURE)), light, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
        matrixStack.func_227865_b_();
    }

    public boolean canRender(String identifier, int index, LivingEntity livingEntity, ItemStack stack) {
        return true;
    }

    public static class Stats
    extends RelicStats {
        public float speedModifier = 1.5f;
    }

    @Mod.EventBusSubscriber(modid="relics")
    public static class ScarabTalismanServerEvents {
        @SubscribeEvent
        public static void onEntityHurt(LivingHurtEvent event) {
            if (event.getEntityLiving() instanceof PlayerEntity) {
                PlayerEntity player = (PlayerEntity)event.getEntityLiving();
                if (CuriosApi.getCuriosHelper().findEquippedCurio((Item)ItemRegistry.SCARAB_TALISMAN.get(), (LivingEntity)player).isPresent() && (event.getSource() == DamageSource.field_76368_d || event.getSource() == DamageSource.field_76379_h && player.func_130014_f_().func_180495_p(player.func_233580_cy_().func_177977_b()).func_177230_c() == Blocks.field_150354_m)) {
                    event.setCanceled(true);
                }
            }
        }

        @SubscribeEvent
        public static void onEntityAttack(LivingAttackEvent event) {
            if (event.getEntityLiving() instanceof PlayerEntity) {
                PlayerEntity player = (PlayerEntity)event.getEntityLiving();
                if (CuriosApi.getCuriosHelper().findEquippedCurio((Item)ItemRegistry.SCARAB_TALISMAN.get(), (LivingEntity)player).isPresent() && (event.getSource() == DamageSource.field_76368_d || event.getSource() == DamageSource.field_76379_h && player.func_130014_f_().func_180495_p(player.func_233580_cy_().func_177977_b()).func_177230_c() == Blocks.field_150354_m)) {
                    event.setCanceled(true);
                }
            }
        }

        @SubscribeEvent
        public static void onBlockBreakCalculate(PlayerEvent.BreakSpeed event) {
            PlayerEntity player;
            if (event.getEntityLiving() instanceof PlayerEntity && (player = (PlayerEntity)event.getEntityLiving()).func_130014_f_().func_180495_p(event.getPos()).func_177230_c() == Blocks.field_150354_m && CuriosApi.getCuriosHelper().findEquippedCurio((Item)ItemRegistry.SCARAB_TALISMAN.get(), (LivingEntity)player).isPresent()) {
                event.setNewSpeed(event.getNewSpeed() * 2.0f);
            }
        }
    }
}

