/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.items.relics;

import com.google.common.collect.Lists;
import it.hurts.sskirillss.relics.configs.variables.stats.RelicStats;
import it.hurts.sskirillss.relics.entities.ShadowGlaiveEntity;
import it.hurts.sskirillss.relics.init.ItemRegistry;
import it.hurts.sskirillss.relics.items.RelicItem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.loot.LootTables;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import top.theillusivec4.curios.api.SlotContext;

public class ShadowGlaiveItem
extends RelicItem<Stats> {
    public static ShadowGlaiveItem INSTANCE;

    public ShadowGlaiveItem() {
        super(Rarity.EPIC);
        INSTANCE = this;
    }

    @Override
    public List<ITextComponent> getShiftTooltip(ItemStack stack) {
        ArrayList tooltip = Lists.newArrayList();
        tooltip.add(new TranslationTextComponent("tooltip.relics.shadow_glaive.shift_1"));
        tooltip.add(new TranslationTextComponent("tooltip.relics.shadow_glaive.shift_2"));
        return tooltip;
    }

    @Override
    public boolean canEquipFromUse(SlotContext slotContext, ItemStack stack) {
        return false;
    }

    @Override
    public List<ResourceLocation> getLootChests() {
        return Collections.singletonList(LootTables.field_186421_c);
    }

    @Override
    public Class<Stats> getConfigClass() {
        return Stats.class;
    }

    public static class Stats
    extends RelicStats {
        public float summonChance = 0.35f;
        public float minDamageForSummon = 1.0f;
        public int maxDistanceForSummon = 5;
        public float initialDamageMultiplier = 1.25f;
        public int summonCooldown = 1;
        public float bounceChanceMultiplier = 0.025f;
        public int bounceRadius = 7;
        public float projectileSpeed = 0.45f;
        public int maxBounces = 10;
        public float minDamagePerBounce = 1.0f;
        public float damageMultiplierPerBounce = 0.05f;
    }

    @Mod.EventBusSubscriber(modid="relics")
    public static class ShadowGlaiveServerEvents {
        @SubscribeEvent
        public static void onEntityDamage(LivingDamageEvent event) {
            Stats config = (Stats)INSTANCE.config;
            if (!(event.getSource().func_76346_g() instanceof PlayerEntity)) {
                return;
            }
            PlayerEntity player = (PlayerEntity)event.getSource().func_76346_g();
            if (player.func_184592_cb().func_77973_b() != ItemRegistry.SHADOW_GLAIVE.get() || player.func_184811_cZ().func_185141_a((Item)ItemRegistry.SHADOW_GLAIVE.get())) {
                return;
            }
            World world = player.func_130014_f_();
            if (world.func_201674_k().nextFloat() > config.summonChance || event.getAmount() < config.minDamageForSummon) {
                return;
            }
            LivingEntity entity = event.getEntityLiving();
            if (entity == null || !entity.func_70089_S() || player.func_213303_ch().func_72438_d(entity.func_213303_ch()) > (double)config.maxDistanceForSummon) {
                return;
            }
            ShadowGlaiveEntity glaive = new ShadowGlaiveEntity(world, (LivingEntity)player);
            glaive.setDamage(event.getAmount() * config.initialDamageMultiplier);
            glaive.setOwner(player);
            glaive.setTarget(entity);
            glaive.func_70634_a(player.func_226277_ct_(), player.func_226278_cu_() + (double)(player.func_213302_cg() * 0.5f), player.func_226281_cx_());
            player.func_184811_cZ().func_185145_a((Item)ItemRegistry.SHADOW_GLAIVE.get(), config.summonCooldown * 20);
            world.func_217376_c((Entity)glaive);
        }
    }
}

