/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.items.relics;

import com.google.common.collect.Lists;
import it.hurts.sskirillss.relics.configs.variables.stats.RelicStats;
import it.hurts.sskirillss.relics.init.ItemRegistry;
import it.hurts.sskirillss.relics.items.RelicItem;
import it.hurts.sskirillss.relics.network.NetworkHandler;
import it.hurts.sskirillss.relics.network.PacketPlayerMotion;
import it.hurts.sskirillss.relics.particles.circle.CircleTintData;
import it.hurts.sskirillss.relics.utils.NBTUtils;
import it.hurts.sskirillss.relics.utils.ParticleUtils;
import it.hurts.sskirillss.relics.utils.RelicUtils;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.particles.IParticleData;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.Nullable;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.capability.ICurioItem;

public class SoulDevourerItem
extends RelicItem<Stats>
implements ICurioItem {
    private static final String TAG_UPDATE_TIME = "time";
    private static final String TAG_SOUL_AMOUNT = "soul";
    private static final String TAG_EXPLOSION_READINESS = "readiness";
    public static SoulDevourerItem INSTANCE;

    public SoulDevourerItem() {
        super(Rarity.EPIC);
        INSTANCE = this;
    }

    @Override
    public List<ITextComponent> getShiftTooltip(ItemStack stack) {
        ArrayList tooltip = Lists.newArrayList();
        tooltip.add(new TranslationTextComponent("tooltip.relics.soul_devourer.shift_1"));
        tooltip.add(new TranslationTextComponent("tooltip.relics.soul_devourer.shift_2"));
        return tooltip;
    }

    @Override
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.relics.soul_devourer.tooltip_1", new Object[]{NBTUtils.getInt(stack, TAG_SOUL_AMOUNT, 0)}));
    }

    public void curioTick(String identifier, int index, LivingEntity livingEntity, ItemStack stack) {
        if (!(livingEntity instanceof PlayerEntity)) {
            return;
        }
        int soul = NBTUtils.getInt(stack, TAG_SOUL_AMOUNT, 0);
        int time = NBTUtils.getInt(stack, TAG_UPDATE_TIME, 0);
        int readiness = NBTUtils.getInt(stack, TAG_EXPLOSION_READINESS, 0);
        PlayerEntity player = (PlayerEntity)livingEntity;
        if (player.field_70173_aa % 20 == 0 && soul > 0) {
            if (time < ((Stats)this.config).soulLooseCooldown * (player.func_225608_bj_() ? 2 : 1)) {
                NBTUtils.setInt(stack, TAG_UPDATE_TIME, time + 1);
            } else {
                NBTUtils.setInt(stack, TAG_UPDATE_TIME, 0);
                NBTUtils.setInt(stack, TAG_SOUL_AMOUNT, Math.round(Math.max((float)soul - ((float)soul * ((Stats)this.config).soulLoseMultiplierPerSoul + (float)((Stats)this.config).minSoulLooseAmount), 0.0f)));
            }
        }
        if (soul < ((Stats)this.config).soulForExplosion || player.func_184811_cZ().func_185141_a(stack.func_77973_b())) {
            return;
        }
        if (player.func_225608_bj_()) {
            if (readiness < ((Stats)this.config).explosionPreparation * 20) {
                NBTUtils.setInt(stack, TAG_EXPLOSION_READINESS, readiness + 1);
                float radius = (float)Math.sin((double)readiness * 0.1) + 1.0f + (float)readiness * 0.002f;
                for (int i = 0; i < 5; ++i) {
                    float angle = 0.0105f * (float)(readiness * 4 + i * 120);
                    double extraX = (double)(radius * MathHelper.func_76126_a((float)((float)(Math.PI + (double)angle)))) + player.func_226277_ct_();
                    double extraZ = (double)(radius * MathHelper.func_76134_b((float)angle)) + player.func_226281_cx_();
                    player.func_130014_f_().func_195594_a((IParticleData)new CircleTintData(new Color(180, 250, 255), 0.2f + (float)readiness * 0.004f, 40, 0.95f, false), extraX, player.func_226278_cu_() + 0.5, extraZ, 0.0, 0.0, 0.0);
                }
            } else {
                SoulDevourerItem.explode(player, stack, soul);
            }
        } else if (readiness != 0) {
            NBTUtils.setInt(stack, TAG_EXPLOSION_READINESS, 0);
        }
    }

    @Override
    public List<ResourceLocation> getLootChests() {
        return RelicUtils.Worldgen.NETHER;
    }

    @Override
    public Class<Stats> getConfigClass() {
        return Stats.class;
    }

    public static void explode(PlayerEntity player, ItemStack stack, int soul) {
        Stats config = (Stats)SoulDevourerItem.INSTANCE.config;
        for (LivingEntity entity : player.func_130014_f_().func_217357_a(LivingEntity.class, player.func_174813_aQ().func_186662_g((double)config.explosionRadius))) {
            if (entity == player) continue;
            double velocity = config.explosionKnockback;
            Vector3d motion = entity.func_213303_ch().func_72441_c(0.0, 1.0, 0.0).func_178788_d(player.func_213303_ch()).func_72432_b().func_216372_d(velocity, velocity, velocity);
            if (entity instanceof ServerPlayerEntity) {
                NetworkHandler.sendToClient(new PacketPlayerMotion(motion.field_72450_a, motion.field_72448_b, motion.field_72449_c), (ServerPlayerEntity)entity);
            } else {
                entity.func_213317_d(motion);
            }
            entity.func_70097_a(DamageSource.func_76365_a((PlayerEntity)player), (float)config.minExplosionDamage + (float)soul * config.explosionDamagePerSoul);
        }
        ParticleUtils.createBall(new CircleTintData(new Color(0.3f, 0.7f, 1.0f), 0.5f, 50, 0.95f, false), player.func_213303_ch(), player.func_130014_f_(), 4, 0.2f);
        player.func_184811_cZ().func_185145_a(stack.func_77973_b(), config.explosionCooldown * 20);
        NBTUtils.setInt(stack, TAG_SOUL_AMOUNT, 0);
        NBTUtils.setInt(stack, TAG_EXPLOSION_READINESS, 0);
    }

    public static class Stats
    extends RelicStats {
        public int soulLooseCooldown = 10;
        public int minSoulLooseAmount = 5;
        public float soulLoseMultiplierPerSoul = 0.1f;
        public int soulForExplosion = 50;
        public int explosionPreparation = 12;
        public int explosionRadius = 10;
        public float explosionKnockback = 5.0f;
        public int minExplosionDamage = 2;
        public float explosionDamagePerSoul = 0.75f;
        public int explosionCooldown = 60;
        public int soulCapacity = 100;
        public float soulFromHealthPercentage = 0.25f;
        public float playerDamageMultiplierPerSoul = 0.1f;
    }

    @Mod.EventBusSubscriber(modid="relics")
    public static class SoulDevourerServerEvents {
        @SubscribeEvent
        public static void onEntityDeath(LivingDeathEvent event) {
            Stats config = (Stats)INSTANCE.config;
            if (!(event.getSource().func_76346_g() instanceof PlayerEntity)) {
                return;
            }
            PlayerEntity player = (PlayerEntity)event.getSource().func_76346_g();
            LivingEntity target = event.getEntityLiving();
            CuriosApi.getCuriosHelper().findEquippedCurio((Item)ItemRegistry.SOUL_DEVOURER.get(), (LivingEntity)player).ifPresent(triple -> {
                ItemStack stack = (ItemStack)triple.getRight();
                int soul = NBTUtils.getInt(stack, SoulDevourerItem.TAG_SOUL_AMOUNT, 0);
                int capacity = config.soulCapacity;
                if (player.func_184811_cZ().func_185141_a(stack.func_77973_b()) || soul >= capacity) {
                    return;
                }
                NBTUtils.setInt(stack, SoulDevourerItem.TAG_SOUL_AMOUNT, Math.min(soul + Math.round(target.func_110138_aP() * config.soulFromHealthPercentage), capacity));
                NBTUtils.setInt(stack, SoulDevourerItem.TAG_UPDATE_TIME, 0);
            });
        }

        @SubscribeEvent
        public static void onEntityHurt(LivingHurtEvent event) {
            Stats config = (Stats)INSTANCE.config;
            if (!(event.getSource().func_76346_g() instanceof PlayerEntity)) {
                return;
            }
            PlayerEntity player = (PlayerEntity)event.getSource().func_76346_g();
            CuriosApi.getCuriosHelper().findEquippedCurio((Item)ItemRegistry.SOUL_DEVOURER.get(), (LivingEntity)player).ifPresent(triple -> {
                int soul = NBTUtils.getInt((ItemStack)triple.getRight(), SoulDevourerItem.TAG_SOUL_AMOUNT, 0);
                if (soul > 0) {
                    event.setAmount(event.getAmount() + (float)soul * config.playerDamageMultiplierPerSoul);
                }
            });
        }
    }
}

