/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.items.relics;

import com.google.common.collect.Lists;
import it.hurts.sskirillss.relics.configs.variables.stats.RelicStats;
import it.hurts.sskirillss.relics.entities.SpaceDissectorEntity;
import it.hurts.sskirillss.relics.items.RelicItem;
import it.hurts.sskirillss.relics.utils.NBTUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.loot.LootTables;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import top.theillusivec4.curios.api.SlotContext;

public class SpaceDissectorItem
extends RelicItem<Stats> {
    public static final String TAG_IS_THROWN = "thrown";
    public static final String TAG_UUID = "uuid";
    public static final String TAG_UPDATE_TIME = "time";
    public static SpaceDissectorItem INSTANCE;

    public SpaceDissectorItem() {
        super(Rarity.EPIC);
        INSTANCE = this;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        ItemStack stack = playerIn.func_184614_ca();
        if (handIn == Hand.MAIN_HAND && !playerIn.func_184811_cZ().func_185141_a(stack.func_77973_b())) {
            if (!NBTUtils.getBoolean(stack, TAG_IS_THROWN, false)) {
                SpaceDissectorEntity entity = new SpaceDissectorEntity(worldIn, (LivingEntity)playerIn);
                entity.func_234612_a_((Entity)playerIn, playerIn.field_70125_A, playerIn.field_70177_z, 1.0f, ((Stats)this.config).projectileSpeed, 0.0f);
                NBTUtils.setBoolean(stack, TAG_IS_THROWN, true);
                NBTUtils.setString(stack, TAG_UUID, entity.func_110124_au().toString());
                NBTUtils.setInt(stack, TAG_UPDATE_TIME, 0);
                entity.stack = playerIn.func_184614_ca();
                entity.setOwner(playerIn);
                worldIn.func_217376_c((Entity)entity);
            } else if (!NBTUtils.getString(stack, TAG_UUID, "").equals("")) {
                UUID uuid = UUID.fromString(NBTUtils.getString(stack, TAG_UUID, ""));
                if (worldIn instanceof ServerWorld) {
                    if (((ServerWorld)worldIn).func_217461_a(uuid) != null) {
                        if (((ServerWorld)worldIn).func_217461_a(uuid) instanceof SpaceDissectorEntity) {
                            SpaceDissectorEntity dissector = (SpaceDissectorEntity)((ServerWorld)worldIn).func_217461_a(uuid);
                            if (!playerIn.func_225608_bj_()) {
                                if (!((Boolean)dissector.func_184212_Q().func_187225_a(SpaceDissectorEntity.IS_RETURNING)).booleanValue()) {
                                    dissector.func_184212_Q().func_187227_b(SpaceDissectorEntity.IS_RETURNING, (Object)true);
                                }
                            } else if (playerIn.func_213303_ch().func_72438_d(dissector.func_213303_ch()) > (double)((Stats)this.config).distanceForTeleport) {
                                playerIn.func_70634_a(dissector.func_226277_ct_(), dissector.func_226278_cu_(), dissector.func_226281_cx_());
                                worldIn.func_184148_a(null, playerIn.func_226277_ct_(), playerIn.func_226278_cu_(), playerIn.func_226281_cx_(), SoundEvents.field_187534_aX, SoundCategory.PLAYERS, 1.0f, 1.0f);
                                dissector.func_70106_y();
                                playerIn.func_184811_cZ().func_185145_a(stack.func_77973_b(), ((Stats)this.config).cooldownAfterTeleport * 20);
                                NBTUtils.setBoolean(stack, TAG_IS_THROWN, false);
                            }
                        }
                    } else {
                        playerIn.func_184811_cZ().func_185145_a(stack.func_77973_b(), ((Stats)this.config).cooldownAfterTeleport * 20);
                        NBTUtils.setBoolean(stack, TAG_IS_THROWN, false);
                    }
                }
            }
        }
        return super.func_77659_a(worldIn, playerIn, handIn);
    }

    @Override
    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (entityIn.field_70173_aa % 20 == 0 && NBTUtils.getBoolean(stack, TAG_IS_THROWN, false)) {
            NBTUtils.setInt(stack, TAG_UPDATE_TIME, NBTUtils.getInt(stack, TAG_UPDATE_TIME, 0) + 1);
            if (NBTUtils.getInt(stack, TAG_UPDATE_TIME, 0) > ((Stats)this.config).maxThrownTime) {
                NBTUtils.setBoolean(stack, TAG_IS_THROWN, false);
            }
        }
        super.func_77663_a(stack, worldIn, entityIn, itemSlot, isSelected);
    }

    @Override
    public List<ITextComponent> getShiftTooltip(ItemStack stack) {
        ArrayList tooltip = Lists.newArrayList();
        tooltip.add(new TranslationTextComponent("tooltip.relics.space_dissector.shift_1"));
        tooltip.add(new TranslationTextComponent("tooltip.relics.space_dissector.shift_2"));
        tooltip.add(new TranslationTextComponent("tooltip.relics.space_dissector.shift_3"));
        return tooltip;
    }

    @Override
    public boolean canEquipFromUse(SlotContext slotContext, ItemStack stack) {
        return false;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged;
    }

    @Override
    public List<ResourceLocation> getLootChests() {
        return Collections.singletonList(LootTables.field_186421_c);
    }

    @Override
    public Class<Stats> getConfigClass() {
        return Stats.class;
    }

    public static class Stats
    extends RelicStats {
        public float projectileSpeed = 0.75f;
        public int maxThrownTime = 60;
        public int timeBeforeReturn = 10;
        public int distanceForTeleport = 5;
        public int cooldownAfterTeleport = 30;
        public int cooldownAfterReturn = 5;
        public int maxBounces = 10;
        public int additionalTimeAfterBounce = 4;
        public int baseDamage = 4;
        public float damageMultiplierPerBounce = 2.0f;
    }
}

