/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.items.relics;

import com.google.common.collect.Lists;
import it.hurts.sskirillss.relics.configs.variables.stats.RelicStats;
import it.hurts.sskirillss.relics.init.ItemRegistry;
import it.hurts.sskirillss.relics.items.RelicItem;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import it.hurts.sskirillss.relics.utils.NBTUtils;
import it.hurts.sskirillss.relics.utils.RelicUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.Nullable;
import top.theillusivec4.curios.api.SlotContext;

public class SpatialSignItem
extends RelicItem<Stats> {
    public static final String TAG_POSITION = "pos";
    public static final String TAG_TIME = "time";
    public static final String TAG_WORLD = "world";
    public static SpatialSignItem INSTANCE;

    public SpatialSignItem() {
        super(Rarity.RARE);
        INSTANCE = this;
    }

    @Override
    public List<ITextComponent> getShiftTooltip(ItemStack stack) {
        ArrayList tooltip = Lists.newArrayList();
        tooltip.add(new TranslationTextComponent("tooltip.relics.spatial_sign.shift_1"));
        tooltip.add(new TranslationTextComponent("tooltip.relics.spatial_sign.shift_2"));
        return tooltip;
    }

    @Override
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        if (!NBTUtils.getString(stack, TAG_POSITION, "").equals("")) {
            Vector3d pos = NBTUtils.parsePosition(NBTUtils.getString(stack, TAG_POSITION, ""));
            tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.relics.spatial_sign.tooltip_1", new Object[]{pos.func_82615_a(), pos.func_82617_b(), pos.func_82616_c()}));
            tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.relics.spatial_sign.tooltip_2", new Object[]{NBTUtils.getInt(stack, TAG_TIME, 0)}));
        }
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        if (NBTUtils.getString(stack, TAG_POSITION, "").equals("")) {
            NBTUtils.setString(stack, TAG_POSITION, NBTUtils.writePosition(playerIn.func_213303_ch()));
            NBTUtils.setString(stack, TAG_WORLD, playerIn.func_130014_f_().func_234923_W_().func_240901_a_().toString());
            NBTUtils.setInt(stack, TAG_TIME, ((Stats)this.config).timeBeforeActivation);
            worldIn.func_184133_a(playerIn, playerIn.func_233580_cy_(), SoundEvents.field_187604_bf, SoundCategory.PLAYERS, 1.0f, 1.0f);
        } else if (playerIn.func_225608_bj_()) {
            SpatialSignItem.teleportPlayer(playerIn, stack);
        }
        return super.func_77659_a(worldIn, playerIn, handIn);
    }

    @Override
    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (worldIn.func_201670_d()) {
            return;
        }
        if (!(entityIn instanceof PlayerEntity)) {
            return;
        }
        PlayerEntity player = (PlayerEntity)entityIn;
        if (player.field_70173_aa % 20 == 0 && NBTUtils.getInt(stack, TAG_TIME, -1) >= 0) {
            int time = NBTUtils.getInt(stack, TAG_TIME, -1);
            if (time > 0) {
                NBTUtils.setInt(stack, TAG_TIME, time - 1);
            } else {
                SpatialSignItem.teleportPlayer(player, stack);
            }
        }
        super.func_77663_a(stack, worldIn, entityIn, itemSlot, isSelected);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged;
    }

    public boolean func_77636_d(ItemStack stack) {
        return NBTUtils.getInt(stack, TAG_TIME, 0) > 0;
    }

    public static void teleportPlayer(PlayerEntity player, ItemStack stack) {
        Stats config = (Stats)SpatialSignItem.INSTANCE.config;
        if (player.func_130014_f_().func_201670_d()) {
            return;
        }
        Vector3d pos = NBTUtils.parsePosition(NBTUtils.getString(stack, TAG_POSITION, ""));
        ServerWorld world = NBTUtils.parseWorld(player.func_130014_f_(), NBTUtils.getString(stack, TAG_WORLD, ""));
        if (pos == null || world == null) {
            return;
        }
        ((ServerPlayerEntity)player).func_200619_a(world, pos.func_82615_a(), pos.func_82617_b(), pos.func_82616_c(), player.field_70177_z, player.field_70125_A);
        player.func_130014_f_().func_184148_a(player, pos.func_82615_a(), pos.func_82617_b(), pos.func_82616_c(), SoundEvents.field_187534_aX, SoundCategory.PLAYERS, 1.0f, 1.0f);
        if (!player.field_71075_bZ.field_75098_d) {
            player.func_184811_cZ().func_185145_a(stack.func_77973_b(), (config.timeBeforeActivation - NBTUtils.getInt(stack, TAG_TIME, 0)) * 20);
        }
        NBTUtils.setString(stack, TAG_WORLD, "");
        NBTUtils.setString(stack, TAG_POSITION, "");
        NBTUtils.setInt(stack, TAG_TIME, -1);
    }

    @Override
    public boolean canEquipFromUse(SlotContext slotContext, ItemStack stack) {
        return false;
    }

    @Override
    public List<ResourceLocation> getLootChests() {
        return RelicUtils.Worldgen.CAVE;
    }

    @Override
    public Class<Stats> getConfigClass() {
        return Stats.class;
    }

    public static class Stats
    extends RelicStats {
        public int timeBeforeActivation = 30;
    }

    @Mod.EventBusSubscriber(modid="relics")
    public static class SpatialSignServerEvents {
        @SubscribeEvent
        public static void onEntityDeath(LivingDeathEvent event) {
            if (!(event.getEntity() instanceof PlayerEntity)) {
                return;
            }
            PlayerEntity player = (PlayerEntity)event.getEntity();
            if (EntityUtils.getSlotWithItem(player, (Item)ItemRegistry.SPATIAL_SIGN.get()) == -1) {
                return;
            }
            ItemStack stack = player.field_71071_by.func_70301_a(EntityUtils.getSlotWithItem(player, (Item)ItemRegistry.SPATIAL_SIGN.get()));
            if (!NBTUtils.getString(stack, SpatialSignItem.TAG_POSITION, "").equals("")) {
                SpatialSignItem.teleportPlayer(player, stack);
                player.func_70606_j(1.0f);
                stack.func_190918_g(1);
                event.setCanceled(true);
            }
        }
    }
}

