/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.items.relics;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import it.hurts.sskirillss.relics.configs.variables.stats.RelicStats;
import it.hurts.sskirillss.relics.init.ItemRegistry;
import it.hurts.sskirillss.relics.items.RelicItem;
import it.hurts.sskirillss.relics.items.relics.renderer.SporeSackModel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.ProjectileEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.loot.LootTables;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.RedstoneParticleData;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.capability.ICurio;
import top.theillusivec4.curios.api.type.capability.ICurioItem;

public class SporeSackItem
extends RelicItem<Stats>
implements ICurioItem {
    public static SporeSackItem INSTANCE;
    private final ResourceLocation TEXTURE = new ResourceLocation("relics", "textures/items/models/spore_sack.png");

    public SporeSackItem() {
        super(Rarity.UNCOMMON);
        INSTANCE = this;
    }

    @Override
    public List<ITextComponent> getShiftTooltip(ItemStack stack) {
        ArrayList tooltip = Lists.newArrayList();
        tooltip.add(new TranslationTextComponent("tooltip.relics.spore_sack.shift_1"));
        return tooltip;
    }

    @Override
    public List<ResourceLocation> getLootChests() {
        return Collections.singletonList(LootTables.field_186430_l);
    }

    @Override
    public Class<Stats> getConfigClass() {
        return Stats.class;
    }

    public void render(String identifier, int index, MatrixStack matrixStack, IRenderTypeBuffer renderTypeBuffer, int light, LivingEntity livingEntity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, ItemStack stack) {
        SporeSackModel model = new SporeSackModel();
        matrixStack.func_227860_a_();
        model.func_225597_a_(livingEntity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        model.func_212843_a_(livingEntity, limbSwing, limbSwingAmount, partialTicks);
        ICurio.RenderHelper.followBodyRotations((LivingEntity)livingEntity, (BipedModel[])new BipedModel[]{model});
        model.func_225598_a_(matrixStack, renderTypeBuffer.getBuffer(RenderType.func_228638_b_((ResourceLocation)this.TEXTURE)), light, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
        matrixStack.func_227865_b_();
    }

    public boolean canRender(String identifier, int index, LivingEntity livingEntity, ItemStack stack) {
        return true;
    }

    public static class Stats
    extends RelicStats {
        public float chance = 0.3f;
        public int radius = 3;
        public int cooldown = 5;
        public int poisonAmplifier = 2;
        public int poisonDuration = 5;
        public int slownessAmplifier = 0;
        public int slownessDuration = 5;
    }

    @Mod.EventBusSubscriber(modid="relics")
    public static class SporeSackEvents {
        @SubscribeEvent
        public static void onProjectileImpact(ProjectileImpactEvent event) {
            Stats config = (Stats)INSTANCE.config;
            if (!(event.getEntity() instanceof ProjectileEntity)) {
                return;
            }
            ProjectileEntity projectile = (ProjectileEntity)event.getEntity();
            if (projectile.func_234616_v_() == null || !(projectile.func_234616_v_() instanceof PlayerEntity)) {
                return;
            }
            PlayerEntity player = (PlayerEntity)projectile.func_234616_v_();
            World world = projectile.func_130014_f_();
            if (world.func_201670_d()) {
                return;
            }
            if (!CuriosApi.getCuriosHelper().findEquippedCurio((Item)ItemRegistry.SPORE_SACK.get(), (LivingEntity)player).isPresent() || player.func_184811_cZ().func_185141_a((Item)ItemRegistry.SPORE_SACK.get()) || world.func_201674_k().nextFloat() > config.chance) {
                return;
            }
            ((ServerWorld)world).func_195598_a((IParticleData)new RedstoneParticleData(0.0f, 255.0f, 0.0f, 1.0f), projectile.func_226277_ct_(), projectile.func_226278_cu_(), projectile.func_226281_cx_(), 100, 1.0, 1.0, 1.0, 0.5);
            world.func_184133_a(null, projectile.func_233580_cy_(), SoundEvents.field_187646_bt, SoundCategory.PLAYERS, 1.0f, 0.5f);
            player.func_184811_cZ().func_185145_a((Item)ItemRegistry.SPORE_SACK.get(), config.cooldown * 20);
            for (LivingEntity entity : world.func_217357_a(LivingEntity.class, projectile.func_174813_aQ().func_186662_g((double)config.radius))) {
                if (entity == player) continue;
                entity.func_195064_c(new EffectInstance(Effects.field_76436_u, config.poisonDuration * 20, config.poisonAmplifier));
                entity.func_195064_c(new EffectInstance(Effects.field_76421_d, config.slownessDuration * 20, config.slownessAmplifier));
            }
        }
    }
}

