/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.items.relics;

import com.google.common.collect.Lists;
import it.hurts.sskirillss.relics.configs.variables.stats.RelicStats;
import it.hurts.sskirillss.relics.entities.StellarCatalystProjectileEntity;
import it.hurts.sskirillss.relics.init.ItemRegistry;
import it.hurts.sskirillss.relics.items.RelicItem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.loot.LootTables;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.capability.ICurioItem;

public class StellarCatalystItem
extends RelicItem<Stats>
implements ICurioItem {
    public static StellarCatalystItem INSTANCE;

    public StellarCatalystItem() {
        super(Rarity.EPIC);
        INSTANCE = this;
    }

    @Override
    public List<ITextComponent> getShiftTooltip(ItemStack stack) {
        ArrayList tooltip = Lists.newArrayList();
        tooltip.add(new TranslationTextComponent("tooltip.relics.stellar_catalyst.shift_1"));
        return tooltip;
    }

    @Override
    public List<ResourceLocation> getLootChests() {
        return Collections.singletonList(LootTables.field_186421_c);
    }

    @Override
    public Class<Stats> getConfigClass() {
        return Stats.class;
    }

    public static class Stats
    extends RelicStats {
        public float chance = 0.15f;
        public float damageMultiplier = 0.75f;
        public int additionalSummonHeight = 20;
        public int minSummonHeight = 20;
        public int explosionRadius = 3;
        public float knockbackPower = 1.0f;
        public int minDamage = 3;
        public float projectileSpeed = 0.7f;
    }

    @Mod.EventBusSubscriber(modid="relics")
    public static class MoonlightWellServerEvents {
        @SubscribeEvent
        public static void onEntityDamage(LivingHurtEvent event) {
            Stats config = (Stats)INSTANCE.config;
            if (!(event.getSource().func_76346_g() instanceof PlayerEntity)) {
                return;
            }
            PlayerEntity player = (PlayerEntity)event.getSource().func_76346_g();
            if (!CuriosApi.getCuriosHelper().findEquippedCurio((Item)ItemRegistry.STELLAR_CATALYST.get(), (LivingEntity)player).isPresent()) {
                return;
            }
            LivingEntity target = event.getEntityLiving();
            if (event.getAmount() > (float)config.minDamage && (target.func_130014_f_().func_226690_K_() || target.func_130014_f_().func_234923_W_() == World.field_234920_i_) && target.func_130014_f_().func_226660_f_(target.func_233580_cy_()) && field_77697_d.nextFloat() <= config.chance) {
                StellarCatalystProjectileEntity projectile = new StellarCatalystProjectileEntity((LivingEntity)event.getSource().func_76346_g(), event.getEntityLiving(), event.getAmount() * config.damageMultiplier);
                projectile.func_70107_b(target.func_226277_ct_(), Math.min((double)target.func_130014_f_().func_217301_I(), Math.min((double)target.func_130014_f_().func_217301_I(), target.func_226278_cu_() + (double)target.func_130014_f_().func_201674_k().nextInt(config.additionalSummonHeight) + (double)config.minSummonHeight)), target.func_226281_cx_());
                projectile.owner = player;
                projectile.func_130014_f_().func_217376_c((Entity)projectile);
            }
        }
    }
}

