/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.items.relics.boots;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import it.hurts.sskirillss.relics.configs.variables.stats.RelicStats;
import it.hurts.sskirillss.relics.items.RelicItem;
import it.hurts.sskirillss.relics.items.relics.renderer.AmphibianBootModel;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import it.hurts.sskirillss.relics.utils.RelicUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.ForgeMod;
import org.apache.commons.lang3.tuple.MutablePair;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurio;
import top.theillusivec4.curios.api.type.capability.ICurioItem;

public class AmphibianBootItem
extends RelicItem<Stats>
implements ICurioItem {
    private final MutablePair<String, UUID> SWIM_SPEED_INFO = new MutablePair((Object)"relics:amphibian_boot_swim_speed", (Object)UUID.fromString("c12bcc95-aa73-48b7-9ff8-e8c70d713b43"));
    private final ResourceLocation TEXTURE = new ResourceLocation("relics", "textures/items/models/amphibian_boot.png");

    public AmphibianBootItem() {
        super(Rarity.UNCOMMON);
    }

    @Override
    public List<ITextComponent> getShiftTooltip(ItemStack stack) {
        ArrayList tooltip = Lists.newArrayList();
        tooltip.add(new TranslationTextComponent("tooltip.relics.amphibian_boot.shift_1"));
        return tooltip;
    }

    public void curioTick(String identifier, int index, LivingEntity livingEntity, ItemStack stack) {
        ModifiableAttributeInstance swimSpeed = livingEntity.func_110148_a((Attribute)ForgeMod.SWIM_SPEED.get());
        AttributeModifier modifier = new AttributeModifier((UUID)this.SWIM_SPEED_INFO.getRight(), (String)this.SWIM_SPEED_INFO.getLeft(), (double)((Stats)this.config).swimSpeedModifier, AttributeModifier.Operation.MULTIPLY_TOTAL);
        if (!(livingEntity instanceof PlayerEntity)) {
            return;
        }
        PlayerEntity player = (PlayerEntity)livingEntity;
        if (!player.func_70090_H() || !player.func_233570_aj_()) {
            EntityUtils.removeAttributeModifier(swimSpeed, modifier);
            return;
        }
        EntityUtils.applyAttributeModifier(swimSpeed, modifier);
    }

    public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        EntityUtils.removeAttributeModifier(slotContext.getWearer().func_110148_a((Attribute)ForgeMod.SWIM_SPEED.get()), new AttributeModifier((UUID)this.SWIM_SPEED_INFO.getRight(), (String)this.SWIM_SPEED_INFO.getLeft(), (double)((Stats)this.config).swimSpeedModifier, AttributeModifier.Operation.MULTIPLY_TOTAL));
    }

    @Override
    public List<ResourceLocation> getLootChests() {
        return RelicUtils.Worldgen.AQUATIC;
    }

    @Override
    public Class<Stats> getConfigClass() {
        return Stats.class;
    }

    public void render(String identifier, int index, MatrixStack matrixStack, IRenderTypeBuffer renderTypeBuffer, int light, LivingEntity livingEntity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, ItemStack stack) {
        AmphibianBootModel model = new AmphibianBootModel();
        matrixStack.func_227860_a_();
        matrixStack.func_227862_a_(1.025f, 1.025f, 1.025f);
        model.func_225597_a_(livingEntity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        model.func_212843_a_(livingEntity, limbSwing, limbSwingAmount, partialTicks);
        ICurio.RenderHelper.followBodyRotations((LivingEntity)livingEntity, (BipedModel[])new BipedModel[]{model});
        model.func_225598_a_(matrixStack, renderTypeBuffer.getBuffer(RenderType.func_228644_e_((ResourceLocation)this.TEXTURE)), light, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
        matrixStack.func_227865_b_();
    }

    public boolean canRender(String identifier, int index, LivingEntity livingEntity, ItemStack stack) {
        return true;
    }

    public static class Stats
    extends RelicStats {
        public float swimSpeedModifier = 1.5f;
    }
}

