/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.items.relics.boots;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import it.hurts.sskirillss.relics.configs.variables.stats.RelicStats;
import it.hurts.sskirillss.relics.init.ItemRegistry;
import it.hurts.sskirillss.relics.items.RelicItem;
import it.hurts.sskirillss.relics.items.relics.renderer.IceBreakerModel;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import it.hurts.sskirillss.relics.utils.RelicUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.commons.lang3.tuple.MutablePair;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurio;
import top.theillusivec4.curios.api.type.capability.ICurioItem;

public class IceBreakerItem
extends RelicItem<Stats>
implements ICurioItem {
    private final MutablePair<String, UUID> SPEED_INFO = new MutablePair((Object)"relics:ice_breaker_movement_speed", (Object)UUID.fromString("90af8e8a-93aa-4b0f-8ddc-8986dd2a8461"));
    private final MutablePair<String, UUID> KNOCKBACK_INFO = new MutablePair((Object)"relics:ice_breaker_knockback resistance", (Object)UUID.fromString("70c6b1a0-e025-44bf-8dcd-c165c59b7eb4"));
    public static IceBreakerItem INSTANCE;
    private final ResourceLocation TEXTURE = new ResourceLocation("relics", "textures/items/models/ice_breaker.png");

    public IceBreakerItem() {
        super(Rarity.RARE);
        INSTANCE = this;
    }

    @Override
    public List<ITextComponent> getShiftTooltip(ItemStack stack) {
        ArrayList tooltip = Lists.newArrayList();
        tooltip.add(new TranslationTextComponent("tooltip.relics.ice_breaker.shift_1"));
        tooltip.add(new TranslationTextComponent("tooltip.relics.ice_breaker.shift_2"));
        return tooltip;
    }

    public void curioTick(String identifier, int index, LivingEntity livingEntity, ItemStack stack) {
        if (livingEntity instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)livingEntity;
            Vector3d motion = player.func_213322_ci();
            EntityUtils.applyAttributeModifier(player.func_110148_a(Attributes.field_233821_d_), new AttributeModifier((UUID)this.SPEED_INFO.getRight(), (String)this.SPEED_INFO.getLeft(), (double)((Stats)this.config).speedModifier, AttributeModifier.Operation.MULTIPLY_TOTAL));
            EntityUtils.applyAttributeModifier(player.func_110148_a(Attributes.field_233820_c_), new AttributeModifier((UUID)this.KNOCKBACK_INFO.getRight(), (String)this.KNOCKBACK_INFO.getLeft(), (double)((Stats)this.config).knockbackResistanceModifier, AttributeModifier.Operation.ADDITION));
            if (player.field_70143_R >= (float)((Stats)this.config).minFallDistance && player.func_225608_bj_()) {
                player.func_213293_j(motion.func_82615_a(), motion.func_82617_b() * (double)((Stats)this.config).fallMotionMultiplier, motion.func_82616_c());
            }
            if (player.field_70123_F && player.func_225608_bj_()) {
                player.func_213293_j(0.0, (double)(-((Stats)this.config).wallSlippingSpeed), 0.0);
                player.field_70143_R = 0.0f;
                player.func_130014_f_().func_195594_a((IParticleData)ParticleTypes.field_197614_g, player.func_226277_ct_(), player.func_226278_cu_() - 0.15, player.func_226281_cx_(), 0.0, 0.0, 0.0);
            }
        }
    }

    public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        EntityUtils.removeAttributeModifier(slotContext.getWearer().func_110148_a(Attributes.field_233821_d_), new AttributeModifier((UUID)this.SPEED_INFO.getRight(), (String)this.SPEED_INFO.getLeft(), (double)((Stats)this.config).speedModifier, AttributeModifier.Operation.MULTIPLY_TOTAL));
        EntityUtils.removeAttributeModifier(slotContext.getWearer().func_110148_a(Attributes.field_233820_c_), new AttributeModifier((UUID)this.KNOCKBACK_INFO.getRight(), (String)this.KNOCKBACK_INFO.getLeft(), (double)((Stats)this.config).knockbackResistanceModifier, AttributeModifier.Operation.ADDITION));
    }

    @Override
    public List<ResourceLocation> getLootChests() {
        return RelicUtils.Worldgen.COLD;
    }

    @Override
    public Class<Stats> getConfigClass() {
        return Stats.class;
    }

    public void render(String identifier, int index, MatrixStack matrixStack, IRenderTypeBuffer renderTypeBuffer, int light, LivingEntity livingEntity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, ItemStack stack) {
        IceBreakerModel model = new IceBreakerModel();
        matrixStack.func_227860_a_();
        matrixStack.func_227862_a_(1.025f, 1.025f, 1.025f);
        model.func_225597_a_(livingEntity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        model.func_212843_a_(livingEntity, limbSwing, limbSwingAmount, partialTicks);
        ICurio.RenderHelper.followBodyRotations((LivingEntity)livingEntity, (BipedModel[])new BipedModel[]{model});
        model.func_225598_a_(matrixStack, renderTypeBuffer.getBuffer(RenderType.func_228644_e_((ResourceLocation)this.TEXTURE)), light, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
        matrixStack.func_227865_b_();
    }

    public boolean canRender(String identifier, int index, LivingEntity livingEntity, ItemStack stack) {
        return true;
    }

    public static class Stats
    extends RelicStats {
        public float speedModifier = -0.1f;
        public float knockbackResistanceModifier = 0.5f;
        public int minFallDistance = 3;
        public float fallMotionMultiplier = 1.075f;
        public float wallSlippingSpeed = 0.1f;
        public float stompCooldownMultiplier = 3.0f;
        public float stompRadiusMultiplier = 0.5f;
        public float stompMotionMultiplier = 1.01f;
        public float dealtDamageMultiplier = 1.0f;
        public int maxDealtDamage = 100;
        public float incomingFallDamageMultiplier = 0.0f;
    }

    @Mod.EventBusSubscriber(modid="relics")
    public static class IceBreakerServerEvents {
        @SubscribeEvent
        public static void onEntityFall(LivingFallEvent event) {
            Stats config = (Stats)INSTANCE.config;
            if (event.getEntityLiving() instanceof PlayerEntity) {
                PlayerEntity player = (PlayerEntity)event.getEntityLiving();
                if (CuriosApi.getCuriosHelper().findEquippedCurio((Item)ItemRegistry.ICE_BREAKER.get(), (LivingEntity)player).isPresent() && !player.func_184811_cZ().func_185141_a((Item)ItemRegistry.ICE_BREAKER.get()) && event.getDistance() >= (float)config.minFallDistance && player.func_225608_bj_()) {
                    player.func_130014_f_().func_184133_a(null, player.func_233580_cy_(), SoundEvents.field_187926_gz, SoundCategory.PLAYERS, 0.75f, 1.0f);
                    player.func_184811_cZ().func_185145_a((Item)ItemRegistry.ICE_BREAKER.get(), Math.round(event.getDistance() * config.stompCooldownMultiplier * 20.0f));
                    for (LivingEntity entity : player.func_130014_f_().func_217357_a(LivingEntity.class, player.func_174813_aQ().func_186662_g((double)(event.getDistance() * config.stompRadiusMultiplier)))) {
                        if (entity == player) continue;
                        entity.func_70097_a(DamageSource.func_76365_a((PlayerEntity)player), Math.min((float)config.maxDealtDamage, event.getDistance() * config.dealtDamageMultiplier));
                        entity.func_213317_d(entity.func_213303_ch().func_178788_d(player.func_213303_ch()).func_72441_c(0.0, (double)1.005f, 0.0).func_216372_d((double)config.stompMotionMultiplier, (double)config.stompMotionMultiplier, (double)config.stompMotionMultiplier));
                    }
                    if (player.func_130014_f_().func_180495_p(player.func_233580_cy_().func_177977_b()).func_235714_a_((ITag)BlockTags.field_205213_E)) {
                        player.func_130014_f_().func_225521_a_(player.func_233580_cy_().func_177977_b(), false, (Entity)player);
                    }
                    event.setDamageMultiplier(config.incomingFallDamageMultiplier);
                }
            }
        }
    }
}

