/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.items.relics.boots;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import it.hurts.sskirillss.relics.configs.variables.stats.RelicStats;
import it.hurts.sskirillss.relics.init.ItemRegistry;
import it.hurts.sskirillss.relics.items.RelicItem;
import it.hurts.sskirillss.relics.items.relics.renderer.IceSkatesModel;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import it.hurts.sskirillss.relics.utils.NBTUtils;
import it.hurts.sskirillss.relics.utils.RelicUtils;
import it.hurts.sskirillss.relics.utils.WorldUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.block.Blocks;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.commons.lang3.tuple.MutablePair;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.capability.ICurio;
import top.theillusivec4.curios.api.type.capability.ICurioItem;

public class IceSkatesItem
extends RelicItem<Stats>
implements ICurioItem {
    private final MutablePair<String, UUID> SPEED_INFO = new MutablePair((Object)"relics:ice_skates_movement_speed", (Object)UUID.fromString("c0f5890f-a878-49bb-b24c-bbbf60d8539b"));
    public static final String TAG_SPEEDUP_TIME = "time";
    public static IceSkatesItem INSTANCE;
    private final ResourceLocation TEXTURE = new ResourceLocation("relics", "textures/items/models/ice_skates.png");

    public IceSkatesItem() {
        super(Rarity.UNCOMMON);
        INSTANCE = this;
    }

    @Override
    public List<ITextComponent> getShiftTooltip(ItemStack stack) {
        ArrayList tooltip = Lists.newArrayList();
        tooltip.add(new TranslationTextComponent("tooltip.relics.ice_skates.shift_1"));
        tooltip.add(new TranslationTextComponent("tooltip.relics.ice_skates.shift_2"));
        return tooltip;
    }

    public void curioTick(String identifier, int index, LivingEntity livingEntity, ItemStack stack) {
        ModifiableAttributeInstance movementSpeed = livingEntity.func_110148_a(Attributes.field_233821_d_);
        int time = NBTUtils.getInt(stack, TAG_SPEEDUP_TIME, 0);
        BlockPos pos = WorldUtils.getSolidBlockUnderFeet(livingEntity.func_130014_f_(), livingEntity.func_233580_cy_());
        if (pos != null) {
            if (livingEntity.func_130014_f_().func_180495_p(pos).func_235714_a_((ITag)BlockTags.field_205213_E)) {
                if (livingEntity.func_70051_ag()) {
                    EntityUtils.applyAttributeModifier(movementSpeed, new AttributeModifier((UUID)this.SPEED_INFO.getRight(), (String)this.SPEED_INFO.getLeft(), (double)((Stats)this.config).speedModifier, AttributeModifier.Operation.MULTIPLY_TOTAL));
                    if (livingEntity.field_70173_aa % 20 == 0 && (float)time < ((Stats)this.config).maxSpeedupTime) {
                        NBTUtils.setInt(stack, TAG_SPEEDUP_TIME, time + 1);
                    }
                    if (time > ((Stats)this.config).speedupsPerRam) {
                        livingEntity.func_130014_f_().func_195594_a((IParticleData)ParticleTypes.field_197613_f, livingEntity.func_226277_ct_(), livingEntity.func_226278_cu_() + (double)0.1f, livingEntity.func_226281_cx_(), 0.0, 0.0, 0.0);
                        for (LivingEntity entity : livingEntity.func_130014_f_().func_217357_a(LivingEntity.class, livingEntity.func_174813_aQ().func_186662_g((double)((Stats)this.config).ramRadius))) {
                            if (entity == livingEntity) continue;
                            entity.func_213317_d(entity.func_213303_ch().func_178788_d(livingEntity.func_213303_ch()).func_72432_b().func_216372_d((double)((float)time * 0.25f), (double)((float)time * 0.1f), (double)((float)time * 0.25f)));
                            entity.func_70097_a(DamageSource.field_188406_j, ((Stats)this.config).baseRamDamage + (float)time);
                            NBTUtils.setInt(stack, TAG_SPEEDUP_TIME, Math.max(time - ((Stats)this.config).speedupsPerRam, 0));
                        }
                    }
                }
            } else if (livingEntity.func_130014_f_().func_180495_p(livingEntity.func_233580_cy_().func_177977_b()) == Fluids.field_204546_a.func_210198_f().func_207188_f().func_206883_i() && time > 0) {
                livingEntity.func_130014_f_().func_175656_a(livingEntity.func_233580_cy_().func_177977_b(), Blocks.field_185778_de.func_176223_P());
                NBTUtils.setInt(stack, TAG_SPEEDUP_TIME, time - 1);
            } else {
                NBTUtils.setInt(stack, TAG_SPEEDUP_TIME, 0);
                EntityUtils.removeAttributeModifier(movementSpeed, new AttributeModifier((UUID)this.SPEED_INFO.getRight(), (String)this.SPEED_INFO.getLeft(), (double)((Stats)this.config).speedModifier, AttributeModifier.Operation.MULTIPLY_TOTAL));
            }
        }
    }

    public void onUnequip(String identifier, int index, LivingEntity livingEntity, ItemStack stack) {
        EntityUtils.removeAttributeModifier(livingEntity.func_110148_a(Attributes.field_233821_d_), new AttributeModifier((UUID)this.SPEED_INFO.getRight(), (String)this.SPEED_INFO.getLeft(), (double)((Stats)this.config).speedModifier, AttributeModifier.Operation.MULTIPLY_TOTAL));
    }

    @Override
    public List<ResourceLocation> getLootChests() {
        return RelicUtils.Worldgen.COLD;
    }

    @Override
    public Class<Stats> getConfigClass() {
        return Stats.class;
    }

    public void render(String identifier, int index, MatrixStack matrixStack, IRenderTypeBuffer renderTypeBuffer, int light, LivingEntity livingEntity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, ItemStack stack) {
        IceSkatesModel model = new IceSkatesModel();
        matrixStack.func_227860_a_();
        matrixStack.func_227862_a_(1.025f, 1.025f, 1.025f);
        model.func_225597_a_(livingEntity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        model.func_212843_a_(livingEntity, limbSwing, limbSwingAmount, partialTicks);
        ICurio.RenderHelper.followBodyRotations((LivingEntity)livingEntity, (BipedModel[])new BipedModel[]{model});
        model.func_225598_a_(matrixStack, renderTypeBuffer.getBuffer(RenderType.func_228638_b_((ResourceLocation)this.TEXTURE)), light, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
        matrixStack.func_227865_b_();
    }

    public boolean canRender(String identifier, int index, LivingEntity livingEntity, ItemStack stack) {
        return true;
    }

    public static class Stats
    extends RelicStats {
        public float speedModifier = 1.1f;
        public float maxSpeedupTime = 10.0f;
        public int speedupsPerRam = 2;
        public int ramRadius = 1;
        public float baseRamDamage = 2.0f;
        public float fallingDamageMultiplier = 0.25f;
    }

    @Mod.EventBusSubscriber(modid="relics")
    public static class IceSkatesEvents {
        @SubscribeEvent
        public static void onEntityHurt(LivingHurtEvent event) {
            Stats config = (Stats)INSTANCE.config;
            if (event.getEntityLiving() instanceof PlayerEntity) {
                PlayerEntity player = (PlayerEntity)event.getEntityLiving();
                if (CuriosApi.getCuriosHelper().findEquippedCurio((Item)ItemRegistry.SCARAB_TALISMAN.get(), (LivingEntity)player).isPresent() && event.getSource() == DamageSource.field_76379_h && player.func_130014_f_().func_180495_p(player.func_233580_cy_().func_177977_b()).func_235714_a_((ITag)BlockTags.field_205213_E)) {
                    event.setAmount(event.getAmount() * config.fallingDamageMultiplier);
                }
            }
        }
    }
}

