/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.items.relics.boots;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import it.hurts.sskirillss.relics.blocks.MagmaStoneBlock;
import it.hurts.sskirillss.relics.configs.variables.stats.RelicStats;
import it.hurts.sskirillss.relics.init.BlockRegistry;
import it.hurts.sskirillss.relics.init.ItemRegistry;
import it.hurts.sskirillss.relics.items.RelicItem;
import it.hurts.sskirillss.relics.items.relics.renderer.MagmaWalkerModel;
import it.hurts.sskirillss.relics.utils.RelicUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.LivingEntity;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.Property;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.capability.ICurio;
import top.theillusivec4.curios.api.type.capability.ICurioItem;

public class MagmaWalkerItem
extends RelicItem<RelicStats>
implements ICurioItem {
    private final ResourceLocation TEXTURE = new ResourceLocation("relics", "textures/items/models/magma_walker.png");

    public MagmaWalkerItem() {
        super(Rarity.RARE);
    }

    @Override
    public List<ITextComponent> getShiftTooltip(ItemStack stack) {
        ArrayList tooltip = Lists.newArrayList();
        tooltip.add(new TranslationTextComponent("tooltip.relics.magma_walker.shift_1"));
        tooltip.add(new TranslationTextComponent("tooltip.relics.magma_walker.shift_2"));
        return tooltip;
    }

    public void curioTick(String identifier, int index, LivingEntity livingEntity, ItemStack stack) {
        World world = livingEntity.func_130014_f_();
        if (world.func_180495_p(livingEntity.func_233580_cy_().func_177977_b()) == Fluids.field_204547_b.func_210198_f().func_207188_f().func_206883_i()) {
            BlockPos pos = livingEntity.func_233580_cy_();
            world.func_175656_a(pos.func_177977_b(), ((MagmaStoneBlock)BlockRegistry.MAGMA_STONE_BLOCK.get()).func_176223_P());
            world.func_195594_a((IParticleData)ParticleTypes.field_197595_F, (double)((float)pos.func_177958_n() + 0.5f), (double)pos.func_177956_o(), (double)((float)pos.func_177952_p() + 0.5f), 1.0, 1.0, 1.0);
        }
        if (world.func_180495_p(livingEntity.func_233580_cy_().func_177977_b()).func_177230_c() == BlockRegistry.MAGMA_STONE_BLOCK.get() && (Integer)world.func_180495_p(livingEntity.func_233580_cy_().func_177977_b()).func_177229_b((Property)MagmaStoneBlock.AGE) > 0) {
            world.func_180501_a(livingEntity.func_233580_cy_().func_177977_b(), ((MagmaStoneBlock)BlockRegistry.MAGMA_STONE_BLOCK.get()).func_176223_P(), 2);
        }
    }

    @Override
    public List<ResourceLocation> getLootChests() {
        return RelicUtils.Worldgen.NETHER;
    }

    public void render(String identifier, int index, MatrixStack matrixStack, IRenderTypeBuffer renderTypeBuffer, int light, LivingEntity livingEntity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, ItemStack stack) {
        MagmaWalkerModel model = new MagmaWalkerModel();
        matrixStack.func_227860_a_();
        matrixStack.func_227862_a_(1.025f, 1.025f, 1.025f);
        model.func_225597_a_(livingEntity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        model.func_212843_a_(livingEntity, limbSwing, limbSwingAmount, partialTicks);
        ICurio.RenderHelper.followBodyRotations((LivingEntity)livingEntity, (BipedModel[])new BipedModel[]{model});
        model.func_225598_a_(matrixStack, renderTypeBuffer.getBuffer(RenderType.func_228644_e_((ResourceLocation)this.TEXTURE)), light, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
        matrixStack.func_227865_b_();
    }

    public boolean canRender(String identifier, int index, LivingEntity livingEntity, ItemStack stack) {
        return true;
    }

    @Mod.EventBusSubscriber(modid="relics")
    public static class MagmaWalkerServerEvents {
        @SubscribeEvent
        public static void onLivingHurt(LivingHurtEvent event) {
            if (event.getSource() == DamageSource.field_190095_e) {
                LivingEntity player = event.getEntityLiving();
                if (CuriosApi.getCuriosHelper().findEquippedCurio((Item)ItemRegistry.MAGMA_WALKER.get(), player).isPresent()) {
                    event.setCanceled(true);
                }
            }
        }

        @SubscribeEvent
        public static void onLivingAttack(LivingAttackEvent event) {
            if (event.getSource() == DamageSource.field_190095_e) {
                LivingEntity player = event.getEntityLiving();
                if (CuriosApi.getCuriosHelper().findEquippedCurio((Item)ItemRegistry.MAGMA_WALKER.get(), player).isPresent()) {
                    event.setCanceled(true);
                }
            }
        }
    }
}

