/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.items.relics.boots;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import it.hurts.sskirillss.relics.configs.variables.stats.RelicStats;
import it.hurts.sskirillss.relics.items.RelicItem;
import it.hurts.sskirillss.relics.items.relics.renderer.OutRunnerModel;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import it.hurts.sskirillss.relics.utils.NBTUtils;
import it.hurts.sskirillss.relics.utils.RelicUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import org.apache.commons.lang3.tuple.MutablePair;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurio;
import top.theillusivec4.curios.api.type.capability.ICurioItem;

public class OutRunnerItem
extends RelicItem<Stats>
implements ICurioItem {
    private final MutablePair<String, UUID> SPEED_INFO = new MutablePair((Object)"relics:out_runner_movement_speed", (Object)UUID.fromString("9bf3eeb5-8587-4fb7-ad81-fd76e01f4acf"));
    private static final String TAG_RUN_DURATION = "duration";
    private final ResourceLocation TEXTURE = new ResourceLocation("relics", "textures/items/models/out_runner.png");

    public OutRunnerItem() {
        super(Rarity.RARE);
    }

    @Override
    public List<ITextComponent> getShiftTooltip(ItemStack stack) {
        ArrayList tooltip = Lists.newArrayList();
        tooltip.add(new TranslationTextComponent("tooltip.relics.out_runner.shift_1"));
        return tooltip;
    }

    public void curioTick(String identifier, int index, LivingEntity livingEntity, ItemStack stack) {
        if (!(livingEntity instanceof PlayerEntity)) {
            return;
        }
        PlayerEntity player = (PlayerEntity)livingEntity;
        ModifiableAttributeInstance movementSpeed = livingEntity.func_110148_a(Attributes.field_233821_d_);
        int duration = NBTUtils.getInt(stack, TAG_RUN_DURATION, 0);
        if (!player.func_70051_ag() || player.func_225608_bj_() || player.func_70090_H()) {
            if (duration > 0) {
                NBTUtils.setInt(stack, TAG_RUN_DURATION, 0);
            }
            EntityUtils.removeAttributeModifier(player.func_110148_a(Attributes.field_233821_d_), new AttributeModifier((UUID)this.SPEED_INFO.getRight(), (String)this.SPEED_INFO.getLeft(), (double)((Stats)this.config).speedModifier, AttributeModifier.Operation.MULTIPLY_TOTAL));
            player.field_70138_W = 0.6f;
            return;
        }
        if (duration < ((Stats)this.config).activationTime) {
            if (player.field_70173_aa % 20 == 0) {
                NBTUtils.setInt(stack, TAG_RUN_DURATION, duration + 1);
            }
        } else {
            player.func_130014_f_().func_195594_a((IParticleData)ParticleTypes.field_197613_f, player.func_226277_ct_(), player.func_226278_cu_() + (double)0.15f, player.func_226281_cx_(), 0.0, 0.25, 0.0);
            EntityUtils.applyAttributeModifier(player.func_110148_a(Attributes.field_233821_d_), new AttributeModifier((UUID)this.SPEED_INFO.getRight(), (String)this.SPEED_INFO.getLeft(), (double)((Stats)this.config).speedModifier, AttributeModifier.Operation.MULTIPLY_TOTAL));
            livingEntity.field_70138_W = Math.max(livingEntity.field_70138_W, 1.1f);
        }
    }

    public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        EntityUtils.removeAttributeModifier(slotContext.getWearer().func_110148_a(Attributes.field_233821_d_), new AttributeModifier((UUID)this.SPEED_INFO.getRight(), (String)this.SPEED_INFO.getLeft(), (double)((Stats)this.config).speedModifier, AttributeModifier.Operation.MULTIPLY_TOTAL));
        slotContext.getWearer().field_70138_W = 0.6f;
    }

    @Override
    public List<ResourceLocation> getLootChests() {
        return RelicUtils.Worldgen.CAVE;
    }

    @Override
    public Class<Stats> getConfigClass() {
        return Stats.class;
    }

    public void render(String identifier, int index, MatrixStack matrixStack, IRenderTypeBuffer renderTypeBuffer, int light, LivingEntity livingEntity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, ItemStack stack) {
        OutRunnerModel model = new OutRunnerModel();
        matrixStack.func_227860_a_();
        matrixStack.func_227862_a_(1.025f, 1.025f, 1.025f);
        model.func_225597_a_(livingEntity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        model.func_212843_a_(livingEntity, limbSwing, limbSwingAmount, partialTicks);
        ICurio.RenderHelper.followBodyRotations((LivingEntity)livingEntity, (BipedModel[])new BipedModel[]{model});
        model.func_225598_a_(matrixStack, renderTypeBuffer.getBuffer(RenderType.func_228644_e_((ResourceLocation)this.TEXTURE)), light, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
        matrixStack.func_227865_b_();
    }

    public boolean canRender(String identifier, int index, LivingEntity livingEntity, ItemStack stack) {
        return true;
    }

    public static class Stats
    extends RelicStats {
        public float speedModifier = 1.25f;
        public int activationTime = 10;
    }
}

