/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.items.relics.renderer;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.ArrayDeque;
import java.util.Deque;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.NotNull;
import top.theillusivec4.curios.api.CuriosApi;

@Mod.EventBusSubscriber(modid="relics", value={Dist.CLIENT})
public class RelicRendererHandler {
    private static final LoadingCache<Object, Deque<Runnable>> cache = CacheBuilder.newBuilder().weakKeys().build((CacheLoader)new CacheLoader<Object, Deque<Runnable>>(){

        public Deque<Runnable> load(@NotNull Object key) {
            return new ArrayDeque<Runnable>();
        }
    });

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void handlePostRenderPlayerLow(RenderPlayerEvent.Post event) {
        PlayerEntity player = event.getPlayer();
        if (!RelicRendererHandler.haveBoot(player)) {
            return;
        }
        RelicRendererHandler.restoreItems((Deque)cache.getUnchecked((Object)player));
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void handlePreRenderPlayerHigh(RenderPlayerEvent.Pre event) {
        PlayerEntity player = event.getPlayer();
        if (!RelicRendererHandler.haveBoot(player)) {
            return;
        }
        Deque queue = (Deque)cache.getUnchecked((Object)player);
        RelicRendererHandler.restoreItems(queue);
        NonNullList armor = player.field_71071_by.field_70460_b;
        ItemStack stack = (ItemStack)armor.get(0);
        queue.add(() -> {
            ItemStack cfr_ignored_0 = (ItemStack)armor.set(0, (Object)stack);
        });
        armor.set(0, (Object)ItemStack.field_190927_a);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void handlePreRenderPlayerLowest(RenderPlayerEvent.Pre event) {
        if (!event.isCanceled()) {
            return;
        }
        PlayerEntity player = event.getPlayer();
        if (!RelicRendererHandler.haveBoot(player)) {
            return;
        }
        RelicRendererHandler.restoreItems((Deque)cache.getUnchecked((Object)player));
    }

    private static void restoreItems(Deque<Runnable> queue) {
        Runnable runnable;
        while ((runnable = queue.poll()) != null) {
            try {
                runnable.run();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static boolean haveBoot(PlayerEntity player) {
        if (ModList.get().isLoaded("cosmeticarmorreworked")) {
            return false;
        }
        LazyOptional helper = CuriosApi.getCuriosHelper().getCuriosHandler((LivingEntity)player);
        return helper.map(curios -> curios.getStacksHandler("feet").map(handler -> {
            for (int i = 0; i < handler.getSlots(); ++i) {
                if (handler.getStacks().getStackInSlot(i).func_190926_b() || !((Boolean)handler.getRenders().get(i)).booleanValue()) continue;
                return true;
            }
            return false;
        }).orElse(false)).orElse(false);
    }
}

