/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.particles.circle;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.hurts.sskirillss.relics.init.ParticleRegistry;
import java.awt.Color;
import java.util.Locale;
import javax.annotation.Nonnull;
import net.minecraft.network.PacketBuffer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;
import net.minecraft.util.math.MathHelper;

public class CircleTintData
implements IParticleData {
    private final Color tint;
    private final float diameter;
    private final int lifeTime;
    private final float resizeSpeed;
    private final boolean shouldCollide;
    public static final Codec<CircleTintData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("tint").forGetter(d -> d.tint.getRGB()), (App)Codec.FLOAT.fieldOf("diameter").forGetter(d -> Float.valueOf(d.diameter)), (App)Codec.INT.fieldOf("life_time").forGetter(d -> d.lifeTime), (App)Codec.FLOAT.fieldOf("resize_speed").forGetter(d -> Float.valueOf(d.resizeSpeed)), (App)Codec.BOOL.fieldOf("should_collide").forGetter(d -> d.shouldCollide)).apply((Applicative)instance, CircleTintData::new));
    public static final IParticleData.IDeserializer<CircleTintData> DESERIALIZER = new IParticleData.IDeserializer<CircleTintData>(){

        @Nonnull
        public CircleTintData fromCommand(@Nonnull ParticleType<CircleTintData> type, @Nonnull StringReader reader) throws CommandSyntaxException {
            reader.expect(' ');
            int red = MathHelper.func_76125_a((int)reader.readInt(), (int)0, (int)255);
            reader.expect(' ');
            int green = MathHelper.func_76125_a((int)reader.readInt(), (int)0, (int)255);
            reader.expect(' ');
            int blue = MathHelper.func_76125_a((int)reader.readInt(), (int)0, (int)255);
            reader.expect(' ');
            float diameter = CircleTintData.validateDiameter(reader.readFloat());
            reader.expect(' ');
            int lifeTime = reader.readInt();
            reader.expect(' ');
            float resizeSpeed = reader.readFloat();
            reader.expect(' ');
            boolean shouldCollide = reader.readBoolean();
            return new CircleTintData(new Color(red, green, blue), diameter, lifeTime, resizeSpeed, shouldCollide);
        }

        public CircleTintData fromNetwork(@Nonnull ParticleType<CircleTintData> type, PacketBuffer buf) {
            int red = MathHelper.func_76125_a((int)buf.readInt(), (int)0, (int)255);
            int green = MathHelper.func_76125_a((int)buf.readInt(), (int)0, (int)255);
            int blue = MathHelper.func_76125_a((int)buf.readInt(), (int)0, (int)255);
            Color color = new Color(red, green, blue);
            float diameter = CircleTintData.validateDiameter(buf.readFloat());
            int lifeTime = buf.readInt();
            float resizeSpeed = buf.readFloat();
            boolean shouldCollide = buf.readBoolean();
            return new CircleTintData(color, diameter, lifeTime, resizeSpeed, shouldCollide);
        }
    };

    public CircleTintData(Color tint, float diameter, int lifeTime, float resizeSpeed, boolean shouldCollide) {
        this.tint = tint;
        this.lifeTime = lifeTime;
        this.diameter = CircleTintData.validateDiameter(diameter);
        this.resizeSpeed = resizeSpeed;
        this.shouldCollide = shouldCollide;
    }

    public Color getTint() {
        return this.tint;
    }

    public int getLifeTime() {
        return this.lifeTime;
    }

    public float getDiameter() {
        return this.diameter;
    }

    public float getResizeSpeed() {
        return this.resizeSpeed;
    }

    public boolean shouldCollide() {
        return this.shouldCollide;
    }

    @Nonnull
    public ParticleType<CircleTintData> func_197554_b() {
        return ParticleRegistry.CIRCLE_TINT;
    }

    public void func_197553_a(PacketBuffer buf) {
        buf.writeInt(this.tint.getRed());
        buf.writeInt(this.tint.getGreen());
        buf.writeInt(this.tint.getBlue());
        buf.writeFloat(this.diameter);
        buf.writeInt(this.lifeTime);
        buf.writeFloat(this.resizeSpeed);
        buf.writeBoolean(this.shouldCollide);
    }

    @Nonnull
    public String func_197555_a() {
        return String.format(Locale.ROOT, "%s %i %i %i %.2f %i %f %b", this.func_197554_b().getRegistryName(), this.tint.getRed(), this.tint.getGreen(), this.tint.getBlue(), Float.valueOf(this.diameter), this.lifeTime, Float.valueOf(this.resizeSpeed), this.shouldCollide);
    }

    private static float validateDiameter(float diameter) {
        return (float)MathHelper.func_151237_a((double)diameter, (double)0.05, (double)5.0);
    }

    private CircleTintData(int tintRGB, float diameter, int lifeTime, float resizeSpeed, boolean shouldCollide) {
        this.tint = new Color(tintRGB);
        this.lifeTime = lifeTime;
        this.diameter = CircleTintData.validateDiameter(diameter);
        this.resizeSpeed = resizeSpeed;
        this.shouldCollide = shouldCollide;
    }
}

