/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.tiles.renderer;

import com.mojang.blaze3d.matrix.MatrixStack;
import it.hurts.sskirillss.relics.items.RuneItem;
import it.hurts.sskirillss.relics.tiles.RunicAltarTile;
import it.hurts.sskirillss.relics.utils.RenderUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3f;

public class RunicAltarTileRenderer
extends TileEntityRenderer<RunicAltarTile> {
    private int iteration;

    public RunicAltarTileRenderer(TileEntityRendererDispatcher rendererDispatcherIn) {
        super(rendererDispatcherIn);
    }

    public void render(RunicAltarTile tileEntity, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer buffer, int combinedLight, int combinedOverlay) {
        ItemStack ingredient;
        ItemRenderer itemRenderer = Minecraft.func_71410_x().func_175599_af();
        for (Direction direction : RunicAltarTile.runeDirections) {
            ItemStack rune = tileEntity.getStack(direction);
            if (rune == null || rune.func_190926_b() || !(rune.func_77973_b() instanceof RuneItem)) continue;
            ++this.iteration;
            matrixStack.func_227860_a_();
            if (tileEntity.getCraftingProgress() > 0) {
                matrixStack.func_227861_a_(0.5, 1.25, 0.5);
                matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_((float)tileEntity.ticksExisted + (float)this.iteration * (360.0f / (float)tileEntity.getRunes().size())));
                matrixStack.func_227861_a_(-0.75, 0.0, -0.75);
                matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(45.0f));
                matrixStack.func_227861_a_(0.0, (double)(MathHelper.func_76126_a((float)((float)tileEntity.ticksExisted / 20.0f)) * 0.1f), 0.0);
                matrixStack.func_227862_a_(0.35f, 0.35f, 0.35f);
                itemRenderer.func_229111_a_(rune, ItemCameraTransforms.TransformType.FIXED, true, matrixStack, buffer, combinedLight, combinedOverlay, itemRenderer.func_184393_a(rune, tileEntity.func_145831_w(), null));
                matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229193_c_(90.0f + MathHelper.func_76126_a((float)((float)tileEntity.ticksExisted / 20.0f)) * 0.1f));
                RenderUtils.renderBeam(matrixStack, buffer, partialTicks, 2.5f, ((RuneItem)rune.func_77973_b()).getColor());
            } else {
                matrixStack.func_227861_a_(0.5, (double)0.58f, 0.5);
                matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(45.0f));
                float rotation = 0.0f;
                if (direction == Direction.SOUTH) {
                    rotation = 90.0f;
                } else if (direction == Direction.EAST) {
                    rotation = 180.0f;
                } else if (direction == Direction.NORTH) {
                    rotation = 270.0f;
                }
                matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(rotation));
                matrixStack.func_227861_a_((double)-0.325f, 0.0, (double)-0.325f);
                matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(45.0f));
                matrixStack.func_227862_a_(0.25f, 0.25f, 0.25f);
                itemRenderer.func_229111_a_(rune, ItemCameraTransforms.TransformType.FIXED, true, matrixStack, buffer, combinedLight, combinedOverlay, itemRenderer.func_184393_a(rune, tileEntity.func_145831_w(), null));
            }
            matrixStack.func_227865_b_();
        }
        this.iteration = 0;
        ItemStack relic = tileEntity.getStack(Direction.UP);
        if (!relic.func_190926_b()) {
            matrixStack.func_227860_a_();
            matrixStack.func_227861_a_(0.5, (double)0.775f, 0.5);
            matrixStack.func_227863_a_(Direction.NORTH.func_229384_a_());
            matrixStack.func_227862_a_(0.5f, 0.5f, 0.5f);
            itemRenderer.func_229111_a_(relic, ItemCameraTransforms.TransformType.FIXED, true, matrixStack, buffer, combinedLight, combinedOverlay, itemRenderer.func_184393_a(relic, tileEntity.func_145831_w(), null));
            matrixStack.func_227865_b_();
        }
        if (!(ingredient = tileEntity.getIngredient()).func_190926_b()) {
            matrixStack.func_227860_a_();
            matrixStack.func_227861_a_(0.5, 1.75, 0.5);
            matrixStack.func_227862_a_(0.35f, 0.35f, 0.35f);
            matrixStack.func_227861_a_(0.0, (double)(MathHelper.func_76126_a((float)((float)tileEntity.ticksExisted / 10.0f)) * 0.25f), 0.0);
            matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229193_c_((float)tileEntity.ticksExisted / 20.0f));
            matrixStack.func_227861_a_(0.0, (double)(MathHelper.func_76126_a((float)((float)tileEntity.ticksExisted / 10.0f)) * 0.25f), 0.0);
            matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229193_c_((float)tileEntity.ticksExisted / 20.0f));
            itemRenderer.func_229111_a_(ingredient, ItemCameraTransforms.TransformType.FIXED, true, matrixStack, buffer, combinedLight, combinedOverlay, itemRenderer.func_184393_a(ingredient, tileEntity.func_145831_w(), null));
            matrixStack.func_227865_b_();
        }
    }
}

