/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.utils;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;

public class EntityUtils {
    public static void moveTowardsPosition(Entity entity, Vector3d targetPos, float speed) {
        Vector3d motion = targetPos.func_178788_d(entity.func_213303_ch());
        motion = motion.func_72432_b().func_186678_a((double)speed);
        entity.func_213293_j(motion.field_72450_a, motion.field_72448_b, motion.field_72449_c);
    }

    public static int getSlotWithItem(PlayerEntity player, Item item) {
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            if (player.field_71071_by.func_70301_a(i).func_77973_b() != item) continue;
            return i;
        }
        return -1;
    }

    public static List<Integer> getSlotsWithItem(PlayerEntity player, Item item) {
        ArrayList list = Lists.newArrayList();
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            if (player.field_71071_by.func_70301_a(i).func_77973_b() != item) continue;
            list.add(i);
            if (i != player.field_71071_by.func_70302_i_()) continue;
            return list;
        }
        return list;
    }

    public static EntityRayTraceResult rayTraceEntity(Entity shooter, Predicate<Entity> filter, double distance) {
        World world = shooter.field_70170_p;
        Vector3d startVec = shooter.func_174824_e(1.0f);
        Vector3d endVec = shooter.func_174824_e(1.0f).func_178787_e(shooter.func_70676_i(1.0f).func_186678_a(distance));
        double d0 = distance * distance;
        Entity entity = null;
        Vector3d vector3d = null;
        for (Entity entity1 : world.func_175674_a(shooter, shooter.func_174813_aQ().func_216361_a(shooter.func_70676_i(1.0f).func_186678_a(distance * distance)).func_186662_g(1.0), filter)) {
            Vector3d vector3d1;
            double d1;
            AxisAlignedBB axisalignedbb = entity1.func_174813_aQ().func_186662_g((double)entity1.func_70111_Y());
            Optional optional = axisalignedbb.func_216365_b(startVec, endVec);
            if (axisalignedbb.func_72318_a(startVec)) {
                if (!(d0 >= 0.0)) continue;
                entity = entity1;
                vector3d = optional.orElse(startVec);
                d0 = 0.0;
                continue;
            }
            if (!optional.isPresent() || !((d1 = startVec.func_72436_e(vector3d1 = (Vector3d)optional.get())) < d0) && d0 != 0.0) continue;
            if (entity1.func_184208_bv() == shooter.func_184208_bv() && !entity1.canRiderInteract()) {
                if (d0 != 0.0) continue;
                entity = entity1;
                vector3d = vector3d1;
                continue;
            }
            entity = entity1;
            vector3d = vector3d1;
            d0 = d1;
        }
        return entity == null ? null : new EntityRayTraceResult(entity, vector3d);
    }

    public static void applyAttributeModifier(ModifiableAttributeInstance instance, AttributeModifier modifier) {
        if (!instance.func_180374_a(modifier)) {
            instance.func_233767_b_(modifier);
        }
    }

    public static void removeAttributeModifier(ModifiableAttributeInstance instance, AttributeModifier modifier) {
        if (instance.func_180374_a(modifier)) {
            instance.func_111124_b(modifier);
        }
    }
}

