/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.utils;

import com.google.common.collect.Lists;
import it.hurts.sskirillss.relics.configs.variables.durability.RelicDurability;
import it.hurts.sskirillss.relics.configs.variables.level.RelicLevel;
import it.hurts.sskirillss.relics.configs.variables.worldgen.RelicLoot;
import it.hurts.sskirillss.relics.configs.variables.worldgen.RuneLoot;
import it.hurts.sskirillss.relics.init.ItemRegistry;
import it.hurts.sskirillss.relics.items.RelicItem;
import it.hurts.sskirillss.relics.items.RuneItem;
import it.hurts.sskirillss.relics.utils.MathUtils;
import it.hurts.sskirillss.relics.utils.NBTUtils;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootTables;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class RelicUtils {

    public static class RunesWorldgen {
        public static HashMap<RuneItem, RuneLoot> LOOT = new HashMap();
        public static final List<ResourceLocation> CHESTS = Arrays.asList(LootTables.field_204115_q, LootTables.field_204114_p, LootTables.field_204773_u, LootTables.field_186425_g, LootTables.field_237382_N_, LootTables.field_237381_M_, LootTables.field_237380_L_, LootTables.field_237383_O_, LootTables.field_237384_P_, LootTables.field_186431_m, LootTables.field_186429_k, LootTables.field_186428_j, LootTables.field_186427_i, LootTables.field_186426_h, LootTables.field_186424_f);
    }

    public static class Crafting {
        public static HashMap<RuneItem, List<Item>> INGREDIENTS = new HashMap();

        public static List<Item> getIngredients(Item item) {
            if (!(item instanceof RuneItem)) {
                return Lists.newArrayList();
            }
            return INGREDIENTS.get((Object)((RuneItem)item));
        }
    }

    public static class Durability {
        public static HashMap<RelicItem, RelicDurability> DURABILITY = new HashMap();
        public static final String TAG_DURABILITY = "durability";

        public static int getMaxDurability(Item relic) {
            if (!(relic instanceof RelicItem)) {
                return -1;
            }
            return DURABILITY.get((Object)((RelicItem)relic)).getDurability();
        }

        public static int getDurability(ItemStack stack) {
            return NBTUtils.getInt(stack, TAG_DURABILITY, -1);
        }

        public static void setDurability(ItemStack stack, int durability) {
            if (!(stack.func_77973_b() instanceof RelicItem)) {
                return;
            }
            NBTUtils.setInt(stack, TAG_DURABILITY, MathUtils.clamp(durability, Durability.getMaxDurability(stack.func_77973_b()), 0));
        }

        public static void addDurability(ItemStack stack, int durability) {
            Durability.setDurability(stack, Durability.getDurability(stack) + durability);
        }

        public static void takeDurability(ItemStack stack, int durability) {
            Durability.setDurability(stack, Durability.getDurability(stack) - durability);
        }

        public static ItemStack getScrap(ItemStack stack) {
            Item scrap = ItemStack.field_190927_a.func_77973_b();
            switch (stack.func_77953_t()) {
                case COMMON: {
                    scrap = (Item)ItemRegistry.COMMON_SCRAP.get();
                    break;
                }
                case UNCOMMON: {
                    scrap = (Item)ItemRegistry.UNCOMMON_SCRAP.get();
                    break;
                }
                case RARE: {
                    scrap = (Item)ItemRegistry.RARE_SCRAP.get();
                    break;
                }
                case EPIC: {
                    scrap = (Item)ItemRegistry.EPIC_SCRAP.get();
                }
            }
            return new ItemStack((IItemProvider)scrap);
        }
    }

    public static class Worldgen {
        public static HashMap<RelicItem, RelicLoot> LOOT = new HashMap();
        public static final List<ResourceLocation> AQUATIC = Arrays.asList(LootTables.field_204115_q, LootTables.field_204114_p, LootTables.field_204773_u);
        public static final List<ResourceLocation> NETHER = Arrays.asList(LootTables.field_186425_g, LootTables.field_237382_N_, LootTables.field_237381_M_, LootTables.field_237380_L_, LootTables.field_237383_O_, LootTables.field_237384_P_);
        public static final List<ResourceLocation> COLD = Arrays.asList(LootTables.field_186431_m, LootTables.field_215828_s, LootTables.field_215827_r);
        public static final List<ResourceLocation> DESERT = Arrays.asList(LootTables.field_186429_k, LootTables.field_215825_p);
        public static final List<ResourceLocation> CAVE = Arrays.asList(LootTables.field_186428_j, LootTables.field_186427_i, LootTables.field_186426_h, LootTables.field_186424_f);
    }

    public static class Level {
        public static HashMap<RelicItem, RelicLevel> LEVEL = new HashMap();
        private static final String TAG_LEVEL = "level";
        private static final String TAG_EXPERIENCE = "experience";

        public static int getLevel(ItemStack stack) {
            if (!(stack.func_77973_b() instanceof RelicItem)) {
                return 0;
            }
            return NBTUtils.getInt(stack, TAG_LEVEL, 0);
        }

        public static int getLevelFromExperience(ItemStack stack, int experience) {
            if (!(stack.func_77973_b() instanceof RelicItem)) {
                return 0;
            }
            RelicLevel relicLevel = Level.getRelicLevel((RelicItem)stack.func_77973_b());
            int min = 0;
            int max = relicLevel.getMaxLevel();
            while (min <= max) {
                int mid = (min + max) / 2;
                int exp = Level.getTotalExperienceForLevel(stack, mid);
                if (exp > experience) {
                    max = mid - 1;
                    continue;
                }
                min = mid + 1;
            }
            return max;
        }

        public static void setLevel(ItemStack stack, int level) {
            if (!(stack.func_77973_b() instanceof RelicItem)) {
                return;
            }
            Level.setExperience(stack, Level.getTotalExperienceForLevel(stack, level));
        }

        public static void addLevel(ItemStack stack, int level) {
            if (!(stack.func_77973_b() instanceof RelicItem)) {
                return;
            }
            Level.setLevel(stack, Level.getLevel(stack) + level);
        }

        public static void takeLevel(ItemStack stack, int level) {
            if (!(stack.func_77973_b() instanceof RelicItem)) {
                return;
            }
            Level.setLevel(stack, Level.getLevel(stack) - level);
        }

        public static int getExperience(ItemStack stack) {
            if (!(stack.func_77973_b() instanceof RelicItem)) {
                return 0;
            }
            return NBTUtils.getInt(stack, TAG_EXPERIENCE, 0);
        }

        public static int getExperienceForLevel(ItemStack stack, int level) {
            if (!(stack.func_77973_b() instanceof RelicItem)) {
                return 0;
            }
            return Level.getTotalExperienceForLevel(stack, level + 1) - Level.getTotalExperienceForLevel(stack, level);
        }

        public static int getTotalExperienceForLevel(ItemStack stack, int level) {
            if (!(stack.func_77973_b() instanceof RelicItem)) {
                return 0;
            }
            return Level.getTotalExperienceForLevel(Level.getRelicLevel((RelicItem)stack.func_77973_b()), level);
        }

        public static int getTotalExperienceForLevel(RelicLevel relicLevel, int level) {
            return (2 * relicLevel.getInitialExp() + relicLevel.getExpRatio() * (level - 1)) * level / 2;
        }

        public static void setExperience(ItemStack stack, int experience) {
            if (!(stack.func_77973_b() instanceof RelicItem)) {
                return;
            }
            RelicLevel relicLevel = Level.getRelicLevel((RelicItem)stack.func_77973_b());
            experience = Math.max(0, Math.min(relicLevel.getMaxExperience(), experience));
            NBTUtils.setInt(stack, TAG_LEVEL, Math.max(0, Math.min(relicLevel.getMaxLevel(), Level.getLevelFromExperience(stack, experience))));
            NBTUtils.setInt(stack, TAG_EXPERIENCE, experience);
        }

        public static void addExperience(ItemStack stack, int experience) {
            if (!(stack.func_77973_b() instanceof RelicItem)) {
                return;
            }
            Level.setExperience(stack, Level.getExperience(stack) + experience);
        }

        public static void takeExperience(ItemStack stack, int experience) {
            if (!(stack.func_77973_b() instanceof RelicItem)) {
                return;
            }
            Level.setExperience(stack, Level.getExperience(stack) - experience);
        }

        protected static RelicLevel getRelicLevel(RelicItem relic) {
            return LEVEL.get((Object)relic) == null ? new RelicLevel(relic.getMaxLevel(), relic.getInitialExp(), relic.getExpRatio()) : LEVEL.get((Object)relic);
        }
    }

    public static class Owner {
        private static final String TAG_OWNER = "owner";

        public static String getOwnerUUID(ItemStack stack) {
            return NBTUtils.getString(stack, TAG_OWNER, "");
        }

        @Nullable
        public static PlayerEntity getOwner(ItemStack stack, World world) {
            String uuid = Owner.getOwnerUUID(stack);
            return !uuid.equals("") ? world.func_217371_b(UUID.fromString(uuid)) : null;
        }

        public static void setOwnerUUID(ItemStack stack, String uuid) {
            NBTUtils.setString(stack, TAG_OWNER, uuid);
        }
    }
}

