/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.utils;

import com.google.common.collect.Iterables;
import com.google.common.collect.Queues;
import java.util.Queue;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import javax.annotation.Nonnull;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.NotNull;

public class Scheduler {
    private static final Queue<Task<?>> tasks = Queues.newArrayDeque();
    private static Scheduler instance;

    public Scheduler() {
        instance = this;
    }

    public static Scheduler getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update() {
        Queue<Task<?>> queue = tasks;
        synchronized (queue) {
            Iterables.removeIf(tasks, task -> {
                try {
                    return task.update();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return true;
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V> Task<V> addTask(@NotNull Callable<V> callable, long delay, long repeats) {
        Task task = new Task(callable, delay, repeats);
        Queue<Task<?>> queue = tasks;
        synchronized (queue) {
            tasks.add(task);
            return task;
        }
    }

    public <V> Task<V> addTask(Callable<V> callable, long delay) {
        return this.addTask(callable, delay, 0L);
    }

    public <V> Task<V> addTask(Callable<V> callable) {
        return this.addTask(callable, 1L);
    }

    public Task<Object> addTask(Runnable runnable, long delay, long repeats) {
        return this.addTask(Executors.callable(runnable), delay, repeats);
    }

    public Task<Object> addTask(Runnable runnable, long delay) {
        return this.addTask(runnable, delay, 0L);
    }

    public Task<Object> addTask(Runnable runnable) {
        return this.addTask(runnable, 1L);
    }

    @Mod.EventBusSubscriber
    public static class SchedulerHandler {
        @SubscribeEvent
        public static void onServerUpdate(TickEvent.ServerTickEvent event) {
            if (tasks.isEmpty() || event.phase != TickEvent.Phase.END) {
                return;
            }
            Scheduler.getInstance().update();
        }
    }

    public static class Task<T> {
        private final Callable<T> callable;
        private final Queue<T> results;
        private final long delay;
        private long time;
        private long repeats;
        private boolean finished;
        private boolean canceled;

        private Task(@Nonnull Callable<T> task, long taskDelay, long taskRepeats) {
            this.callable = task;
            this.results = Queues.newArrayDeque();
            this.delay = this.time = taskDelay;
            this.repeats = taskRepeats;
        }

        public boolean update() throws Exception {
            if (this.canceled) {
                return true;
            }
            --this.time;
            if (this.time <= 0L) {
                this.execute();
                if (--this.repeats > 0L) {
                    this.time = this.delay;
                } else {
                    this.finished = true;
                }
            }
            return this.finished;
        }

        private void execute() throws Exception {
            T value = this.callable.call();
            if (value != null) {
                this.results.add(value);
            }
        }

        public void finish() throws Exception {
            if (!this.finished) {
                this.execute();
            }
            this.time = 0L;
            this.finished = true;
        }

        public void cancel() {
            this.canceled = true;
        }

        public T getResult() {
            return this.results.poll();
        }
    }
}

