/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.world;

import com.google.gson.JsonObject;
import it.hurts.sskirillss.relics.configs.variables.worldgen.RelicLoot;
import it.hurts.sskirillss.relics.configs.variables.worldgen.RuneLoot;
import it.hurts.sskirillss.relics.items.RelicItem;
import it.hurts.sskirillss.relics.items.RuneItem;
import it.hurts.sskirillss.relics.utils.CompatibilityUtils;
import it.hurts.sskirillss.relics.utils.RelicUtils;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class DungeonLootModifier
extends LootModifier {
    public DungeonLootModifier(ILootCondition[] conditionsIn) {
        super(conditionsIn);
    }

    @Nonnull
    public List<ItemStack> doApply(List<ItemStack> generatedLoot, LootContext context) {
        Object loot;
        if (!CompatibilityUtils.isValidForgeVersion()) {
            return generatedLoot;
        }
        Random random = context.func_216032_b();
        for (RelicItem relic : RelicUtils.Worldgen.LOOT.keySet()) {
            loot = RelicUtils.Worldgen.LOOT.get((Object)relic);
            if (!((RelicLoot)loot).getLootChests().contains(context.getQueriedLootTableId().toString()) || !(random.nextFloat() <= ((RelicLoot)loot).getChance())) continue;
            generatedLoot.add(new ItemStack((IItemProvider)relic));
        }
        for (RuneItem rune : RelicUtils.RunesWorldgen.LOOT.keySet()) {
            loot = RelicUtils.RunesWorldgen.LOOT.get((Object)rune);
            ItemStack stack = new ItemStack((IItemProvider)rune);
            stack.func_190920_e(random.nextInt(5) + 1);
            if (!((RuneLoot)loot).getLootChests().contains(context.getQueriedLootTableId().toString()) || !(random.nextFloat() <= ((RuneLoot)loot).getChance())) continue;
            generatedLoot.add(stack);
        }
        return generatedLoot;
    }

    @Mod.EventBusSubscriber(modid="relics", bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class EventHandler {
        @SubscribeEvent
        public static void registerModifierSerializers(@Nonnull RegistryEvent.Register<GlobalLootModifierSerializer<?>> event) {
            if (!CompatibilityUtils.isValidForgeVersion()) {
                return;
            }
            event.getRegistry().register((IForgeRegistryEntry)new Serializer().setRegistryName(new ResourceLocation("relics", "dungeon_loot_modifier")));
        }
    }

    private static class Serializer
    extends GlobalLootModifierSerializer<DungeonLootModifier> {
        private Serializer() {
        }

        public DungeonLootModifier read(ResourceLocation name, JsonObject object, ILootCondition[] conditionsIn) {
            return new DungeonLootModifier(conditionsIn);
        }

        public JsonObject write(DungeonLootModifier instance) {
            return this.makeConditions(instance.conditions);
        }
    }
}

