/*
 * Decompiled with CFR 0.152.
 */
package io.github.Acenio.resizing_potions.common.potion;

import io.github.Acenio.resizing_potions.common.potion.PotionRegistry;
import java.util.Collection;
import java.util.LinkedList;
import java.util.stream.Collectors;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.EffectType;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.event.entity.living.PotionEvent;
import net.minecraftforge.eventbus.api.Event;
import virtuoel.pehkui.api.ScaleData;
import virtuoel.pehkui.api.ScaleType;

public class ShrinkingEffect
extends Effect {
    protected ShrinkingEffect() {
        super(EffectType.NEUTRAL, 4980505);
    }

    public static void shrinkApplicable(PotionEvent.PotionApplicableEvent e) {
        EffectInstance effectInstance = e.getPotionEffect();
        LivingEntity entity = e.getEntityLiving();
        Collection currentEffects = entity.func_70651_bq().stream().map(EffectInstance::func_188419_a).collect(Collectors.toCollection(LinkedList::new));
        if (!effectInstance.func_188419_a().equals(PotionRegistry.SHRINKING.get())) {
            return;
        }
        if (currentEffects.contains(PotionRegistry.GROWTH.get())) {
            e.setResult(Event.Result.DENY);
            if (entity instanceof PlayerEntity) {
                entity.func_145747_a((ITextComponent)new StringTextComponent("You cannot shrink when enlarged, you must lose the effect first."), entity.func_110124_au());
            }
        } else {
            e.setResult(Event.Result.ALLOW);
        }
    }

    public static void shrinkAdded(PotionEvent.PotionAddedEvent e) {
        EffectInstance effectInstance = e.getPotionEffect();
        if (effectInstance.func_188419_a().equals(PotionRegistry.SHRINKING.get())) {
            effectInstance.func_199308_a(new EffectInstance((Effect)PotionRegistry.SHRINKING.get(), effectInstance.func_76459_b(), effectInstance.func_76458_c(), false, false, true));
            ScaleData baseScaleData = ScaleType.BASE.getScaleData(e.getEntity());
            ScaleData reachScaleData = ScaleType.REACH.getScaleData(e.getEntity());
            baseScaleData.setTargetScale(0.2f);
            reachScaleData.setTargetScale(2.0f);
        }
    }

    public static void shrinkExpired(PotionEvent.PotionExpiryEvent e) {
        Effect effect = e.getPotionEffect().func_188419_a();
        if (effect.equals(PotionRegistry.SHRINKING.get())) {
            ScaleData baseScaleData = ScaleType.BASE.getScaleData(e.getEntity());
            ScaleData reachScaleData = ScaleType.REACH.getScaleData(e.getEntity());
            baseScaleData.resetScale();
            reachScaleData.resetScale();
        }
    }

    public static void shrinkRemoved(PotionEvent.PotionRemoveEvent e) {
        Effect effect = e.getPotionEffect().func_188419_a();
        if (effect.equals(PotionRegistry.SHRINKING.get())) {
            ScaleData baseScaleData = ScaleType.BASE.getScaleData(e.getEntity());
            ScaleData reachScaleData = ScaleType.REACH.getScaleData(e.getEntity());
            baseScaleData.resetScale();
            reachScaleData.resetScale();
        }
    }
}

