/*
 * Decompiled with CFR 0.152.
 */
package virtuoel.pehkui.api;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.ResourceLocationException;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.loading.LogMarkers;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.jetbrains.annotations.ApiStatus;
import virtuoel.pehkui.api.ScaleRegistries;
import virtuoel.pehkui.api.ScaleType;

public class PehkuiConfig {
    @ApiStatus.Internal
    public static final ForgeConfigSpec clientSpec;
    public static final Client CLIENT;
    @ApiStatus.Internal
    public static final ForgeConfigSpec commonSpec;
    public static final Common COMMON;
    @ApiStatus.Internal
    public static final ForgeConfigSpec serverSpec;
    public static final Server SERVER;

    @SubscribeEvent
    @ApiStatus.Internal
    public static void onLoad(ModConfig.Loading configEvent) {
        LogManager.getLogger().debug(LogMarkers.FORGEMOD, "Loaded Pehkui config file {}", (Object)configEvent.getConfig().getFileName());
    }

    @SubscribeEvent
    @ApiStatus.Internal
    public static void onFileChange(ModConfig.Reloading configEvent) {
        LogManager.getLogger().debug(LogMarkers.FORGEMOD, "Pehkui config just got changed on the file system!");
    }

    @SafeVarargs
    private static <E> ArrayList<E> path(E ... elements) {
        ArrayList list = new ArrayList();
        Collections.addAll(list, elements);
        return list;
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Client::new);
        clientSpec = (ForgeConfigSpec)specPair.getRight();
        CLIENT = (Client)specPair.getLeft();
        specPair = new ForgeConfigSpec.Builder().configure(Common::new);
        commonSpec = (ForgeConfigSpec)specPair.getRight();
        COMMON = (Common)specPair.getLeft();
        specPair = new ForgeConfigSpec.Builder().configure(Server::new);
        serverSpec = (ForgeConfigSpec)specPair.getRight();
        SERVER = (Server)specPair.getLeft();
    }

    public static class Server {
        Server(ForgeConfigSpec.Builder builder) {
            builder.comment("Server configuration settings").push("server");
            builder.pop();
        }
    }

    public static class Common {
        public final ForgeConfigSpec.BooleanValue scaledFallDamage;
        public final ForgeConfigSpec.BooleanValue scaledMotion;
        public final ForgeConfigSpec.BooleanValue scaledReach;
        public final ForgeConfigSpec.BooleanValue scaledAttack;
        public final ForgeConfigSpec.BooleanValue scaledDefense;
        public final ForgeConfigSpec.BooleanValue scaledHealth;
        public final ForgeConfigSpec.BooleanValue scaledItemDrops;
        public final ForgeConfigSpec.BooleanValue scaledProjectiles;
        public final ForgeConfigSpec.BooleanValue scaledExplosions;
        public final ForgeConfigSpec.BooleanValue keepAllScalesOnRespawn;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> scalesKeptOnRespawn;
        public final ForgeConfigSpec.BooleanValue accurateNetherPortals;
        public final ForgeConfigSpec.DoubleValue largeScaleCollisionThreshold;

        Common(ForgeConfigSpec.Builder builder) {
            builder.comment("General configuration settings").push("general");
            this.scaledFallDamage = builder.translation("pehkui.configgui.scaledFallDamage").define("scaledFallDamage", true);
            this.scaledMotion = builder.translation("pehkui.configgui.scaledMotion").define("scaledMotion", true);
            this.scaledReach = builder.translation("pehkui.configgui.scaledReach").define("scaledReach", true);
            this.scaledAttack = builder.translation("pehkui.configgui.scaledAttack").define("scaledAttack", true);
            this.scaledDefense = builder.translation("pehkui.configgui.scaledDefense").define("scaledDefense", true);
            this.scaledHealth = builder.translation("pehkui.configgui.scaledHealth").define("scaledHealth", true);
            this.scaledItemDrops = builder.translation("pehkui.configgui.scaledItemDrops").define("scaledItemDrops", true);
            this.scaledProjectiles = builder.translation("pehkui.configgui.scaledProjectiles").define("scaledProjectiles", true);
            this.scaledExplosions = builder.translation("pehkui.configgui.scaledExplosions").define("scaledExplosions", true);
            this.keepAllScalesOnRespawn = builder.translation("pehkui.configgui.keepAllScalesOnRespawn").define("keepAllScalesOnRespawn", false);
            this.accurateNetherPortals = builder.translation("pehkui.configgui.accurateNetherPortals").define("accurateNetherPortals", true);
            this.scalesKeptOnRespawn = builder.translation("pehkui.configgui.scalesKeptOnRespawn").defineListAllowEmpty((List)PehkuiConfig.path(new String[]{"scalesKeptOnRespawn"}), ArrayList::new, s -> {
                try {
                    ResourceLocation id = new ResourceLocation(String.valueOf(s));
                    ScaleType scaleType = ScaleRegistries.getEntry(ScaleRegistries.SCALE_TYPES, id);
                    ResourceLocation defaultId = ScaleRegistries.getDefaultId(ScaleRegistries.SCALE_TYPES);
                    ScaleType defaultType = ScaleRegistries.getEntry(ScaleRegistries.SCALE_TYPES, defaultId);
                    return scaleType != null && (scaleType != defaultType || id.equals((Object)defaultId));
                }
                catch (ResourceLocationException e) {
                    return false;
                }
            });
            this.largeScaleCollisionThreshold = builder.translation("pehkui.configgui.largeScaleCollisionThreshold").defineInRange("largeScaleCollisionThreshold", 26.0, 16.0, 128.0);
            builder.pop();
        }
    }

    public static class Client {
        public final ForgeConfigSpec.DoubleValue minimumCameraDepth;

        Client(ForgeConfigSpec.Builder builder) {
            builder.comment("Client only settings, mostly things related to rendering").push("client");
            this.minimumCameraDepth = builder.translation("pehkui.configgui.minimumCameraDepth").defineInRange("minimumCameraDepth", 0.001, 0.0, 0.05);
            builder.pop();
        }
    }
}

