/*
 * Decompiled with CFR 0.152.
 */
package virtuoel.pehkui.api;

import net.minecraft.util.ResourceLocation;
import virtuoel.pehkui.Pehkui;
import virtuoel.pehkui.api.ScaleData;
import virtuoel.pehkui.api.ScaleRegistries;
import virtuoel.pehkui.api.ScaleType;

public class ScaleModifier
implements Comparable<ScaleModifier> {
    public static final ScaleModifier IDENTITY = ScaleModifier.register(ScaleRegistries.getDefaultId(ScaleRegistries.SCALE_MODIFIERS));
    public static final ScaleModifier BASE_MULTIPLIER = ScaleModifier.register("base_multiplier", new ScaleModifier(){

        @Override
        public float modifyScale(ScaleData scaleData, float modifiedScale, float delta) {
            return ScaleType.BASE.getScaleData(scaleData.getEntity()).getScale(delta) * modifiedScale;
        }
    });

    @Override
    public int compareTo(ScaleModifier o) {
        int c = Float.compare(o.getPriority(), this.getPriority());
        return c != 0 ? c : ScaleRegistries.getId(ScaleRegistries.SCALE_MODIFIERS, this).compareTo(ScaleRegistries.getId(ScaleRegistries.SCALE_MODIFIERS, o));
    }

    public float getPriority() {
        return 512.0f;
    }

    public float modifyScale(ScaleData scaleData, float modifiedScale, float delta) {
        return modifiedScale;
    }

    private static ScaleModifier register(String path, ScaleModifier scaleModifier) {
        return ScaleModifier.register(Pehkui.id(path), scaleModifier);
    }

    private static ScaleModifier register(ResourceLocation id, ScaleModifier scaleModifier) {
        return ScaleRegistries.register(ScaleRegistries.SCALE_MODIFIERS, id, scaleModifier);
    }

    private static ScaleModifier register(ResourceLocation id) {
        return ScaleModifier.register(id, new ScaleModifier());
    }
}

