/*
 * Decompiled with CFR 0.152.
 */
package virtuoel.pehkui.api;

import it.unimi.dsi.fastutil.objects.ObjectRBTreeSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import virtuoel.pehkui.Pehkui;
import virtuoel.pehkui.api.ScaleData;
import virtuoel.pehkui.api.ScaleEventCallback;
import virtuoel.pehkui.api.ScaleModifier;
import virtuoel.pehkui.api.ScaleRegistries;
import virtuoel.pehkui.entity.ResizableEntity;
import virtuoel.pehkui.mixin.EntityAccessor;
import virtuoel.pehkui.util.ScaleUtils;

public class ScaleType {
    public static final ScaleType INVALID = ScaleType.register(ScaleRegistries.getDefaultId(ScaleRegistries.SCALE_TYPES));
    public static final ScaleType BASE = ScaleType.registerBaseScale("base");
    public static final ScaleType WIDTH = ScaleType.registerDimensionScale("width");
    public static final ScaleType HEIGHT = ScaleType.registerDimensionScale("height");
    public static final ScaleType MOTION = ScaleType.register("motion", ScaleModifier.BASE_MULTIPLIER);
    public static final ScaleType REACH = ScaleType.register("reach", ScaleModifier.BASE_MULTIPLIER);
    public static final ScaleType ATTACK = ScaleType.register("attack", new ScaleModifier[0]);
    public static final ScaleType DEFENSE = ScaleType.register("defense", new ScaleModifier[0]);
    public static final ScaleType HEALTH = ScaleType.register("health", new ScaleModifier[0]);
    public static final ScaleType DROPS = ScaleType.register("drops", ScaleModifier.BASE_MULTIPLIER);
    public static final ScaleType PROJECTILES = ScaleType.register("projectiles", ScaleModifier.BASE_MULTIPLIER);
    public static final ScaleType EXPLOSIONS = ScaleType.register("explosions", ScaleModifier.BASE_MULTIPLIER);
    private float defaultBaseScale;
    private int defaultTickDelay;
    private final Set<ScaleModifier> defaultBaseValueModifiers;
    private final Collection<ScaleEventCallback> scaleChangedEvent = new ArrayList<ScaleEventCallback>();
    private final Collection<ScaleEventCallback> preTickEvent = new ArrayList<ScaleEventCallback>();
    private final Collection<ScaleEventCallback> postTickEvent = new ArrayList<ScaleEventCallback>();

    private ScaleType(Builder builder) {
        this(builder.defaultBaseScale, builder.defaultTickDelay, builder.defaultBaseValueModifiers);
    }

    private ScaleType(float defaultBaseScale, int defaultTickDelay, Set<ScaleModifier> defaultBaseValueModifiers) {
        this.defaultBaseScale = defaultBaseScale;
        this.defaultTickDelay = defaultTickDelay;
        this.defaultBaseValueModifiers = defaultBaseValueModifiers;
    }

    public ScaleData getScaleData(Entity entity) {
        return ((ResizableEntity)entity).pehkui_getScaleData(this);
    }

    public final float getDefaultBaseScale() {
        return this.defaultBaseScale;
    }

    public final int getDefaultTickDelay() {
        return this.defaultTickDelay;
    }

    public Set<ScaleModifier> getDefaultBaseValueModifiers() {
        return this.defaultBaseValueModifiers;
    }

    public Collection<ScaleEventCallback> getScaleChangedEvent() {
        return this.scaleChangedEvent;
    }

    public Collection<ScaleEventCallback> getPreTickEvent() {
        return this.preTickEvent;
    }

    public Collection<ScaleEventCallback> getPostTickEvent() {
        return this.postTickEvent;
    }

    private static ScaleType register(ResourceLocation id, Builder builder) {
        return ScaleRegistries.register(ScaleRegistries.SCALE_TYPES, id, builder.build());
    }

    private static ScaleType register(ResourceLocation id) {
        Builder builder = Builder.create();
        return ScaleType.register(id, builder);
    }

    private static ScaleType register(String path, ScaleModifier ... modifiers) {
        Builder builder = Builder.create();
        for (ScaleModifier scaleModifier : modifiers) {
            builder.addBaseValueModifier(scaleModifier);
        }
        return ScaleType.register(Pehkui.id(path), builder);
    }

    private static ScaleType registerBaseScale(String path) {
        Builder builder = Builder.create().affectsDimensions().addDependentModifier(ScaleModifier.BASE_MULTIPLIER);
        return ScaleType.register(Pehkui.id(path), builder);
    }

    private static ScaleType registerDimensionScale(String path) {
        Builder builder = Builder.create().affectsDimensions().addBaseValueModifier(ScaleModifier.BASE_MULTIPLIER);
        return ScaleType.register(Pehkui.id(path), builder);
    }

    public static class Builder {
        private Set<ScaleModifier> defaultBaseValueModifiers = new ObjectRBTreeSet();
        private float defaultBaseScale = 1.0f;
        private int defaultTickDelay = 20;
        private boolean affectsDimensions = false;
        private Set<ScaleModifier> dependentModifiers = new ObjectRBTreeSet();

        public static Builder create() {
            return new Builder();
        }

        private Builder() {
        }

        public void defaultBaseScale(float defaultBaseScale) {
            this.defaultBaseScale = defaultBaseScale;
        }

        public void defaultTickDelay(int defaultTickDelay) {
            this.defaultTickDelay = defaultTickDelay;
        }

        public Builder addBaseValueModifier(ScaleModifier scaleModifier) {
            this.defaultBaseValueModifiers.add(scaleModifier);
            return this;
        }

        public Builder affectsDimensions() {
            this.affectsDimensions = true;
            return this;
        }

        public Builder addDependentModifier(ScaleModifier scaleModifier) {
            this.dependentModifiers.add(scaleModifier);
            return this;
        }

        public ScaleType build() {
            ScaleType type = new ScaleType(this);
            if (this.affectsDimensions) {
                type.getScaleChangedEvent().add(Builder::calculateDimensions);
            }
            if (!this.dependentModifiers.isEmpty()) {
                type.getScaleChangedEvent().add(Builder.createModifiedDataSyncEvent(this.dependentModifiers));
            }
            return type;
        }

        private static void calculateDimensions(ScaleData s) {
            Entity e = s.getEntity();
            if (e != null) {
                EntityAccessor en = (EntityAccessor)e;
                boolean onGround = en.getOnGround();
                if (!ScaleUtils.isAboveCollisionThreshold(e)) {
                    e.func_213323_x_();
                }
                en.setOnGround(onGround);
            }
        }

        private static ScaleEventCallback createModifiedDataSyncEvent(Collection<ScaleModifier> modifiers) {
            return s -> {
                Entity e = s.getEntity();
                if (e != null) {
                    for (ScaleType scaleType : ScaleRegistries.SCALE_TYPES.values()) {
                        ScaleData data = scaleType.getScaleData(e);
                        if (Collections.disjoint(modifiers, data.getBaseValueModifiers())) continue;
                        data.markForSync(true);
                    }
                }
            };
        }
    }
}

