/*
 * Decompiled with CFR 0.152.
 */
package virtuoel.pehkui.mixin;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.Pose;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tags.ITag;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Constant;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.ModifyConstant;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;
import virtuoel.pehkui.api.PehkuiConfig;
import virtuoel.pehkui.api.ScaleData;
import virtuoel.pehkui.api.ScaleRegistries;
import virtuoel.pehkui.api.ScaleType;
import virtuoel.pehkui.entity.ResizableEntity;
import virtuoel.pehkui.util.ScaleUtils;

@Mixin(value={Entity.class})
public abstract class EntityMixin
implements ResizableEntity {
    @Shadow
    World field_70170_p;
    private final Map<ScaleType, ScaleData> pehkui_scaleTypes = new Object2ObjectOpenHashMap();

    @Override
    public ScaleData pehkui_getScaleData(ScaleType type) {
        ScaleData scaleData = this.pehkui_scaleTypes.get(type);
        if (!this.pehkui_scaleTypes.containsKey(type)) {
            scaleData = this.pehkui_constructScaleData(type);
            this.pehkui_scaleTypes.put(type, scaleData);
        }
        return scaleData;
    }

    @Inject(at={@At(value="HEAD")}, method={"fromTag"})
    private void onReadNbt(CompoundNBT tag, CallbackInfo info) {
        if (tag.func_150297_b("pehkui:scale_data_types", 10)) {
            CompoundNBT typeData = tag.func_74775_l("pehkui:scale_data_types");
            for (Map.Entry entry : ScaleRegistries.SCALE_TYPES.entrySet()) {
                String key = ((ResourceLocation)entry.getKey()).toString();
                if (!typeData.func_150297_b(key, 10)) continue;
                ScaleData scaleData = this.pehkui_getScaleData((ScaleType)entry.getValue());
                scaleData.readNbt(typeData.func_74775_l(key));
            }
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"toTag"})
    private void onWriteNbt(CompoundNBT tag, CallbackInfoReturnable<CompoundNBT> info) {
        CompoundNBT typeData = new CompoundNBT();
        for (Map.Entry entry : ScaleRegistries.SCALE_TYPES.entrySet()) {
            ScaleData scaleData = this.pehkui_getScaleData((ScaleType)entry.getValue());
            if (scaleData.isReset()) continue;
            CompoundNBT compound = new CompoundNBT();
            scaleData.writeNbt(compound);
            if (compound.func_186856_d() == 0) continue;
            typeData.func_218657_a(((ResourceLocation)entry.getKey()).toString(), (INBT)compound);
        }
        if (typeData.func_186856_d() > 0) {
            tag.func_218657_a("pehkui:scale_data_types", (INBT)typeData);
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"tick"})
    private void onTickPre(CallbackInfo info) {
        for (ScaleType type : ScaleRegistries.SCALE_TYPES.values()) {
            ScaleUtils.tickScale(this.pehkui_getScaleData(type));
        }
    }

    @Inject(at={@At(value="RETURN")}, method={"getDimensions"}, cancellable=true)
    private void onGetDimensions(Pose pose, CallbackInfoReturnable<EntitySize> info) {
        float widthScale = ScaleUtils.getWidthScale((Entity)this);
        float heightScale = ScaleUtils.getHeightScale((Entity)this);
        if (widthScale != 1.0f || heightScale != 1.0f) {
            info.setReturnValue((Object)((EntitySize)info.getReturnValue()).func_220312_a(widthScale, heightScale));
        }
    }

    @Inject(method={"dropStack(Lnet/minecraft/item/ItemStack;F)Lnet/minecraft/entity/ItemEntity;"}, locals=LocalCapture.CAPTURE_FAILHARD, at={@At(value="INVOKE", target="Lnet/minecraft/entity/ItemEntity;setToDefaultPickupDelay()V")})
    private void onDropStack(ItemStack stack, float yOffset, CallbackInfoReturnable<ItemEntity> info, ItemEntity entity) {
        ScaleUtils.setScaleOfDrop((Entity)entity, (Entity)this);
    }

    @ModifyArg(method={"fall"}, at=@At(value="INVOKE", target="Lnet/minecraft/block/Block;onLandedUpon(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/entity/Entity;F)V"))
    private float onFallModifyFallDistance(float distance) {
        float scale = ScaleUtils.getMotionScale((Entity)this);
        if (scale != 1.0f && ((Boolean)PehkuiConfig.COMMON.scaledFallDamage.get()).booleanValue()) {
            return distance / scale;
        }
        return distance;
    }

    @ModifyConstant(method={"move"}, constant={@Constant(doubleValue=1.0E-7)})
    private double moveModifyMinVelocity(double value) {
        float scale = ScaleUtils.getMotionScale((Entity)this);
        return scale < 1.0f ? (double)(scale * scale) * value : value;
    }

    @ModifyArg(method={"move"}, index=0, at=@At(value="INVOKE", target="Lnet/minecraft/entity/Entity;adjustMovementForSneaking(Lnet/minecraft/util/math/Vec3d;Lnet/minecraft/entity/MovementType;)Lnet/minecraft/util/math/Vec3d;"))
    private Vector3d onMoveAdjustMovementForSneakingProxy(Vector3d movement, MoverType type) {
        if (type == MoverType.SELF || type == MoverType.PLAYER) {
            return movement.func_186678_a((double)ScaleUtils.getMotionScale((Entity)this));
        }
        return movement;
    }

    @Inject(at={@At(value="HEAD")}, method={"spawnSprintingParticles"}, cancellable=true)
    private void onSpawnSprintingParticles(CallbackInfo info) {
        if (ScaleUtils.getMotionScale((Entity)this) < 1.0f) {
            info.cancel();
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"updateMovementInFluid"}, cancellable=true)
    private void onUpdateMovementInFluid(ITag<Fluid> tag, double d, CallbackInfoReturnable<Boolean> info) {
        if (ScaleUtils.isAboveCollisionThreshold((Entity)this)) {
            info.setReturnValue((Object)false);
        }
    }
}

