/*
 * Decompiled with CFR 0.152.
 */
package virtuoel.pehkui.mixin;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.util.DamageSource;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Constant;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.ModifyConstant;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import virtuoel.pehkui.api.PehkuiConfig;
import virtuoel.pehkui.mixin.EntityMixin;
import virtuoel.pehkui.util.ScaleUtils;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin
extends EntityMixin {
    @ModifyArg(method={"getEyeHeight"}, index=1, at=@At(value="INVOKE", target="Lnet/minecraft/entity/LivingEntity;getActiveEyeHeight(Lnet/minecraft/entity/EntityPose;Lnet/minecraft/entity/EntityDimensions;)F"))
    private EntitySize onGetEyeHeightDimensionsProxy(EntitySize dimensions) {
        return dimensions.func_220313_a(1.0f / ScaleUtils.getHeightScale((Entity)this));
    }

    @ModifyConstant(method={"travel"}, constant={@Constant(floatValue=1.0f, ordinal=0)})
    private float travelModifyFallDistance(float value) {
        float scale = ScaleUtils.getMotionScale((Entity)this);
        if (scale != 1.0f && ((Boolean)PehkuiConfig.COMMON.scaledFallDamage.get()).booleanValue()) {
            return value * scale;
        }
        return value;
    }

    @Inject(method={"getEyeHeight"}, at={@At(value="RETURN")}, cancellable=true)
    private void onGetEyeHeight(Pose pose, EntitySize dimensions, CallbackInfoReturnable<Float> info) {
        float scale;
        if (pose != Pose.SLEEPING && (scale = ScaleUtils.getHeightScale((Entity)this)) != 1.0f) {
            info.setReturnValue((Object)Float.valueOf(info.getReturnValueF() * scale));
        }
    }

    @ModifyConstant(method={"tickMovement"}, constant={@Constant(doubleValue=0.003)})
    private double tickMovementModifyMinVelocity(double value) {
        float scale = ScaleUtils.getMotionScale((Entity)this);
        return scale < 1.0f ? (double)scale * value : value;
    }

    @ModifyVariable(method={"applyArmorToDamage(Lnet/minecraft/entity/damage/DamageSource;F)F"}, at=@At(value="HEAD"), argsOnly=true)
    private float onApplyArmorToDamage(float value, DamageSource source, float amount) {
        Entity attacker = source.func_76346_g();
        float attackScale = attacker == null ? 1.0f : ScaleUtils.getAttackScale(attacker);
        float defenseScale = ScaleUtils.getDefenseScale((Entity)this);
        if (attackScale != 1.0f || defenseScale != 1.0f) {
            value = attackScale * value / defenseScale;
        }
        return value;
    }

    @Inject(method={"getMaxHealth"}, at={@At(value="RETURN")}, cancellable=true)
    private void onGetMaxHealth(CallbackInfoReturnable<Float> info) {
        float scale = ScaleUtils.getHealthScale((Entity)this);
        if (scale != 1.0f) {
            info.setReturnValue((Object)Float.valueOf(info.getReturnValueF() * scale));
        }
    }
}

