/*
 * Decompiled with CFR 0.152.
 */
package virtuoel.pehkui.mixin.compat116minus;

import net.minecraft.entity.Entity;
import net.minecraft.entity.monster.SlimeEntity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Constant;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.ModifyConstant;
import virtuoel.pehkui.util.ScaleUtils;

@Mixin(value={SlimeEntity.class})
public class SlimeEntityMixin {
    @ModifyArg(method={"remove"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/World;spawnEntity(Lnet/minecraft/entity/Entity;)Z"))
    private Entity removeSpawnEntityProxy(Entity entity) {
        ScaleUtils.loadScale(entity, (Entity)this);
        return entity;
    }

    @ModifyConstant(method={"remove"}, constant={@Constant(floatValue=4.0f)}, remap=false)
    private float removeModifyHorizontalOffset(float value) {
        float scale = ScaleUtils.getWidthScale((Entity)this);
        if (scale != 1.0f) {
            return value / scale;
        }
        return value;
    }

    @ModifyConstant(method={"remove"}, constant={@Constant(doubleValue=0.5)}, remap=false)
    private double removeModifyVerticalOffset(double value) {
        float scale = ScaleUtils.getHeightScale((Entity)this);
        if (scale != 1.0f) {
            return value * (double)scale;
        }
        return value;
    }
}

