/*
 * Decompiled with CFR 0.152.
 */
package virtuoel.pehkui.network;

import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.network.NetworkEvent;
import virtuoel.pehkui.api.ScaleData;
import virtuoel.pehkui.api.ScaleRegistries;
import virtuoel.pehkui.util.ScaleUtils;

public class ScalePacket {
    final UUID uuid;
    final ResourceLocation typeId;
    CompoundNBT nbt = null;
    ScaleData scaleData = null;

    public ScalePacket(ScaleData scaleData) {
        Entity e = scaleData.getEntity();
        this.uuid = e != null ? e.func_110124_au() : null;
        this.typeId = ScaleRegistries.getId(ScaleRegistries.SCALE_TYPES, scaleData.getScaleType());
        this.scaleData = scaleData;
    }

    private ScalePacket(UUID uuid, ResourceLocation typeId, CompoundNBT nbt) {
        this.uuid = uuid;
        this.typeId = typeId;
        this.nbt = nbt;
    }

    public static void handle(ScalePacket msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            if (ScaleRegistries.SCALE_TYPES.containsKey((Object)msg.typeId)) {
                Minecraft client = Minecraft.func_71410_x();
                for (Entity e : client.field_71441_e.func_217416_b()) {
                    if (!e.func_110124_au().equals(msg.uuid)) continue;
                    ScaleRegistries.getEntry(ScaleRegistries.SCALE_TYPES, msg.typeId).getScaleData(e).readNbt(msg.nbt);
                    break;
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }

    public static ScalePacket decode(PacketBuffer buf) {
        UUID uuid = buf.func_179253_g();
        ResourceLocation typeId = buf.func_192575_l();
        CompoundNBT scaleData = ScaleUtils.buildScaleNbtFromPacketByteBuf(buf);
        return new ScalePacket(uuid, typeId, scaleData);
    }

    public static void encode(ScalePacket msg, PacketBuffer buf) {
        msg.scaleData.toPacket(buf.func_179252_a(msg.uuid).func_192572_a(msg.typeId));
    }
}

