/*
 * Decompiled with CFR 0.152.
 */
package virtuoel.pehkui.util;

import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTDynamicOps;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.network.NetworkDirection;
import virtuoel.pehkui.api.PehkuiConfig;
import virtuoel.pehkui.api.ScaleData;
import virtuoel.pehkui.api.ScaleRegistries;
import virtuoel.pehkui.api.ScaleType;
import virtuoel.pehkui.entity.ResizableEntity;
import virtuoel.pehkui.network.PehkuiPacketHandler;
import virtuoel.pehkui.network.ScalePacket;

public class ScaleUtils {
    public static void tickScale(ScaleData data) {
        ScaleType type = data.getScaleType();
        type.getPreTickEvent().forEach(s -> s.onEvent(data));
        data.tick();
        type.getPostTickEvent().forEach(s -> s.onEvent(data));
    }

    public static void loadAverageScales(Entity target, Entity source, Entity ... sources) {
        for (ScaleType type : ScaleRegistries.SCALE_TYPES.values()) {
            ScaleData scaleData = type.getScaleData(target);
            ScaleData[] scales = new ScaleData[sources.length];
            for (int i = 0; i < sources.length; ++i) {
                scales[i] = type.getScaleData(sources[i]);
            }
            scaleData.averagedFromScales(type.getScaleData(source), scales);
        }
    }

    public static void loadScaleOnRespawn(PlayerEntity target, PlayerEntity source, boolean alive) {
        if (alive || ((Boolean)PehkuiConfig.COMMON.keepAllScalesOnRespawn.get()).booleanValue()) {
            ScaleUtils.loadScale((Entity)target, (Entity)source);
            return;
        }
        List keptScales = (List)PehkuiConfig.COMMON.scalesKeptOnRespawn.get();
        for (Map.Entry entry : ScaleRegistries.SCALE_TYPES.entrySet()) {
            if (!keptScales.contains(((ResourceLocation)entry.getKey()).toString())) continue;
            ScaleType type = (ScaleType)entry.getValue();
            type.getScaleData((Entity)target).fromScale(type.getScaleData((Entity)source));
        }
    }

    public static void loadScale(Entity target, Entity source) {
        for (ScaleType type : ScaleRegistries.SCALE_TYPES.values()) {
            type.getScaleData(target).fromScale(type.getScaleData(source));
        }
    }

    public static boolean isAboveCollisionThreshold(Entity entity) {
        double scaleThreshold;
        double threshold;
        float heightScale;
        float widthScale = ScaleUtils.getWidthScale(entity);
        double volume = widthScale * widthScale * (heightScale = ScaleUtils.getHeightScale(entity));
        return volume > (threshold = (scaleThreshold = ((Double)PehkuiConfig.COMMON.largeScaleCollisionThreshold.get()).doubleValue()) * scaleThreshold * scaleThreshold);
    }

    public static float setScaleOfDrop(Entity entity, Entity source) {
        return ScaleUtils.setScaleOnSpawn(entity, ScaleUtils.getDropScale(source));
    }

    public static float setScaleOfProjectile(Entity entity, Entity source) {
        return ScaleUtils.setScaleOnSpawn(entity, ScaleUtils.getProjectileScale(source));
    }

    public static float setScaleOnSpawn(Entity entity, float scale) {
        if (scale != 1.0f) {
            ScaleType.BASE.getScaleData(entity).setScale(scale);
        }
        return scale;
    }

    public static CompoundNBT buildScaleNbtFromPacketByteBuf(PacketBuffer buffer) {
        CompoundNBT scaleData = new CompoundNBT();
        float scale = buffer.readFloat();
        float prevScale = buffer.readFloat();
        float fromScale = buffer.readFloat();
        float toScale = buffer.readFloat();
        int scaleTicks = buffer.readInt();
        int totalScaleTicks = buffer.readInt();
        scaleData.func_74776_a("scale", scale);
        scaleData.func_74776_a("previous", prevScale);
        scaleData.func_74776_a("initial", fromScale);
        scaleData.func_74776_a("target", toScale);
        scaleData.func_74768_a("ticks", scaleTicks);
        scaleData.func_74768_a("total_ticks", totalScaleTicks);
        int baseModifierCount = buffer.readInt();
        if (baseModifierCount != 0) {
            ListNBT modifiers = new ListNBT();
            for (int i = 0; i < baseModifierCount; ++i) {
                modifiers.add((Object)NBTDynamicOps.field_210820_a.createString(buffer.func_150789_c(Short.MAX_VALUE)));
            }
            scaleData.func_218657_a("baseValueModifiers", (INBT)modifiers);
        }
        return scaleData;
    }

    public static void syncScalesIfNeeded(Entity entity, Consumer<IPacket<?>> packetSender) {
        ScaleUtils.syncScales(entity, packetSender, ScaleData::shouldSync, true);
    }

    public static void syncScalesOnTrackingStart(Entity entity, Consumer<IPacket<?>> packetSender) {
        ScaleUtils.syncScales(entity, packetSender, s -> !s.isReset(), false);
    }

    public static void syncScales(Entity entity, Consumer<IPacket<?>> packetSender, Predicate<ScaleData> condition, boolean unmark) {
        for (Map.Entry entry : ScaleRegistries.SCALE_TYPES.entrySet()) {
            ScaleData scaleData = ((ScaleType)entry.getValue()).getScaleData(entity);
            if (!condition.test(scaleData)) continue;
            packetSender.accept(PehkuiPacketHandler.INSTANCE.toVanillaPacket((Object)new ScalePacket(scaleData), NetworkDirection.PLAY_TO_CLIENT));
            if (!unmark) continue;
            scaleData.markForSync(false);
        }
    }

    public static float getWidthScale(Entity entity) {
        return ScaleUtils.getWidthScale(entity, 1.0f);
    }

    public static float getWidthScale(Entity entity, float tickDelta) {
        return ScaleUtils.getTypedScale(entity, ScaleType.WIDTH, tickDelta);
    }

    public static float getHeightScale(Entity entity) {
        return ScaleUtils.getHeightScale(entity, 1.0f);
    }

    public static float getHeightScale(Entity entity, float tickDelta) {
        return ScaleUtils.getTypedScale(entity, ScaleType.HEIGHT, tickDelta);
    }

    public static float getMotionScale(Entity entity) {
        return ScaleUtils.getMotionScale(entity, 1.0f);
    }

    public static float getMotionScale(Entity entity, float tickDelta) {
        return ScaleUtils.getConfigurableTypedScale(entity, ScaleType.MOTION, () -> ((ForgeConfigSpec.BooleanValue)PehkuiConfig.COMMON.scaledMotion).get(), tickDelta);
    }

    public static float getReachScale(Entity entity) {
        return ScaleUtils.getReachScale(entity, 1.0f);
    }

    public static float getReachScale(Entity entity, float tickDelta) {
        return ScaleUtils.getConfigurableTypedScale(entity, ScaleType.REACH, () -> ((ForgeConfigSpec.BooleanValue)PehkuiConfig.COMMON.scaledReach).get(), tickDelta);
    }

    public static float getAttackScale(Entity entity) {
        return ScaleUtils.getAttackScale(entity, 1.0f);
    }

    public static float getAttackScale(Entity entity, float tickDelta) {
        return ScaleUtils.getConfigurableTypedScale(entity, ScaleType.ATTACK, () -> ((ForgeConfigSpec.BooleanValue)PehkuiConfig.COMMON.scaledAttack).get(), tickDelta);
    }

    public static float getDefenseScale(Entity entity) {
        return ScaleUtils.getDefenseScale(entity, 1.0f);
    }

    public static float getDefenseScale(Entity entity, float tickDelta) {
        return ScaleUtils.getConfigurableTypedScale(entity, ScaleType.DEFENSE, () -> ((ForgeConfigSpec.BooleanValue)PehkuiConfig.COMMON.scaledDefense).get(), tickDelta);
    }

    public static float getHealthScale(Entity entity) {
        return ScaleUtils.getHealthScale(entity, 1.0f);
    }

    public static float getHealthScale(Entity entity, float tickDelta) {
        return ScaleUtils.getConfigurableTypedScale(entity, ScaleType.HEALTH, () -> ((ForgeConfigSpec.BooleanValue)PehkuiConfig.COMMON.scaledHealth).get(), tickDelta);
    }

    public static float getDropScale(Entity entity) {
        return ScaleUtils.getDropScale(entity, 1.0f);
    }

    public static float getDropScale(Entity entity, float tickDelta) {
        return ScaleUtils.getConfigurableTypedScale(entity, ScaleType.DROPS, () -> ((ForgeConfigSpec.BooleanValue)PehkuiConfig.COMMON.scaledItemDrops).get(), tickDelta);
    }

    public static float getProjectileScale(Entity entity) {
        return ScaleUtils.getProjectileScale(entity, 1.0f);
    }

    public static float getProjectileScale(Entity entity, float tickDelta) {
        return ScaleUtils.getConfigurableTypedScale(entity, ScaleType.PROJECTILES, () -> ((ForgeConfigSpec.BooleanValue)PehkuiConfig.COMMON.scaledProjectiles).get(), tickDelta);
    }

    public static float getExplosionScale(Entity entity) {
        return ScaleUtils.getExplosionScale(entity, 1.0f);
    }

    public static float getExplosionScale(Entity entity, float tickDelta) {
        return ScaleUtils.getConfigurableTypedScale(entity, ScaleType.EXPLOSIONS, () -> ((ForgeConfigSpec.BooleanValue)PehkuiConfig.COMMON.scaledExplosions).get(), tickDelta);
    }

    public static float getConfigurableTypedScale(Entity entity, ScaleType type, Supplier<Boolean> config, float tickDelta) {
        return config.get() != false ? ScaleUtils.getTypedScale(entity, type, tickDelta) : type.getDefaultBaseScale();
    }

    public static float getTypedScale(Entity entity, ScaleType type, float tickDelta) {
        if (!(entity instanceof ResizableEntity)) {
            return type.getDefaultBaseScale();
        }
        return type.getScaleData(entity).getScale(tickDelta);
    }
}

